/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.candidacy.CandidacySituationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class RegisteredDegreeCandidaciesSelectionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Comparator<StudentCandidacy> DEGREE_CANDIDACIES_COMPARATOR = new Comparator<StudentCandidacy>(){

        @Override
        public int compare(StudentCandidacy o1, StudentCandidacy o2) {
            int result = o1.getEntryPhase().compareTo(o2.getEntryPhase());
            if (result == 0) {
                result = o1.getActiveCandidacySituation().getSituationDate().compareTo((ReadableInstant)o2.getActiveCandidacySituation().getSituationDate());
            }
            if (result == 0) {
                ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
                result = o1.getExecutionDegree().getDegree().getNameFor(executionYear).compareTo(o2.getExecutionDegree().getDegree().getNameFor(executionYear));
            }
            if (result == 0) {
                result = o1.getRegistration().getNumber().compareTo(o2.getRegistration().getNumber());
            }
            if (result == 0) {
                result = o1.getPerson().getName().compareTo(o2.getPerson().getName());
            }
            if (result == 0) {
                result = o1.getPerson().getDocumentIdNumber().compareTo(o2.getPerson().getDocumentIdNumber());
            }
            return result != 0 ? result : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };
    private Space campus;
    private ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
    private EntryPhase entryPhase;
    private DateTime beginDate;
    private DateTime endDate;

    public Space getCampus() {
        return this.campus;
    }

    public void setCampus(Space campus) {
        this.campus = campus;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public EntryPhase getEntryPhase() {
        return this.entryPhase;
    }

    public void setEntryPhase(EntryPhase entryPhase) {
        this.entryPhase = entryPhase;
    }

    public DateTime getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(DateTime beginDate) {
        this.beginDate = beginDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(DateTime endDate) {
        this.endDate = endDate;
    }

    public List<StudentCandidacy> search(Set<Degree> allowedPrograms) {
        ArrayList<StudentCandidacy> degreeCandidacies = new ArrayList<StudentCandidacy>();
        for (ExecutionDegree executionDegree : this.getExecutionYear().getExecutionDegreesSet()) {
            if (executionDegree.getCampus() != this.getCampus()) continue;
            for (StudentCandidacy candidacy : executionDegree.getFirstCycleCandidaciesBy(CandidacySituationType.REGISTERED)) {
                DateTime situationDate = candidacy.getActiveCandidacySituation().getSituationDate();
                if (this.getBeginDate() != null && situationDate.isBefore((ReadableInstant)this.getBeginDate()) || this.getEndDate() != null && situationDate.isAfter((ReadableInstant)this.getEndDate()) || !candidacy.hasEntryPhase() || !candidacy.getEntryPhase().equals((Object)this.getEntryPhase()) || candidacy.getRegistration() != null && candidacy.getRegistration().isCanceled() || !allowedPrograms.contains(candidacy.getExecutionDegree().getDegree())) continue;
                degreeCandidacies.add(candidacy);
            }
        }
        Collections.sort(degreeCandidacies, DEGREE_CANDIDACIES_COMPARATOR);
        return degreeCandidacies;
    }

    public Spreadsheet export(Set<Degree> allowedPrograms) {
        Spreadsheet spreadsheet = new Spreadsheet(this.getCampus().getName());
        this.addHeaders(spreadsheet);
        List<StudentCandidacy> result = this.search(allowedPrograms);
        Collections.sort(result, DEGREE_CANDIDACIES_COMPARATOR);
        for (StudentCandidacy candidacy : result) {
            this.addRow(spreadsheet, candidacy);
        }
        return spreadsheet;
    }

    public String getFilename() {
        return new LocalDate().toString("ddMMyyyy") + "-Candidatos-" + this.campus.getName() + "-Fase" + this.entryPhase.getPhaseNumber() + ".xls";
    }

    private void addHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("Data de Matricula");
        spreadsheet.setHeader("Tipo Ingresso");
        spreadsheet.setHeader("Curso");
        spreadsheet.setHeader("N\u00ba de Aluno");
        spreadsheet.setHeader("Nome");
        spreadsheet.setHeader("B.I");
        spreadsheet.setHeader("Aluno deslocado");
        spreadsheet.setHeader("Localidade");
        spreadsheet.setHeader("Email " + Unit.getInstitutionAcronym());
        spreadsheet.setHeader("Email pessoal");
        spreadsheet.setHeader("Telefone");
        spreadsheet.setHeader("Telemovel");
        spreadsheet.setHeader("Deslocado da residencia");
        spreadsheet.setHeader("Turnos");
    }

    private void addRow(Spreadsheet spreadsheet, StudentCandidacy candidacy) {
        Spreadsheet.Row row = spreadsheet.addRow();
        Person person = candidacy.getPerson();
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        row.setCell(candidacy.getActiveCandidacySituation().getSituationDate().toString("dd/MM/yyyy HH:mm"));
        row.setCell(candidacy.getRegistration().getIngressionType().getCode());
        row.setCell(candidacy.getExecutionDegree().getDegree().getNameFor(executionYear).getContent());
        row.setCell(candidacy.getRegistration().getNumber().toString());
        row.setCell(person.getName());
        row.setCell(person.getDocumentIdNumber());
        row.setCell(candidacy.getDislocatedFromPermanentResidence() != null && candidacy.getDislocatedFromPermanentResidence() != false ? "Sim" : "Nao");
        row.setCell(person.getArea());
        row.setCell(person.getInstitutionalEmailAddressValue());
        row.setCell(this.getPersonalEmailAddress(person));
        row.setCell(this.getPhone(person));
        row.setCell(this.getMobilePhone(person));
        row.setCell(candidacy.getDislocatedFromPermanentResidence() != null && candidacy.getDislocatedFromPermanentResidence() != false ? "Sim" : "Nao");
        row.setCell(this.getShiftNames(candidacy));
    }

    private String getPersonalEmailAddress(Person person) {
        for (EmailAddress email : person.getEmailAddresses()) {
            if (!email.isPersonalType() || !email.hasValue()) continue;
            return email.getValue();
        }
        return "";
    }

    private String getPhone(Person person) {
        return person.hasDefaultPhone() && person.getDefaultPhone().hasNumber() ? person.getDefaultPhone().getNumber() : "";
    }

    private String getMobilePhone(Person person) {
        return person.hasDefaultMobilePhone() && person.getDefaultMobilePhone().hasNumber() ? person.getDefaultMobilePhone().getNumber() : "";
    }

    private String getShiftNames(StudentCandidacy candidacy) {
        if (candidacy.getRegistration() == null) {
            return " ";
        }
        Registration registration = candidacy.getRegistration();
        StringBuilder builder = new StringBuilder();
        for (Shift shift : registration.getShiftsFor(candidacy.getExecutionYear().getFirstExecutionPeriod())) {
            builder.append(shift.getNome()).append(",");
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

