/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.StudentLine;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStudentsUTLCandidates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ReportStudentsUTLCandidates.class);
    protected ExecutionYear forExecutionYear;
    protected List<StudentLine> correctStudentLines;
    protected List<StudentLine> erroneousStudentLines;
    protected CellStyle headerStyle;

    public ReportStudentsUTLCandidates(ExecutionYear forExecutionYear) {
        this.forExecutionYear = forExecutionYear;
        this.correctStudentLines = new ArrayList<StudentLine>();
        this.erroneousStudentLines = new ArrayList<StudentLine>();
    }

    public ReportStudentsUTLCandidates(ExecutionYear forExecutionYear, HSSFSheet sheet) {
        this(forExecutionYear);
        this.getStudentLines(sheet);
    }

    protected void getStudentLines(HSSFSheet sheet) {
        HSSFRow row;
        int i = 2;
        while ((row = sheet.getRow(i)) != null) {
            StudentLine studentLine = new StudentLine();
            boolean filledWithSuccess = studentLine.fillWithSpreadsheetRow(this.forExecutionYear, row);
            try {
                this.testIt(studentLine);
            }
            catch (Exception e) {
                filledWithSuccess = false;
            }
            if (filledWithSuccess) {
                this.correctStudentLines.add(studentLine);
            } else {
                this.erroneousStudentLines.add(studentLine);
            }
            ++i;
        }
    }

    public HSSFWorkbook generateReport() {
        HSSFWorkbook wb = new HSSFWorkbook();
        this.headerStyle = this.headerBackgroundStyle(wb);
        HSSFSheet sheet = wb.createSheet("Dados Academicos");
        this.addHeaders(sheet);
        this.addValues(sheet);
        return wb;
    }

    public HSSFWorkbook generateErrors() {
        HSSFWorkbook wb = new HSSFWorkbook();
        this.headerStyle = this.headerBackgroundStyle(wb);
        HSSFSheet sheet = wb.createSheet("Errors");
        this.addHeadersForErrors(sheet);
        this.addValuesForErrors(sheet);
        return wb;
    }

    private void addValuesForErrors(HSSFSheet sheet) {
        int i = 2;
        for (StudentLine studentLine : this.getErroneousStudentLines()) {
            try {
                String institutionCode = studentLine.getInstitutionCode();
                String institutionName = studentLine.getInstitutionName();
                String candidacyNumber = studentLine.getCandidacyNumber();
                String studentNumberForPrint = studentLine.getStudentNumberForPrint();
                String studentName = studentLine.getStudentName();
                String documentTypeName = studentLine.getDocumentTypeName();
                String documentNumber = studentLine.getDocumentNumber();
                HSSFRow row = sheet.createRow(i);
                this.addCellValue(row, this.onNullEmptyString(institutionCode), 0);
                this.addCellValue(row, this.onNullEmptyString(institutionName), 1);
                this.addCellValue(row, this.onNullEmptyString(candidacyNumber), 2);
                this.addCellValue(row, this.onNullEmptyString(studentNumberForPrint), 3);
                this.addCellValue(row, this.onNullEmptyString(studentName), 4);
                this.addCellValue(row, this.onNullEmptyString(documentTypeName), 5);
                this.addCellValue(row, this.onNullEmptyString(documentNumber), 6);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    private void addHeadersForErrors(HSSFSheet sheet) {
        sheet.createRow(0);
        sheet.createRow(1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionCode"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionName"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("candidacyNumber"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumberForPrint"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentTypeName"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentNumber"), 6);
    }

    private void fillRegimeTable(HSSFWorkbook wb) {
        HSSFSheet sheet = wb.createSheet("Regime");
        for (int i = 0; i <= 7; ++i) {
            HSSFRow row = sheet.createRow(i);
            row.createCell(0).setCellValue(false);
            row.createCell(1).setCellValue(false);
        }
    }

    protected void testIt(StudentLine studentLine) {
        String institutionCode = studentLine.getInstitutionCode();
        String institutionName = studentLine.getInstitutionName();
        String candidacyNumber = studentLine.getCandidacyNumber();
        String studentNumberForPrint = studentLine.getStudentNumberForPrint();
        String studentName = studentLine.getStudentName();
        String documentTypeName = studentLine.getDocumentTypeName();
        String documentNumber = studentLine.getDocumentNumber();
        String degreeCode = studentLine.getDegreeCode();
        String degreeName = studentLine.getDegreeName();
        String degreeTypeName = studentLine.getDegreeTypeName();
        Integer countNumberOfDegreeChanges = studentLine.getCountNumberOfDegreeChanges();
        Boolean hasMadeDegreeChange = studentLine.getHasMadeDegreeChange();
        LocalDate firstEnrolmentOnCurrentExecutionYear = studentLine.getFirstEnrolmentOnCurrentExecutionYear();
        String regime = studentLine.getRegime();
        String firstRegistrationExecutionYear = studentLine.getFirstRegistrationExecutionYear();
        Integer countNumberOfEnrolmentsYearsSinceRegistrationStart = studentLine.getCountNumberOfEnrolmentsYearsSinceRegistrationStart();
        Integer countNumberOfEnrolmentsYearsInIntegralRegime = studentLine.getCountNumberOfEnrolmentsYearsInIntegralRegime();
        Integer numberOfDegreeCurricularYears = studentLine.getNumberOfDegreeCurricularYears();
        Integer curricularYearOneYearAgo = studentLine.getCurricularYearOneYearAgo();
        BigDecimal numberOfEnrolledEctsOneYearAgo = studentLine.getNumberOfEnrolledEctsOneYearAgo();
        BigDecimal numberOfApprovedEctsOneYearAgo = studentLine.getNumberOfApprovedEctsOneYearAgo();
        Integer curricularYearInCurrentYear = studentLine.getCurricularYearInCurrentYear();
        Double numberOfEnrolledECTS = studentLine.getNumberOfEnrolledECTS();
        double numberOfDoneECTS = studentLine.getNumberOfDoneECTS();
        Money gratuityAmount = studentLine.getGratuityAmount();
        Integer numberOfMonthsExecutionYear = studentLine.getNumberOfMonthsExecutionYear();
        String firstMonthOfPayment = studentLine.getFirstMonthOfPayment();
        Boolean ownerOfCETQualification = studentLine.getOwnerOfCETQualification();
        boolean degreeQualificationOwner = studentLine.isDegreeQualificationOwner();
        boolean masterQualificationOwner = studentLine.isMasterQualificationOwner();
        boolean phdQualificationOwner = studentLine.isPhdQualificationOwner();
        boolean ownerOfCollegeQualification = studentLine.isOwnerOfCollegeQualification();
        String observations = studentLine.getObservations();
        String lastEnrolmentExecutionYear = studentLine.getLastEnrolledExecutionYear();
        String nif = studentLine.getNif();
    }

    protected void addValues(HSSFSheet sheet) {
        int i = 2;
        for (StudentLine studentLine : this.getCorrectStudentLines()) {
            try {
                String institutionCode = studentLine.getInstitutionCode();
                String institutionName = studentLine.getInstitutionName();
                String candidacyNumber = studentLine.getCandidacyNumber();
                String studentNumberForPrint = studentLine.getStudentNumberForPrint();
                String studentName = studentLine.getStudentName();
                String documentTypeName = studentLine.getDocumentTypeName();
                String documentNumber = studentLine.getDocumentNumber();
                String degreeCode = studentLine.getDegreeCode();
                String degreeName = studentLine.getDegreeName();
                String degreeTypeName = studentLine.getDegreeTypeName();
                Integer countNumberOfDegreeChanges = studentLine.getCountNumberOfDegreeChanges();
                Boolean hasMadeDegreeChange = studentLine.getHasMadeDegreeChange();
                LocalDate firstEnrolmentOnCurrentExecutionYear = studentLine.getFirstEnrolmentOnCurrentExecutionYear();
                String regime = studentLine.getRegime();
                String firstRegistrationExecutionYear = studentLine.getFirstRegistrationExecutionYear();
                Integer countNumberOfEnrolmentsYearsSinceRegistrationStart = studentLine.getCountNumberOfEnrolmentsYearsSinceRegistrationStart();
                Integer countNumberOfEnrolmentsYearsInIntegralRegime = studentLine.getCountNumberOfEnrolmentsYearsInIntegralRegime();
                double achievedDegreeEcts = studentLine.getNumberOfDoneECTS();
                Integer numberOfDegreeCurricularYears = studentLine.getNumberOfDegreeCurricularYears();
                Integer curricularYearOneYearAgo = studentLine.getCurricularYearOneYearAgo();
                BigDecimal numberOfEnrolledEctsOneYearAgo = studentLine.getNumberOfEnrolledEctsOneYearAgo();
                BigDecimal numberOfApprovedEctsOneYearAgo = studentLine.getNumberOfApprovedEctsOneYearAgo();
                Integer curricularYearInCurrentYear = studentLine.getCurricularYearInCurrentYear();
                Double numberOfEnrolledECTS = studentLine.getNumberOfEnrolledECTS();
                Money gratuityAmount = studentLine.getGratuityAmount();
                Integer numberOfMonthsExecutionYear = studentLine.getNumberOfMonthsExecutionYear();
                String firstMonthOfPayment = studentLine.getFirstMonthOfPayment();
                Boolean ownerOfCETQualification = studentLine.getOwnerOfCETQualification();
                boolean degreeQualificationOwner = studentLine.isDegreeQualificationOwner();
                boolean masterQualificationOwner = studentLine.isMasterQualificationOwner();
                boolean phdQualificationOwner = studentLine.isPhdQualificationOwner();
                boolean ownerOfCollegeQualification = studentLine.isOwnerOfCollegeQualification();
                String observations = studentLine.getObservations();
                String lastEnrolmentExecutionYear = studentLine.getLastEnrolledExecutionYear();
                String nif = studentLine.getNif();
                HSSFRow row = sheet.createRow(i);
                this.addCellValue(row, this.onNullEmptyString(institutionCode), 0);
                this.addCellValue(row, this.onNullEmptyString(institutionName), 1);
                this.addCellValue(row, this.onNullEmptyString(candidacyNumber), 2);
                this.addCellValue(row, this.onNullEmptyString(studentNumberForPrint), 3);
                this.addCellValue(row, this.onNullEmptyString(studentName), 4);
                this.addCellValue(row, this.onNullEmptyString(documentTypeName), 5);
                this.addCellValue(row, this.onNullEmptyString(documentNumber), 6);
                this.addCellValue(row, this.onNullEmptyString(degreeCode), 7);
                this.addCellValue(row, this.onNullEmptyString(degreeName), 8);
                this.addCellValue(row, this.onNullEmptyString(degreeTypeName), 9);
                this.addCellValue(row, "", 10);
                this.addCellValue(row, this.onNullEmptyString(countNumberOfDegreeChanges), 11);
                this.addCellValue(row, this.onNullEmptyString(hasMadeDegreeChange), 12);
                this.addCellValue(row, this.onNullEmptyString(firstEnrolmentOnCurrentExecutionYear), 13);
                this.addCellValue(row, this.onNullEmptyString(regime), 14);
                this.addCellValue(row, "", 15);
                this.addCellValue(row, this.onNullEmptyString(firstRegistrationExecutionYear), 16);
                this.addCellValue(row, this.onNullEmptyString(countNumberOfEnrolmentsYearsSinceRegistrationStart), 17);
                this.addCellValue(row, this.onNullEmptyString(countNumberOfEnrolmentsYearsInIntegralRegime), 18);
                this.addCellValue(row, this.onNullEmptyString(achievedDegreeEcts), 19);
                this.addCellValue(row, this.onNullEmptyString(numberOfDegreeCurricularYears), 20);
                this.addCellValue(row, this.onNullEmptyString(curricularYearOneYearAgo), 21);
                this.addCellValue(row, this.onNullEmptyString(numberOfEnrolledEctsOneYearAgo != null ? numberOfEnrolledEctsOneYearAgo.toString().replace('.', ',') : ""), 22);
                this.addCellValue(row, this.onNullEmptyString(numberOfApprovedEctsOneYearAgo != null ? numberOfApprovedEctsOneYearAgo.toString().replace('.', ',') : ""), 23);
                this.addCellValue(row, this.onNullEmptyString(curricularYearInCurrentYear), 24);
                this.addCellValue(row, this.onNullEmptyString(numberOfEnrolledECTS != null ? numberOfEnrolledECTS.toString().replace('.', ',') : ""), 25);
                this.addCellValue(row, this.onNullEmptyString(gratuityAmount != null ? gratuityAmount.toPlainString().replace('.', ',') : ""), 26);
                this.addCellValue(row, this.onNullEmptyString(numberOfMonthsExecutionYear), 27);
                this.addCellValue(row, this.onNullEmptyString(firstMonthOfPayment), 28);
                this.addCellValue(row, this.onNullEmptyString(ownerOfCETQualification), 29);
                this.addCellValue(row, this.onNullEmptyString(degreeQualificationOwner), 30);
                this.addCellValue(row, this.onNullEmptyString(masterQualificationOwner), 31);
                this.addCellValue(row, this.onNullEmptyString(phdQualificationOwner), 32);
                this.addCellValue(row, this.onNullEmptyString(ownerOfCollegeQualification), 33);
                this.addCellValue(row, this.onNullEmptyString(observations), 34);
                this.addCellValue(row, this.onNullEmptyString(lastEnrolmentExecutionYear), 35);
                this.addCellValue(row, this.onNullEmptyString(nif), 36);
                this.addCellValue(row, "", 37);
                ++i;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String onNullEmptyString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)((Boolean)value != false ? "label.yes" : "label.no"), (String[])new String[0]);
        }
        return value.toString();
    }

    protected void addHeaders(HSSFSheet sheet) {
        sheet.createRow(0);
        sheet.createRow(1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionCode"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionName"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("candidacyNumber"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumberForPrint"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentTypeName"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentNumber"), 6);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeCode"), 7);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeName"), 8);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeTypeName"), 9);
        this.addHeaderCell(sheet, this.getHeaderInBundle("code"), 10);
        this.addHeaderCell(sheet, this.getHeaderInBundle("countNumberOfDegreeChanges"), 11);
        this.addHeaderCell(sheet, this.getHeaderInBundle("hasMadeDegreeChange"), 12);
        this.addHeaderCell(sheet, this.getHeaderInBundle("firstEnrolmentOnCurrentExecutionYear"), 13);
        this.addHeaderCell(sheet, this.getHeaderInBundle("regime"), 14);
        this.addHeaderCell(sheet, this.getHeaderInBundle("code"), 15);
        HSSFRow row = sheet.getRow(0);
        HSSFCell cell = row.createCell(16);
        cell.setCellValue(this.getHeaderInBundle("ingression.year.on.cycle.studies"));
        cell.setCellStyle(this.headerStyle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 16, 18));
        cell = sheet.getRow(1).createCell(16);
        cell.setCellValue(this.getHeaderInBundle("ingression.year.on.cycle.studies.year"));
        cell.setCellStyle(this.headerStyle);
        cell = sheet.getRow(1).createCell(17);
        cell.setCellValue(this.getHeaderInBundle("ingression.year.on.cycle.studies.count"));
        cell.setCellStyle(this.headerStyle);
        cell = sheet.getRow(1).createCell(18);
        cell.setCellValue(this.getHeaderInBundle("ingression.year.on.cycle.studies.integral.count"));
        cell.setCellStyle(this.headerStyle);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfDoneECTS"), 19);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfDegreeCurricularYears"), 20);
        this.addHeaderCell(sheet, this.getHeaderInBundle("curricularYearOneYearAgo"), 21);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfEnrolledEctsOneYearAgo"), 22);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfApprovedEctsOneYearAgo"), 23);
        this.addHeaderCell(sheet, this.getHeaderInBundle("curricularYearInCurrentYear"), 24);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfEnrolledECTS"), 25);
        this.addHeaderCell(sheet, this.getHeaderInBundle("gratuityAmount"), 26);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfMonthsExecutionYear"), 27);
        this.addHeaderCell(sheet, this.getHeaderInBundle("firstMonthOfPayment"), 28);
        this.addHeaderCell(sheet, this.getHeaderInBundle("ownerOfCETQualification"), 29);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeQualificationOwner"), 30);
        this.addHeaderCell(sheet, this.getHeaderInBundle("masterQualificationOwner"), 31);
        this.addHeaderCell(sheet, this.getHeaderInBundle("phdQualificationOwner"), 32);
        this.addHeaderCell(sheet, this.getHeaderInBundle("ownerOfCollegeQualification"), 33);
        this.addHeaderCell(sheet, this.getHeaderInBundle("observations"), 34);
        this.addHeaderCell(sheet, this.getHeaderInBundle("lastEnrolledExecutionYear"), 35);
        this.addHeaderCell(sheet, this.getHeaderInBundle("nif"), 36);
        this.addHeaderCell(sheet, this.getHeaderInBundle("last.conclusion.academic.facts"), 37);
    }

    protected String getHeaderInBundle(String field) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)("label.org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.StudentLine." + field), (String[])new String[0]);
    }

    protected void addHeaderCell(HSSFSheet sheet, String value, int columnNumber) {
        HSSFRow row = sheet.getRow(0);
        HSSFCell cell = row.createCell(columnNumber);
        cell.setCellValue(value);
        cell.setCellStyle(this.headerStyle);
        sheet.addMergedRegion(new CellRangeAddress(0, 1, columnNumber, columnNumber));
    }

    private CellStyle headerBackgroundStyle(HSSFWorkbook wb) {
        HSSFCellStyle style = wb.createCellStyle();
        style.setFillBackgroundColor(IndexedColors.AQUA.getIndex());
        style.setFillPattern((short)9);
        return style;
    }

    protected void addCellValue(HSSFRow row, String value, int cellNumber) {
        HSSFCell cell = row.createCell(cellNumber);
        cell.setCellValue(value);
    }

    private void addCellFormula(HSSFRow row, String value, int cellNumber) {
        HSSFCell cell = row.createCell(cellNumber);
        cell.setCellFormula(value);
    }

    public List<StudentLine> getCorrectStudentLines() {
        return this.correctStudentLines;
    }

    public List<StudentLine> getErroneousStudentLines() {
        return this.erroneousStudentLines;
    }
}

