/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionCourseEditor;
import org.fenixedu.academic.dto.resourceAllocationManager.CourseLoadBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.DeleteExecutionCourses;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.EditExecutionCourseInfo;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadInfoExecutionCourseByOID;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.EditExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.ExecutionCourseBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.utils.RequestUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/editExecutionCourse", module="academicAdministration", input="/editExecutionCourse.do?method=prepareEditECChooseExecDegreeAndCurYear&amp;page=0", formBean="executionCourseForm", functionality=EditExecutionCourseDA.class)
@Forwards(value={@Forward(name="editExecutionCourse", path="/academicAdministration/executionCourseManagement/editExecutionCourse.jsp"), @Forward(name="viewExecutionCourse", path="/academicAdministration/executionCourseManagement/viewExecutionCourse.jsp"), @Forward(name="listExecutionCourseActions", path="/academicAdministration/executionCourseManagement/listExecutionCourseActions.jsp")})
public class EditExecutionCourseDispatchAction
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(EditExecutionCourseDispatchAction.class);

    public ActionForward editExecutionCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        InfoExecutionCourse infoExecutionCourse;
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        try {
            infoExecutionCourse = ReadInfoExecutionCourseByOID.run(executionCourseId);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        request.setAttribute("execution_course", (Object)infoExecutionCourse);
        this.fillForm(form, infoExecutionCourse, request);
        ArrayList<LabelValueBean> entryPhases = new ArrayList<LabelValueBean>();
        for (EntryPhase entryPhase : EntryPhase.values()) {
            LabelValueBean labelValueBean = new LabelValueBean(entryPhase.getLocalizedName(), entryPhase.getName());
            entryPhases.add(labelValueBean);
        }
        request.setAttribute("entryPhases", entryPhases);
        DynaActionForm executionCourseForm = this.prepareReturnAttributes(form, request);
        this.prepareReturnSessionBean(request, (Boolean)executionCourseForm.get("executionCoursesNotLinked"), executionCourseId);
        return mapping.findForward("editExecutionCourse");
    }

    public ActionForward updateExecutionCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InfoExecutionCourseEditor infoExecutionCourseEditor = this.fillInfoExecutionCourseFromForm(actionForm, request);
        InfoExecutionCourse infoExecutionCourse = null;
        try {
            infoExecutionCourse = EditExecutionCourseInfo.run(infoExecutionCourseEditor);
        }
        catch (FenixServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FenixActionException(e.getMessage());
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getMessage(), ex.getArgs());
            return this.editExecutionCourse(mapping, actionForm, request, response);
        }
        request.setAttribute("execution_course", (Object)infoExecutionCourse);
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        DynaActionForm executionCourseForm = this.prepareReturnAttributes(actionForm, request);
        this.prepareReturnSessionBean(request, (Boolean)executionCourseForm.get("executionCoursesNotLinked"), executionCourseId);
        return mapping.findForward("viewExecutionCourse");
    }

    public ActionForward deleteExecutionCourse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        DynaActionForm executionCourseForm = this.prepareReturnAttributes(form, request);
        ArrayList<String> internalIds = new ArrayList<String>();
        internalIds.add(executionCourseId);
        List<Object> errorCodes = new ArrayList();
        ExecutionCourse executionCourseToBeDeleted = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        String executionCourseName = executionCourseToBeDeleted.getNome();
        String executionCourseSigla = executionCourseToBeDeleted.getSigla();
        try {
            errorCodes = DeleteExecutionCourses.run(internalIds);
        }
        catch (FenixServiceException fenixServiceException) {
            throw new FenixActionException(fenixServiceException.getMessage());
        }
        if (!errorCodes.isEmpty()) {
            for (String string : errorCodes) {
                this.addActionMessage("error", request, "errors.invalid.delete.not.empty.execution.course", string);
            }
        } else {
            this.addActionMessage("success", request, "message.manager.executionCourseManagement.deleteExecutionCourse.success", executionCourseName, executionCourseSigla);
        }
        this.prepareReturnSessionBean(request, (Boolean)executionCourseForm.get("executionCoursesNotLinked"), null);
        return mapping.findForward("listExecutionCourseActions");
    }

    private void fillForm(ActionForm form, InfoExecutionCourse infoExecutionCourse, HttpServletRequest request) {
        DynaActionForm executionCourseForm = (DynaActionForm)form;
        executionCourseForm.set("name", (Object)infoExecutionCourse.getNome());
        executionCourseForm.set("code", (Object)infoExecutionCourse.getSigla());
        executionCourseForm.set("comment", (Object)infoExecutionCourse.getComment());
        executionCourseForm.set("entryPhase", (Object)infoExecutionCourse.getEntryPhase().getName());
        if (infoExecutionCourse.getAvailableGradeSubmission() != null) {
            executionCourseForm.set("availableGradeSubmission", (Object)infoExecutionCourse.getAvailableGradeSubmission().toString());
        }
        request.setAttribute("courseLoadBean", (Object)new CourseLoadBean(infoExecutionCourse.getExecutionCourse()));
    }

    protected DynaActionForm prepareReturnAttributes(ActionForm form, HttpServletRequest request) {
        this.separateLabel(form, request, "executionPeriod", "executionPeriodId", "executionPeriodName");
        String executionCoursesNotLinked = RequestUtils.getAndSetStringToRequest(request, "executionCoursesNotLinked");
        DynaValidatorForm executionCourseForm = (DynaValidatorForm)form;
        Boolean chooseNotLinked = null;
        if (executionCoursesNotLinked == null || executionCoursesNotLinked.equals("null") || executionCoursesNotLinked.equals(Boolean.FALSE.toString())) {
            this.separateLabel(form, request, "executionDegree", "executionDegreeId", "executionDegreeName");
            this.separateLabel(form, request, "curYear", "curYearId", "curYearName");
            String curYear = (String)request.getAttribute("curYear");
            executionCourseForm.set("curYear", (Object)curYear);
            chooseNotLinked = new Boolean(false);
        } else {
            chooseNotLinked = new Boolean(executionCoursesNotLinked);
            executionCourseForm.set("executionCoursesNotLinked", (Object)chooseNotLinked);
        }
        return executionCourseForm;
    }

    protected void prepareReturnSessionBean(HttpServletRequest request, Boolean chooseNotLinked, String executionCourseId) {
        String executionPeriodId = (String)request.getAttribute("executionPeriodId");
        ExecutionCourse executionCourse = null;
        if (!StringUtils.isEmpty((String)executionCourseId)) {
            executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        }
        ExecutionSemester executionPeriod = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        ExecutionCourseBean sessionBean = new ExecutionCourseBean();
        sessionBean.setSourceExecutionCourse(executionCourse);
        sessionBean.setExecutionSemester(executionPeriod);
        sessionBean.setChooseNotLinked(chooseNotLinked);
        if (!chooseNotLinked.booleanValue()) {
            String executionDegreeId = (String)request.getAttribute("executionDegreeId");
            String curricularYearId = (String)request.getAttribute("curYearId");
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)executionDegreeId);
            CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
            sessionBean.setExecutionDegree(executionDegree);
            sessionBean.setCurricularYear(curYear);
        }
        request.setAttribute("sessionBean", (Object)sessionBean);
    }

    private InfoExecutionCourseEditor fillInfoExecutionCourseFromForm(ActionForm actionForm, HttpServletRequest request) {
        InfoExecutionCourseEditor infoExecutionCourse = new InfoExecutionCourseEditor();
        DynaActionForm editExecutionCourseForm = (DynaActionForm)actionForm;
        try {
            infoExecutionCourse.setExternalId((String)editExecutionCourseForm.get("executionCourseId"));
            infoExecutionCourse.setNome((String)editExecutionCourseForm.get("name"));
            infoExecutionCourse.setSigla((String)editExecutionCourseForm.get("code"));
            infoExecutionCourse.setComment((String)editExecutionCourseForm.get("comment"));
            infoExecutionCourse.setAvailableGradeSubmission(Boolean.valueOf(editExecutionCourseForm.getString("availableGradeSubmission")));
            infoExecutionCourse.setEntryPhase(EntryPhase.valueOf(editExecutionCourseForm.getString("entryPhase")));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return infoExecutionCourse;
    }

    protected String separateLabel(ActionForm form, HttpServletRequest request, String property, String id, String name) {
        DynaActionForm executionCourseForm = (DynaActionForm)form;
        String object = (String)executionCourseForm.get(property);
        if ((object == null || object.length() <= 0) && (object = (String)request.getAttribute(property)) == null) {
            object = request.getParameter(property);
        }
        String objectId = null;
        String objectName = null;
        if (object != null && object.length() > 0 && object.indexOf("~") > 0) {
            executionCourseForm.set(property, (Object)object);
            request.setAttribute(property, (Object)object);
            objectId = StringUtils.substringAfter((String)object, (String)"~");
            objectName = object.substring(0, object.indexOf("~"));
            request.setAttribute(name, (Object)objectName);
            request.setAttribute(id, (Object)objectId);
        }
        return objectId;
    }
}

