/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.UnitGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accessControl.rules.AccessTarget;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean$callable$create;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean$callable$edit;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean$callable$editAuthorizationPrograms;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean$callable$revoke;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AuthorizationGroupBean
implements Serializable,
Comparable<AuthorizationGroupBean> {
    private static final long serialVersionUID = -8809011815711452960L;
    private AcademicAccessRule rule;
    private Group whoCanAccess;
    private Set<AcademicProgram> programs;
    private Set<AdministrativeOffice> offices;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$editAuthorizationPrograms = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$revoke = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public AuthorizationGroupBean() {
        this.programs = new HashSet<AcademicProgram>();
        this.offices = new HashSet<AdministrativeOffice>();
    }

    public AuthorizationGroupBean(AcademicAccessRule rule) {
        this.setRule(rule);
    }

    public String getId() {
        return this.rule == null ? "-1" : this.rule.getExternalId();
    }

    public AcademicAccessRule getRule() {
        return this.rule;
    }

    private void setRule(AcademicAccessRule rule) {
        this.rule = rule;
        if (rule != null) {
            this.whoCanAccess = rule.getWhoCanAccess();
            this.programs = new HashSet<AcademicProgram>(rule.getProgramSet());
            this.offices = new HashSet<AdministrativeOffice>(rule.getOfficeSet());
        }
    }

    public Group getWhoCanAccess() {
        return this.whoCanAccess;
    }

    public void setWhoCanAccess(Group whoCanAccess) {
        this.whoCanAccess = whoCanAccess;
    }

    public boolean getNewObject() {
        return this.rule == null;
    }

    public Party getParty() {
        if (this.whoCanAccess != null) {
            if (this.whoCanAccess instanceof UnitGroup) {
                return ((UnitGroup)this.whoCanAccess).getUnit();
            }
            if (this.whoCanAccess instanceof UserGroup) {
                return ((User)((UserGroup)this.whoCanAccess).getMembers().iterator().next()).getPerson();
            }
        }
        return null;
    }

    public void setParty(Party party) {
        this.whoCanAccess = party instanceof Unit ? UnitGroup.workers((Unit)((Object)party)) : ((Person)((Object)party)).getPersonGroup();
    }

    public Set<AcademicProgram> getPrograms() {
        return this.programs;
    }

    public void setPrograms(Set<AcademicProgram> programs) {
        this.programs = programs;
    }

    public Set<AdministrativeOffice> getOffices() {
        return this.offices;
    }

    public void setOffices(Set<AdministrativeOffice> offices) {
        this.offices = offices;
    }

    public void edit() {
        Object object = advice$edit.perform((Callable)new AuthorizationGroupBean$callable$edit(this));
    }

    static /* synthetic */ void advised$edit(AuthorizationGroupBean this_) {
        this_.rule.changeWhoCanAccess(this_.whoCanAccess);
    }

    public <T extends AccessTarget> void create(AcademicOperationType academicOperationType, Set<AcademicAccessRule.AcademicAccessTarget> set) {
        Object object = advice$create.perform((Callable)new AuthorizationGroupBean$callable$create(this, academicOperationType, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$create(AuthorizationGroupBean this_, AcademicOperationType operation, Set whatCanAffect) {
        this_.setRule(operation.grant(this_.whoCanAccess, whatCanAffect).orElse(null));
    }

    public <T extends AccessTarget> void editAuthorizationPrograms(AcademicOperationType academicOperationType, Set<AcademicAccessRule.AcademicAccessTarget> set) {
        Object object = advice$editAuthorizationPrograms.perform((Callable)new AuthorizationGroupBean$callable$editAuthorizationPrograms(this, academicOperationType, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$editAuthorizationPrograms(AuthorizationGroupBean this_, AcademicOperationType operation, Set whatCanAffect) {
        this_.setRule(this_.rule.changeWhatCanAffect(whatCanAffect).orElse(null));
    }

    public void revoke() {
        Object object = advice$revoke.perform((Callable)new AuthorizationGroupBean$callable$revoke(this));
    }

    static /* synthetic */ void advised$revoke(AuthorizationGroupBean this_) {
        this_.rule.revoke();
        this_.setRule(null);
    }

    @Override
    public int compareTo(AuthorizationGroupBean o) {
        if (this.getId() == "-1") {
            return -1;
        }
        return this.rule.compareTo(o.rule);
    }
}

