/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAuthorizationManagementDispatchAction$callable$revoke;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationGroupBean;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AuthorizationsManagementBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.class, path="authorizations", titleKey="label.authorizations", accessGroup="academic(MANAGE_AUTHORIZATIONS)")
@Mapping(path="/authorizations", module="academicAdministration")
@Forwards(value={@Forward(name="listAuthorizations", path="/academicAdministration/authorizations/authorizations.jsp"), @Forward(name="manageOperationAuthorization", path="/academicAdministration/authorizations/authorizationsPerPerson.jsp")})
public class AcademicAuthorizationManagementDispatchAction
extends FenixDispatchAction {
    public static final Advice advice$revoke = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @EntryPoint
    public ActionForward authorizations(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        TreeMap groups = AcademicAccessRule.accessRules().map(AuthorizationGroupBean::new).sorted().collect(Collectors.groupingBy(r -> r.getRule().getOperation(), TreeMap::new, Collectors.toSet()));
        for (AcademicOperationType operation : AcademicOperationType.values()) {
            if (groups.containsKey(operation)) continue;
            groups.put(operation, Collections.emptySet());
        }
        request.setAttribute("groups", groups.entrySet());
        return mapping.findForward("listAuthorizations");
    }

    public ActionForward manageOperation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        if (bean == null) {
            bean = new AuthorizationsManagementBean(AcademicOperationType.valueOf(request.getParameter("operation")));
        }
        if (request.getParameter("removeNewAuthorization") != null) {
            bean.removeAuthorization("-1");
        }
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward addNewAuthorization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        bean.addNewAuthorization();
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward deleteAuthorization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        bean.removeAuthorization(request.getParameter("oid"));
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward editAuthorization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        bean.editAuthorization(request.getParameter("oid"));
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward editAuthorizationPrograms(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        bean.editAuthorizationPrograms(request.getParameter("oid"), request.getParameter("courses"), request.getParameter("offices"));
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward createAuthorization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AuthorizationsManagementBean bean = (AuthorizationsManagementBean)this.getRenderedObject("authorizationsBean");
        try {
            bean.createAuthorization(request.getParameter("courses"), request.getParameter("offices"));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        request.setAttribute("authorizationsBean", (Object)bean);
        return mapping.findForward("manageOperationAuthorization");
    }

    public ActionForward revokeRule(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AcademicAccessRule rule = (AcademicAccessRule)this.getDomainObject(request, "ruleId");
        this.revoke(rule);
        return this.authorizations(mapping, actionForm, request, response);
    }

    private void revoke(AcademicAccessRule academicAccessRule) {
        Object object = advice$revoke.perform((Callable)new AcademicAuthorizationManagementDispatchAction$callable$revoke(this, academicAccessRule));
    }

    static /* synthetic */ void advised$revoke(AcademicAuthorizationManagementDispatchAction this_, AcademicAccessRule rule) {
        rule.revoke();
    }
}

