/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class UIDataRepeater
extends UIData {
    private static final String COMPONENT_FAMILY = "DataRepeater";
    private String rowIndexVar;
    private String rowCountVar;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + "_" + rowIndex;
    }

    public void processDecodes(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            for (UIComponent child : this.getChildren()) {
                child.setId(child.getId());
                if (!child.isRendered()) continue;
                child.processDecodes(context);
            }
        }
        this.setRowIndex(-1);
        super.processDecodes(context);
    }

    public void processUpdates(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            for (UIComponent child : this.getChildren()) {
                child.setId(child.getId());
                if (!child.isRendered()) continue;
                child.processUpdates(context);
            }
        }
        this.setRowIndex(-1);
        super.processUpdates(context);
    }

    public void processValidators(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            for (UIComponent child : this.getChildren()) {
                child.setId(child.getId());
                if (!child.isRendered()) continue;
                child.processValidators(context);
            }
        }
        this.setRowIndex(-1);
        super.processValidators(context);
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        if (rowIndexVar != null || rowCountVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(this.getRowIndexVar(), new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(this.getRowCountVar(), new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(this.getRowIndexVar());
                }
                if (rowCountVar != null) {
                    requestMap.remove(this.getRowCountVar());
                }
            }
        }
    }

    public void setRowIndexVar(String rowIndexVar) {
        this.rowIndexVar = rowIndexVar;
    }

    public String getRowIndexVar() {
        if (this.rowIndexVar != null) {
            return this.rowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("rowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowCountVar(String rowCountVar) {
        this.rowCountVar = rowCountVar;
    }

    public String getRowCountVar() {
        if (this.rowCountVar != null) {
            return this.rowCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object saveState(FacesContext stateToSave) {
        Object[] state = new Object[]{super.saveState(stateToSave), this.getRowCountVar(), this.getRowIndexVar()};
        return state;
    }

    public void restoreState(FacesContext context, Object stateToRestore) {
        Object[] state = (Object[])stateToRestore;
        super.restoreState(context, state[0]);
        this.setRowCountVar((String)state[1]);
        this.setRowIndexVar((String)state[2]);
    }

    public Object getValue() {
        return super.getValue() instanceof Collection ? new ArrayList((Collection)super.getValue()) : super.getValue();
    }
}

