/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.curricularPlans;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.fenixframework.FenixFramework;

public class CourseGroupReportBackingBean
extends FenixBackingBean {
    private InfoToExport infoToExport;
    private final boolean rootWasClicked;
    private String name = null;
    private String courseGroupID;
    private final Map<Context, String> contextPaths = new HashMap<Context, String>();

    public CourseGroupReportBackingBean() throws FenixServiceException {
        this.rootWasClicked = this.getDegreeCurricularPlan().getRoot().equals((Object)this.getCourseGroup());
    }

    public Boolean getRootWasClicked() {
        return this.rootWasClicked;
    }

    public String getDegreeCurricularPlanID() {
        return this.getAndHoldStringParameter("degreeCurricularPlanID");
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() throws FenixServiceException {
        return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)this.getDegreeCurricularPlanID());
    }

    public String getCourseGroupID() {
        return this.courseGroupID != null ? this.courseGroupID : this.getAndHoldStringParameter("courseGroupID");
    }

    public void setCourseGroupID(String courseGroupID) {
        this.courseGroupID = courseGroupID;
    }

    public CourseGroup getCourseGroup() {
        return (CourseGroup)FenixFramework.getDomainObject((String)this.getCourseGroupID());
    }

    public String getName() throws FenixServiceException {
        return this.name == null && this.getCourseGroupID() != null ? this.getCourseGroup().getName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void exportCourseGroupCurricularStructureToExcel() throws FenixServiceException {
        this.infoToExport = InfoToExport.CURRICULAR_STRUCTURE;
        this.exportToExcel();
    }

    public void exportCourseGroupStudiesPlanToExcel() throws FenixServiceException {
        this.infoToExport = InfoToExport.STUDIES_PLAN;
        this.exportToExcel();
    }

    public Map<Context, String> getContextPaths() {
        return this.contextPaths;
    }

    public void exportToExcel() throws FenixServiceException {
        String filename = this.getDegreeCurricularPlan().getName().replace(" ", "_") + "-";
        filename = filename + (this.infoToExport.equals((Object)InfoToExport.CURRICULAR_STRUCTURE) ? "Estrutura_Curricular" : "Plano_de_Estudos");
        if (!this.rootWasClicked) {
            filename = filename + "-" + this.getCourseGroup().getName().replace(" ", "_");
        }
        filename = filename + "-" + this.getFileName(Calendar.getInstance().getTime());
        try {
            this.exportToXls(filename);
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
    }

    private List<Context> contextsWithCurricularCoursesToList(CourseGroup startingPoint) throws FenixServiceException {
        ArrayList<Context> result = new ArrayList<Context>();
        this.getContextPaths().clear();
        this.collectChildDegreeModules(result, startingPoint, startingPoint.getName());
        return result;
    }

    private void collectChildDegreeModules(List<Context> result, CourseGroup courseGroup, String previousPath) throws FenixServiceException {
        for (Context context : courseGroup.getSortedChildContextsWithCurricularCourses()) {
            result.add(context);
            this.getContextPaths().put(context, previousPath);
        }
        for (Context context : courseGroup.getSortedChildContextsWithCourseGroups()) {
            this.collectChildDegreeModules(result, (CourseGroup)((Object)context.getChildDegreeModule()), previousPath + " > " + context.getChildDegreeModule().getName());
        }
    }

    private String getFileName(Date date) throws FenixServiceException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minutes = calendar.get(12);
        return day + "_" + month + "_" + year + "-" + hour + ":" + minutes;
    }

    private void exportToXls(String filename) throws IOException, FenixServiceException {
        this.getResponse().setContentType("application/vnd.ms-excel");
        this.getResponse().setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        ServletOutputStream outputStream = this.getResponse().getOutputStream();
        List<Object> headers = null;
        String spreadSheetName = null;
        Spreadsheet spreadsheet = null;
        if (this.infoToExport.equals((Object)InfoToExport.CURRICULAR_STRUCTURE)) {
            spreadSheetName = "Estrutura Curricular do Grupo";
            headers = this.getCurricularStructureHeader();
            spreadsheet = new Spreadsheet(spreadSheetName, headers);
            this.reportInfo(spreadsheet);
        } else {
            spreadSheetName = "Plano de Estudos do Grupo";
            headers = this.getStudiesPlanHeaders();
            spreadsheet = new Spreadsheet(spreadSheetName, headers);
            this.reportInfo(spreadsheet);
        }
        spreadsheet.exportToXLSSheet((OutputStream)outputStream);
        outputStream.flush();
        this.getResponse().flushBuffer();
    }

    private void reportInfo(Spreadsheet spreadsheet) throws FenixServiceException {
        List<Context> contextsWithCurricularCourses = null;
        contextsWithCurricularCourses = this.contextsWithCurricularCoursesToList(this.getCourseGroup());
        if (this.infoToExport.equals((Object)InfoToExport.CURRICULAR_STRUCTURE)) {
            this.fillCurricularStructure(this.getCourseGroup().getName(), contextsWithCurricularCourses, spreadsheet);
        } else {
            this.fillStudiesPlan(contextsWithCurricularCourses, spreadsheet);
        }
    }

    private List<Object> getCurricularStructureHeader() {
        ArrayList<Object> headers = new ArrayList<Object>();
        if (this.rootWasClicked && !this.getCourseGroup().getSortedChildContextsWithCourseGroups().isEmpty()) {
            headers.add("Grupo");
        }
        headers.add("\u00c1rea Cient\u00edfica");
        headers.add("Sigla");
        headers.add("Cr\u00e9ditos Obrigat\u00f3rios");
        headers.add("Cr\u00e9ditos Optativos");
        return headers;
    }

    private void fillCurricularStructure(String courseGroupBeingReported, List<Context> contextsWithCurricularCourses, Spreadsheet spreadsheet) throws FenixServiceException {
        HashSet<ScientificAreaUnit> scientificAreaUnits = new HashSet<ScientificAreaUnit>();
        for (Context contextWithCurricularCourse : contextsWithCurricularCourses) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)contextWithCurricularCourse.getChildDegreeModule());
            if (curricularCourse.isOptional() || scientificAreaUnits.contains((Object)curricularCourse.getCompetenceCourse().getScientificAreaUnit())) continue;
            Spreadsheet.Row row = spreadsheet.addRow();
            if (this.rootWasClicked && !this.getCourseGroup().getSortedChildContextsWithCourseGroups().isEmpty()) {
                row.setCell(courseGroupBeingReported);
            }
            row.setCell(curricularCourse.getCompetenceCourse().getScientificAreaUnit().getName());
            row.setCell(curricularCourse.getCompetenceCourse().getScientificAreaUnit().getAcronym());
            row.setCell(curricularCourse.getCompetenceCourse().getScientificAreaUnit().getScientificAreaUnitEctsCredits(contextsWithCurricularCourses).toString());
            scientificAreaUnits.add(curricularCourse.getCompetenceCourse().getScientificAreaUnit());
        }
    }

    private List<Object> getStudiesPlanHeaders() {
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add("Unidade Curricular");
        headers.add("Grupo");
        headers.add("\u00c1rea Cient\u00edfica");
        headers.add("Sigla");
        headers.add("Tipo");
        headers.add("Ano");
        headers.add("Semestre");
        headers.add("Cr\u00e9ditos");
        headers.add("T");
        headers.add("TP");
        headers.add("PL");
        headers.add("TC");
        headers.add("S");
        headers.add("E");
        headers.add("OT");
        headers.add("TA");
        headers.add("Observa\u00e7\u00f5es");
        return headers;
    }

    private void fillStudiesPlan(List<Context> contextsWithCurricularCourses, Spreadsheet spreadsheet) throws FenixServiceException {
        for (Context contextWithCurricularCourse : contextsWithCurricularCourses) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)contextWithCurricularCourse.getChildDegreeModule());
            CurricularPeriod curricularPeriod = contextWithCurricularCourse.getCurricularPeriod();
            String parentCourseGroupName = this.getContextPaths().get(contextWithCurricularCourse);
            this.fillCurricularCourse(spreadsheet, curricularCourse, curricularPeriod, parentCourseGroupName);
            if (!curricularCourse.isAnual()) continue;
            this.fillCurricularCourse(spreadsheet, curricularCourse, curricularPeriod.getNext(), parentCourseGroupName);
        }
    }

    private void fillCurricularCourse(Spreadsheet spreadsheet, CurricularCourse curricularCourse, CurricularPeriod curricularPeriod, String parentCourseGroupName) {
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(curricularCourse.getName());
        row.setCell(parentCourseGroupName);
        if (curricularCourse.isOptional()) {
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell(curricularPeriod.getParent().getChildOrder() == null ? "" : curricularPeriod.getParent().getChildOrder().toString());
            row.setCell(curricularPeriod.getChildOrder().toString());
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
        } else {
            row.setCell(curricularCourse.getCompetenceCourse().getScientificAreaUnit().getName());
            row.setCell(curricularCourse.getCompetenceCourse().getScientificAreaUnit().getAcronym());
            row.setCell(BundleUtil.getString((String)"resources.EnumerationResources", (String)curricularCourse.getCompetenceCourse().getRegime().toString(), (String[])new String[0]));
            row.setCell(curricularPeriod.getParent().getChildOrder() == null ? "" : curricularPeriod.getParent().getChildOrder().toString());
            row.setCell(curricularPeriod.getChildOrder().toString());
            row.setCell(curricularCourse.getEctsCredits(curricularPeriod).toString());
            row.setCell(curricularCourse.getTheoreticalHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getProblemsHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getLaboratorialHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getFieldWorkHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getSeminaryHours().toString());
            row.setCell(curricularCourse.getTrainingPeriodHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getTutorialOrientationHours(curricularPeriod).toString());
            row.setCell(curricularCourse.getAutonomousWorkHours(curricularPeriod).toString());
        }
        row.setCell("");
    }

    private static enum InfoToExport {
        CURRICULAR_STRUCTURE,
        STUDIES_PLAN;

    }
}

