/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsTree
extends TagSupport {
    private static final Logger logger = LoggerFactory.getLogger(UnitsTree.class);
    private String initialUnit;
    private String unitParamName;
    private String state;
    private String path;
    private String expanded;

    public int doStartTag() throws JspException {
        String tree = this.writeInstitutionTree();
        try {
            this.pageContext.getOut().print(tree);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public String writeInstitutionTree() {
        StringBuilder buffer = new StringBuilder();
        Unit unit = (Unit)((Object)this.pageContext.findAttribute(this.getInitialUnit()));
        YearMonthDay currentDate = new YearMonthDay();
        buffer.append("<ul class='padding1 nobullet'>");
        this.getSubUnitsList(unit, null, buffer, currentDate, this.getUnitParamName(), this.getPath());
        buffer.append("</ul>");
        return buffer.toString();
    }

    private void getSubUnitsList(Unit parentUnit, Unit parentUnitParent, StringBuilder buffer, YearMonthDay currentDate, String paramName, String path) {
        buffer.append("<li>");
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        List<Unit> subUnits = this.getUnitSubUnits(parentUnit, currentDate);
        if (!subUnits.isEmpty()) {
            this.putImage(parentUnit, parentUnitParent, buffer, request);
        }
        buffer.append("<a href=\"").append(request.getContextPath()).append(path).append("&").append(paramName).append("=").append(parentUnit.getExternalId()).append("\">").append(parentUnit.getNameWithAcronym()).append("</a>").append("</li>");
        if (!subUnits.isEmpty()) {
            buffer.append("<ul class='mvert0 nobullet' id=\"").append("aa").append(parentUnit.getExternalId()).append(parentUnitParent != null ? parentUnitParent.getExternalId() : "").append("\" ").append("style='display:" + (this.getExpanded() != null && Boolean.valueOf(this.getExpanded()) != false ? "block" : "none")).append("'>\r\n");
            Collections.sort(subUnits, Unit.COMPARATOR_BY_NAME_AND_ID);
        }
        for (Unit subUnit : subUnits) {
            this.getSubUnitsList(subUnit, parentUnit, buffer, currentDate, paramName, path);
        }
        if (!subUnits.isEmpty()) {
            buffer.append("</ul>");
        }
    }

    private List<Unit> getUnitSubUnits(Unit parentUnit, YearMonthDay currentDate) {
        ArrayList<AccountabilityTypeEnum> accountabilityEnums = new ArrayList<AccountabilityTypeEnum>();
        accountabilityEnums.add(AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE);
        accountabilityEnums.add(AccountabilityTypeEnum.ACADEMIC_STRUCTURE);
        accountabilityEnums.add(AccountabilityTypeEnum.GEOGRAPHIC);
        if (!StringUtils.isEmpty((String)this.getState()) && this.getState().equalsIgnoreCase("true")) {
            return new ArrayList<Unit>(parentUnit.getActiveSubUnits(currentDate, accountabilityEnums));
        }
        if (!StringUtils.isEmpty((String)this.getState()) && this.getState().equalsIgnoreCase("false")) {
            return new ArrayList<Unit>(parentUnit.getInactiveSubUnits(currentDate, accountabilityEnums));
        }
        return new ArrayList<Unit>(parentUnit.getSubUnits(accountabilityEnums));
    }

    private void putImage(Unit parentUnit, Unit parentUnitParent, StringBuilder buffer, HttpServletRequest request) {
        buffer.append("<img ").append("src='").append(request.getContextPath()).append(this.getExpanded() != null && Boolean.valueOf(this.getExpanded()) != false ? "/images/toggle_minus10.gif" : "/images/toggle_plus10.gif").append("' id=\"").append(parentUnit.getExternalId()).append(parentUnitParent != null ? parentUnitParent.getExternalId() : "").append("\" ").append("indexed='true' onClick=\"").append("check(document.getElementById('").append("aa").append(parentUnit.getExternalId()).append(parentUnitParent != null ? parentUnitParent.getExternalId() : "").append("'),document.getElementById('").append(parentUnit.getExternalId()).append(parentUnitParent != null ? parentUnitParent.getExternalId() : "").append("'));return false;").append("\"> ");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInitialUnit() {
        return this.initialUnit;
    }

    public void setInitialUnit(String initialUnit) {
        this.initialUnit = initialUnit;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUnitParamName() {
        return this.unitParamName;
    }

    public void setUnitParamName(String unitParamName) {
        this.unitParamName = unitParamName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getExpanded() {
        return this.expanded;
    }

    public void setExpanded(String expanded) {
        this.expanded = expanded;
    }
}

