/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.taglib.TagUtils;
import org.fenixedu.academic.domain.Holiday;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.util.DayType;
import org.fenixedu.academic.util.Month;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.renderer.GanttDiagram;
import org.fenixedu.academic.util.renderer.GanttDiagramEvent;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GanttDiagramTagLib
extends TagSupport {
    private static final Logger logger = LoggerFactory.getLogger(GanttDiagramTagLib.class);
    private static final String F = "F";
    private static final String S = "S";
    private static final String D = "D";
    private static final String EMPTY_TD_BAR = "emptytdbar";
    private static final String TD_BAR = "tdbar";
    private static int MONDAY_IN_JODA_TIME = 1;
    private static int TUESDAY_IN_JODA_TIME = 2;
    private static int WEDNESDAY_IN_JODA_TIME = 3;
    private static int THURSDAY_IN_JODA_TIME = 4;
    private static int FRIDAY_IN_JODA_TIME = 5;
    private static int SATURDAY_IN_JODA_TIME = 6;
    private static int SUNDAY_IN_JODA_TIME = 7;
    private String ganttDiagram;
    private String eventUrl;
    private String eventParameter;
    private String bundle;
    private String firstDayParameter;
    private String monthlyViewUrl;
    private String weeklyViewUrl;
    private String dailyViewUrl;
    private String toWrite = null;
    private boolean showPeriod = true;
    private boolean showObservations = true;
    private boolean toMark = true;
    private boolean specialDiv = false;
    private boolean isEventToMarkWeekendsAndHolidays = false;
    private GanttDiagram ganttDiagramObject;
    private List<? extends GanttDiagramEvent> events;
    private HttpServletRequest request;
    private GanttDiagram.ViewType viewTypeEnum;
    private static BigDecimal PX_TO_EM_CONVERSION_DIVISOR = BigDecimal.TEN;
    private static BigDecimal EMPTY_UNIT = BigDecimal.ZERO;
    private static int NUMBER_OF_DAY_5_MINUTES = 288;
    private static int NUMBER_OF_DAY_HALF_HOURS = 48;
    private static int NUMBER_OF_DAY_HOURS = 24;
    private static int FIXED_COLUMNS_SIZE_EM = 50;
    private static int PADDING_LEFT_MULTIPLIER = 15;

    public int doStartTag() throws JspException {
        String ganttDiagram = "";
        Object object = this.pageContext.findAttribute(this.getGanttDiagram());
        if (object != null) {
            this.setGanttDiagramObject((GanttDiagram)object);
            this.setViewTypeEnum(this.getGanttDiagramObject().getViewType());
            this.setEvents(this.getGanttDiagramObject().getEvents());
            this.setShowPeriod(this.isShowPeriod());
            this.setShowObservations(this.isShowObservations());
            this.setRequest((HttpServletRequest)this.pageContext.getRequest());
            ganttDiagram = this.generateGanttDiagramString();
        }
        try {
            this.pageContext.getOut().print(ganttDiagram);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private String generateGanttDiagramString() throws JspException {
        switch (this.getViewTypeEnum()) {
            case TOTAL: {
                return this.generateGanttDiagramInTotalMode(this.convertToEm(this.getGanttDiagramObject().getMonthsDaysSize())).toString();
            }
            case MONTHLY_TOTAL: {
                return this.generateGanttDiagramInTotalMode(this.convertToEm(this.getGanttDiagramObject().getMonthsDaysSize())).toString();
            }
            case MONTHLY: {
                return this.generateGanttDiagramInTimeMode(BigDecimal.valueOf(this.getGanttDiagramObject().getDays().size()).multiply(this.convertToEm(NUMBER_OF_DAY_HOURS))).toString();
            }
            case WEEKLY: {
                return this.generateGanttDiagramInTimeMode(BigDecimal.valueOf(7L).multiply(this.convertToEm(NUMBER_OF_DAY_HALF_HOURS))).toString();
            }
            case DAILY: {
                return this.generateGanttDiagramInTimeMode(this.convertToEm(NUMBER_OF_DAY_5_MINUTES)).toString();
            }
            case YEAR_DAILY: {
                return this.generateGanttDiagramInTimeMode(BigDecimal.valueOf(this.getGanttDiagramObject().getDays().size()).multiply(this.convertToEm(NUMBER_OF_DAY_HOURS))).toString();
            }
        }
        return "";
    }

    private StringBuilder generateGanttDiagramInTimeMode(BigDecimal tableWidth) throws JspException {
        StringBuilder builder = new StringBuilder();
        if (!this.getEvents().isEmpty()) {
            if (this.isShowPeriod() && this.isShowObservations()) {
                builder.append("<table style=\"width:").append(tableWidth.add(BigDecimal.valueOf(FIXED_COLUMNS_SIZE_EM))).append("em;\" class=\"tcalendar thlight\">");
            } else {
                builder.append("<table class=\"tcalendar thlight\">");
            }
            this.generateHeaders(builder);
            int numberOfUnits = this.getNumberOfUnits();
            String selectedEvent = this.getRequest().getParameter(this.getEventParameter());
            Object selectedEventObject = this.getRequest().getAttribute(this.getEventParameter());
            for (GanttDiagramEvent ganttDiagramEvent : this.getEvents()) {
                MultiLanguageString diagramEventName;
                String eventUrl = this.getRequest().getContextPath() + this.getEventUrl() + "&amp;" + this.getEventParameter() + "=" + ganttDiagramEvent.getGanttDiagramEventIdentifier();
                if (ganttDiagramEvent.getGanttDiagramEventUrlAddOns() != null) {
                    eventUrl = eventUrl.concat(ganttDiagramEvent.getGanttDiagramEventUrlAddOns());
                }
                String eventName = (diagramEventName = ganttDiagramEvent.getGanttDiagramEventName()) == null ? "" : diagramEventName.getContent();
                String paddingStyle = "padding-left:" + ganttDiagramEvent.getGanttDiagramEventOffset() * PADDING_LEFT_MULTIPLIER + "px";
                if (ganttDiagramEvent.getGanttDiagramEventIdentifier().equals(selectedEvent) || selectedEventObject != null && ganttDiagramEvent.getGanttDiagramEventIdentifier().equals(selectedEventObject.toString())) {
                    builder.append("<tr class=\"selected\">");
                } else {
                    builder.append("<tr>");
                }
                if (this.getViewTypeEnum() == GanttDiagram.ViewType.YEAR_DAILY) {
                    builder.append("<td class=\"padded\">").append("<div class=\"nowrap\">");
                    builder.append("<span style=\"").append(paddingStyle).append("\" title=\"").append(eventName).append("\">");
                    builder.append("<a href=\"").append(eventUrl).append("&amp;month=").append(Month.values()[ganttDiagramEvent.getGanttDiagramEventMonth() - 1].toString()).append("\">").append(eventName);
                } else {
                    builder.append("<td class=\"padded\">").append("<div style=\"overflow:hidden; width: 14.5em;\" class=\"nowrap\">");
                    builder.append("<span style=\"").append(paddingStyle).append("\" title=\"").append(eventName).append("\">");
                    builder.append("<a href=\"").append(eventUrl).append("\">").append(eventName);
                }
                builder.append("</a></span></div></td>");
                for (DateTime day : this.getGanttDiagramObject().getDays()) {
                    int startIndex = 0;
                    int endIndex = 0;
                    int dayOfMonth = day.getDayOfMonth();
                    int monthOfYear = day.getMonthOfYear();
                    if (this.getViewTypeEnum() == GanttDiagram.ViewType.YEAR_DAILY) {
                        monthOfYear = ganttDiagramEvent.getGanttDiagramEventMonth();
                    }
                    int year = day.getYear();
                    YearMonthDay yearMonthDay = new YearMonthDay(year, monthOfYear, 1);
                    this.isEventToMarkWeekendsAndHolidays = ganttDiagramEvent.isGanttDiagramEventToMarkWeekendsAndHolidays();
                    if (!this.isEventToMarkWeekendsAndHolidays) {
                        builder.append("<td style=\"width: ").append(this.convertToEm(numberOfUnits)).append("em;\"><div style=\"position: relative;\">");
                    }
                    if (this.getViewTypeEnum() == GanttDiagram.ViewType.YEAR_DAILY && dayOfMonth > yearMonthDay.plusMonths(1).minusDays(1).getDayOfMonth()) {
                        this.addEmptyDiv(builder);
                        builder.append("</div></td>");
                        continue;
                    }
                    this.specialDiv = false;
                    for (Interval interval : ganttDiagramEvent.getGanttDiagramEventSortedIntervals()) {
                        this.toWrite = null;
                        this.toMark = true;
                        LocalDate localDate = yearMonthDay.withDayOfMonth(dayOfMonth).toLocalDate();
                        if (!(ganttDiagramEvent.getGanttDiagramEventDayType(interval) != DayType.SPECIFIC_DAYS && ganttDiagramEvent.getGanttDiagramEventDayType(interval) != DayType.WORKDAY || localDate.getDayOfWeek() != SATURDAY_IN_JODA_TIME && localDate.getDayOfWeek() != SUNDAY_IN_JODA_TIME && !Holiday.isHoliday(localDate))) {
                            this.toMark = false;
                        }
                        if (this.isEventToMarkWeekendsAndHolidays) {
                            if (Holiday.isHoliday(localDate)) {
                                this.toWrite = F;
                            } else if (localDate.getDayOfWeek() == SATURDAY_IN_JODA_TIME) {
                                this.toWrite = S;
                            } else if (localDate.getDayOfWeek() == SUNDAY_IN_JODA_TIME) {
                                this.toWrite = D;
                            }
                        }
                        if (interval.getStart().getYear() > year || interval.getEnd().getYear() < year) continue;
                        if (interval.getStart().getYear() < year && interval.getEnd().getYear() > year) {
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getYear() == year && interval.getEnd().getYear() > year) {
                            if (interval.getStart().getMonthOfYear() < monthOfYear) {
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                                continue;
                            }
                            if (interval.getStart().getMonthOfYear() != monthOfYear) continue;
                            if (interval.getStart().getDayOfMonth() == dayOfMonth) {
                                startIndex = this.calculateTimeOfDay(interval.getStart());
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits - (startIndex - 1)), this.convertToEm(startIndex - 1));
                                continue;
                            }
                            if (interval.getStart().getDayOfMonth() >= dayOfMonth) continue;
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getYear() < year && interval.getEnd().getYear() == year) {
                            if (interval.getEnd().getMonthOfYear() > monthOfYear) {
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                                continue;
                            }
                            if (interval.getEnd().getMonthOfYear() != monthOfYear) continue;
                            if (interval.getEnd().getDayOfMonth() > dayOfMonth) {
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                                continue;
                            }
                            if (interval.getEnd().getDayOfMonth() != dayOfMonth) continue;
                            endIndex = this.calculateTimeOfDay(interval.getEnd());
                            this.addSpecialDiv(builder, this.convertToEm(endIndex), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getYear() != year || interval.getEnd().getYear() != year || interval.getStart().getMonthOfYear() > monthOfYear || interval.getEnd().getMonthOfYear() < monthOfYear) continue;
                        if (interval.getStart().getMonthOfYear() == monthOfYear && interval.getEnd().getMonthOfYear() > monthOfYear) {
                            if (interval.getStart().getDayOfMonth() == dayOfMonth) {
                                startIndex = this.calculateTimeOfDay(interval.getStart());
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits - (startIndex - 1)), this.convertToEm(startIndex - 1));
                                continue;
                            }
                            if (interval.getStart().getDayOfMonth() >= dayOfMonth) continue;
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getMonthOfYear() < monthOfYear && interval.getEnd().getMonthOfYear() == monthOfYear) {
                            if (interval.getEnd().getDayOfMonth() > dayOfMonth) {
                                this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                                continue;
                            }
                            if (interval.getEnd().getDayOfMonth() != dayOfMonth) continue;
                            endIndex = this.calculateTimeOfDay(interval.getEnd());
                            this.addSpecialDiv(builder, this.convertToEm(endIndex), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getMonthOfYear() < monthOfYear && interval.getEnd().getMonthOfYear() > monthOfYear) {
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getMonthOfYear() != monthOfYear || interval.getEnd().getMonthOfYear() != monthOfYear || interval.getStart().getDayOfMonth() > dayOfMonth || interval.getEnd().getDayOfMonth() < dayOfMonth) continue;
                        if (ganttDiagramEvent.isGanttDiagramEventIntervalsLongerThanOneDay() && (interval.getStart().getDayOfMonth() == dayOfMonth || interval.getEnd().getDayOfMonth() > dayOfMonth)) {
                            startIndex = this.calculateTimeOfDay(interval.getStart());
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits - (startIndex - 1)), this.convertToEm(startIndex - 1));
                            continue;
                        }
                        if (interval.getStart().getDayOfMonth() == dayOfMonth && interval.getEnd().getDayOfMonth() > dayOfMonth) {
                            startIndex = this.calculateTimeOfDay(interval.getStart());
                            this.addSpecialDiv(builder, this.convertToEm(numberOfUnits - (startIndex - 1)), this.convertToEm(startIndex - 1));
                            continue;
                        }
                        if (interval.getStart().getDayOfMonth() < dayOfMonth && interval.getEnd().getDayOfMonth() == dayOfMonth) {
                            endIndex = this.calculateTimeOfDay(interval.getEnd());
                            this.addSpecialDiv(builder, this.convertToEm(endIndex), EMPTY_UNIT);
                            continue;
                        }
                        if (interval.getStart().getDayOfMonth() != dayOfMonth || interval.getEnd().getDayOfMonth() != dayOfMonth) continue;
                        startIndex = this.calculateTimeOfDay(interval.getStart());
                        if (startIndex == (endIndex = this.calculateTimeOfDay(interval.getEnd()))) {
                            this.addSpecialDiv(builder, this.convertToEm(1), this.convertToEm(startIndex - 1));
                            continue;
                        }
                        this.addSpecialDiv(builder, this.convertToEm(endIndex - startIndex + 1), this.convertToEm(startIndex - 1));
                    }
                    if (!this.isEventToMarkWeekendsAndHolidays) {
                        builder.append("</div></td>");
                        continue;
                    }
                    if (this.specialDiv) continue;
                    builder.append("<td class=\"tdnomark\">");
                    if (dayOfMonth <= yearMonthDay.plusMonths(1).minusDays(1).getDayOfMonth()) {
                        LocalDate localDate = yearMonthDay.withDayOfMonth(dayOfMonth).toLocalDate();
                        if (Holiday.isHoliday(localDate)) {
                            builder.append(F);
                        } else if (localDate.getDayOfWeek() == SATURDAY_IN_JODA_TIME) {
                            builder.append(S);
                        } else if (localDate.getDayOfWeek() == SUNDAY_IN_JODA_TIME) {
                            builder.append(D);
                        }
                    }
                    builder.append("</td>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<td class=\"padded smalltxt\" title=\"").append(ganttDiagramEvent.getGanttDiagramEventPeriod()).append("\"><div style=\"overflow:hidden;\" class=\"nowrap\">").append(ganttDiagramEvent.getGanttDiagramEventPeriod()).append("</div></td>");
                }
                if (this.isShowObservations()) {
                    builder.append("<td class=\"padded smalltxt\">").append(ganttDiagramEvent.getGanttDiagramEventObservations()).append("</td>");
                }
                builder.append("</tr>");
            }
            this.insertNextAndBeforeLinks(builder);
            builder.append("</table>");
        }
        return builder;
    }

    private StringBuilder generateGanttDiagramInTotalMode(BigDecimal tableWidth) throws JspException {
        StringBuilder builder = new StringBuilder();
        if (!this.getEvents().isEmpty()) {
            if (this.isShowPeriod() && this.isShowObservations()) {
                builder.append("<table style=\"width:").append(tableWidth.add(BigDecimal.valueOf(FIXED_COLUMNS_SIZE_EM))).append("em;\" class=\"tcalendar thlight\">");
            } else {
                builder.append("<table style=\"width:").append(tableWidth.add(BigDecimal.valueOf(FIXED_COLUMNS_SIZE_EM - 35))).append("em;\" class=\"tcalendar thlight\">");
            }
            this.generateHeaders(builder);
            int scale = this.getScale();
            String selectedEvent = this.getRequest().getParameter(this.getEventParameter());
            Object selectedEventObject = this.getRequest().getAttribute(this.getEventParameter());
            for (GanttDiagramEvent ganttDiagramEvent : this.getEvents()) {
                String eventUrl = this.getRequest().getContextPath() + this.getEventUrl() + "&amp;" + this.getEventParameter() + "=" + ganttDiagramEvent.getGanttDiagramEventIdentifier();
                String eventName = ganttDiagramEvent.getGanttDiagramEventName().getContent(this.getGanttDiagramObject().getLocale());
                String paddingStyle = "padding-left:" + ganttDiagramEvent.getGanttDiagramEventOffset() * PADDING_LEFT_MULTIPLIER + "px";
                if (ganttDiagramEvent.getGanttDiagramEventIdentifier().equals(selectedEvent) || selectedEventObject != null && ganttDiagramEvent.getGanttDiagramEventIdentifier().equals(selectedEventObject.toString())) {
                    builder.append("<tr class=\"selected\">");
                } else {
                    builder.append("<tr>");
                }
                builder.append("<td class=\"padded\">").append("<div style=\"overflow:hidden; width: 14.5em;\" class=\"nowrap\">");
                builder.append("<span style=\"").append(paddingStyle).append("\" title=\"").append(eventName).append("\">");
                builder.append("<a href=\"").append(eventUrl).append("\">").append("*").append(eventName);
                builder.append("</a></span></div></td>");
                for (DateTime month : this.getGanttDiagramObject().getMonths()) {
                    DateTime firstDayOfMonth = month.getDayOfMonth() != 1 ? month.withDayOfMonth(1) : month;
                    DateTime lastDayOfMonth = firstDayOfMonth.plusMonths(1).minusDays(1);
                    int monthNumberOfDays = Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)lastDayOfMonth).getDays() + 1;
                    BigDecimal entryDays = EMPTY_UNIT;
                    BigDecimal startDay = EMPTY_UNIT;
                    builder.append("<td style=\"width: ").append(this.convertToEm(monthNumberOfDays * scale)).append("em;\"><div style=\"position: relative;\">");
                    for (Interval interval : ganttDiagramEvent.getGanttDiagramEventSortedIntervals()) {
                        DateMidnight intervalStart = interval.getStart().toDateMidnight();
                        DateMidnight intervalEnd = interval.getEnd().toDateMidnight();
                        if (intervalStart.getMonthOfYear() == month.getMonthOfYear() && intervalStart.getYear() == month.getYear()) {
                            if (interval.getEnd().getMonthOfYear() == month.getMonthOfYear() && intervalEnd.getYear() == month.getYear()) {
                                if (intervalStart.getDayOfMonth() == 1) {
                                    if (intervalEnd.getDayOfMonth() == monthNumberOfDays) {
                                        entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)intervalStart, (ReadableInstant)lastDayOfMonth).getDays() + 1) * scale);
                                        startDay = this.convertToEm((intervalStart.getDayOfMonth() - 1) * scale);
                                        this.addSpecialDiv(builder, entryDays, startDay);
                                        continue;
                                    }
                                    entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd).getDays() + 1) * scale);
                                    startDay = this.convertToEm((intervalStart.getDayOfMonth() - 1) * scale);
                                    this.addSpecialDiv(builder, entryDays, startDay);
                                    continue;
                                }
                                if (intervalEnd.getDayOfMonth() == monthNumberOfDays) {
                                    entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)intervalStart, (ReadableInstant)lastDayOfMonth).getDays() + 1) * scale);
                                    startDay = this.convertToEm((intervalStart.getDayOfMonth() - 1) * scale);
                                    this.addSpecialDiv(builder, entryDays, startDay);
                                    continue;
                                }
                                entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd).getDays() + 1) * scale);
                                startDay = this.convertToEm((intervalStart.getDayOfMonth() - 1) * scale);
                                this.addSpecialDiv(builder, entryDays, startDay);
                                continue;
                            }
                            entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)intervalStart, (ReadableInstant)lastDayOfMonth).getDays() + 1) * scale);
                            startDay = this.convertToEm((intervalStart.getDayOfMonth() - 1) * scale);
                            this.addSpecialDiv(builder, entryDays, startDay);
                            continue;
                        }
                        if (intervalStart.getYear() >= month.getYear() && (intervalStart.getYear() != month.getYear() || intervalStart.getMonthOfYear() >= month.getMonthOfYear())) continue;
                        if (intervalEnd.getYear() > month.getYear() || intervalEnd.getYear() == month.getYear() && intervalEnd.getMonthOfYear() > month.getMonthOfYear()) {
                            entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)lastDayOfMonth).getDays() + 1) * scale);
                            startDay = this.convertToEm((firstDayOfMonth.getDayOfMonth() - 1) * scale);
                            this.addSpecialDiv(builder, entryDays, startDay);
                            continue;
                        }
                        if (intervalEnd.getMonthOfYear() != month.getMonthOfYear() || intervalEnd.getYear() != month.getYear()) continue;
                        entryDays = this.convertToEm((Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)intervalEnd).getDays() + 1) * scale);
                        startDay = this.convertToEm((firstDayOfMonth.getDayOfMonth() - 1) * scale);
                        this.addSpecialDiv(builder, entryDays, startDay);
                    }
                    builder.append("</div></td>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<td class=\"padded smalltxt\" title=\"").append(ganttDiagramEvent.getGanttDiagramEventPeriod()).append("\"><div style=\"overflow:hidden;\" class=\"nowrap\">").append(ganttDiagramEvent.getGanttDiagramEventPeriod()).append("</div></td>");
                }
                if (this.isShowObservations()) {
                    builder.append("<td class=\"padded smalltxt\">").append(ganttDiagramEvent.getGanttDiagramEventObservations()).append("</td>");
                }
                builder.append("</tr>");
            }
            this.insertNextAndBeforeLinks(builder);
            builder.append("</table>");
        }
        return builder;
    }

    private void generateHeaders(StringBuilder builder) throws JspException {
        switch (this.getViewTypeEnum()) {
            case WEEKLY: {
                builder.append("<tr>");
                builder.append("<th style=\"width: 15em;\" rowspan=\"4\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                for (Integer n : this.getGanttDiagramObject().getYearsView().keySet()) {
                    builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getYearsView().get(n)).append("\">").append(n).append("</th>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\" rowspan=\"4\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th rowspan=\"4\">").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                builder.append("<tr>");
                if (!StringUtils.isEmpty((String)this.getMonthlyViewUrl())) {
                    Iterator<DateTime> monthlyViewUrl_ = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    for (YearMonthDay month : this.getGanttDiagramObject().getMonthsView().keySet()) {
                        builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getMonthsView().get(month)).append("\">").append("<a href=\"").append((String)((Object)monthlyViewUrl_)).append(month.toString("ddMMyyyy")).append("\">").append(month.toString("MMM", this.getGanttDiagramObject().getLocale())).append("</a>").append("</th>");
                    }
                } else {
                    for (YearMonthDay yearMonthDay : this.getGanttDiagramObject().getMonthsView().keySet()) {
                        builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getMonthsView().get(yearMonthDay)).append("\">").append(yearMonthDay.toString("MMM", this.getGanttDiagramObject().getLocale())).append("</th>");
                    }
                }
                builder.append("</tr>");
                builder.append("<tr>");
                for (DateTime dateTime : this.getGanttDiagramObject().getDays()) {
                    builder.append("<th>").append(dateTime.toString("E", this.getGanttDiagramObject().getLocale())).append("</th>");
                }
                builder.append("</tr>");
                builder.append("<tr>");
                if (!StringUtils.isEmpty((String)this.getDailyViewUrl())) {
                    String dailyViewUrl_ = this.getRequest().getContextPath() + this.getDailyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    for (DateTime day : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append("<a href=\"").append(dailyViewUrl_).append(day.toString("ddMMyyyy")).append("\">").append(day.getDayOfMonth()).append("</a>").append("</th>");
                    }
                } else {
                    for (DateTime dateTime : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append(dateTime.getDayOfMonth()).append("</th>");
                    }
                }
                builder.append("</tr>");
                break;
            }
            case MONTHLY: {
                builder.append("<tr>");
                builder.append("<th style=\"width: 15em;\" rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                for (YearMonthDay yearMonthDay : this.getGanttDiagramObject().getMonthsView().keySet()) {
                    builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getMonthsView().get(yearMonthDay)).append("\">").append(yearMonthDay.toString("MMM yyyy", this.getGanttDiagramObject().getLocale())).append("</th>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\" rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                builder.append("<tr>");
                if (!StringUtils.isEmpty((String)this.getDailyViewUrl())) {
                    String dailyViewUrl_ = this.getRequest().getContextPath() + this.getDailyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    for (DateTime day : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append("<a href=\"").append(dailyViewUrl_).append(day.toString("ddMMyyyy")).append("\">").append(day.getDayOfMonth()).append("</a>").append("</th>");
                    }
                } else {
                    for (DateTime dateTime : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append(dateTime.getDayOfMonth()).append("</th>");
                    }
                }
                builder.append("</tr>");
                break;
            }
            case DAILY: {
                builder.append("<tr>");
                builder.append("<th style=\"width: 15em;\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                builder.append("<th>").append(this.getGanttDiagramObject().getFirstInstant().toString("E", this.getGanttDiagramObject().getLocale())).append(", ").append(this.getGanttDiagramObject().getFirstInstant().getDayOfMonth()).append(" ");
                if (!StringUtils.isEmpty((String)this.getMonthlyViewUrl())) {
                    String monthlyViewUrl_ = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    builder.append("<a href=\"").append(monthlyViewUrl_).append(this.getGanttDiagramObject().getFirstInstant().toString("ddMMyyyy")).append("\">").append(this.getGanttDiagramObject().getFirstInstant().toString("MMM", this.getGanttDiagramObject().getLocale())).append("</a>");
                } else {
                    builder.append(this.getGanttDiagramObject().getFirstInstant().toString("MMM", this.getGanttDiagramObject().getLocale()));
                }
                builder.append(" ").append(this.getGanttDiagramObject().getFirstInstant().getYear());
                if (!StringUtils.isEmpty((String)this.getWeeklyViewUrl())) {
                    String weeklyViewUrl_ = this.getRequest().getContextPath() + this.getWeeklyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    builder.append(" (<a href=\"").append(weeklyViewUrl_).append(this.getGanttDiagramObject().getFirstInstant().toString("ddMMyyyy")).append("\">");
                    builder.append(this.getMessage("label.ganttDiagram.week")).append(this.getGanttDiagramObject().getFirstInstant().getWeekOfWeekyear()).append(")</a>");
                }
                builder.append("</th>");
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th>").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                break;
            }
            case TOTAL: {
                builder.append("<tr>");
                builder.append("<th style=\"width: 15em;\" rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                for (Integer n : this.getGanttDiagramObject().getYearsView().keySet()) {
                    builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getYearsView().get(n)).append("\">").append(n).append("</th>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\" rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                builder.append("<tr>");
                for (DateTime dateTime : this.getGanttDiagramObject().getMonths()) {
                    builder.append("<th>").append(dateTime.toString("MMM", this.getGanttDiagramObject().getLocale())).append("</th>");
                }
                builder.append("</tr>");
                break;
            }
            case MONTHLY_TOTAL: {
                builder.append("<tr>");
                builder.append("<th style=\"width: 15em;\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                builder.append("<th>").append(this.getGanttDiagramObject().getFirstInstant().toString("MMM", this.getGanttDiagramObject().getLocale())).append(" ").append(this.getGanttDiagramObject().getFirstInstant().getYear()).append("</th>");
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th>").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                break;
            }
            case YEAR_DAILY: {
                builder.append("<tr>");
                builder.append("<th rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.event")).append("</th>");
                for (Integer n : this.getGanttDiagramObject().getYearsView().keySet()) {
                    builder.append("<th colspan=\"").append(this.getGanttDiagramObject().getYearsView().get(n)).append("\">").append(n).append("</th>");
                }
                if (this.isShowPeriod()) {
                    builder.append("<th style=\"width: 20em;\" rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.period")).append("</th>");
                }
                if (this.isShowObservations()) {
                    builder.append("<th rowspan=\"2\">").append(this.getMessage("label.ganttDiagram.observations")).append("</th>");
                }
                builder.append("</tr>");
                builder.append("<tr>");
                if (!StringUtils.isEmpty((String)this.getDailyViewUrl())) {
                    String dailyViewUrl_ = this.getRequest().getContextPath() + this.getDailyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=";
                    for (DateTime day : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append("<a href=\"").append(dailyViewUrl_).append(day.toString("ddMMyyyy")).append("\">").append(day.getDayOfMonth()).append("</a>").append("</th>");
                    }
                } else {
                    for (DateTime dateTime : this.getGanttDiagramObject().getDays()) {
                        builder.append("<th>").append(dateTime.getDayOfMonth()).append("</th>");
                    }
                }
                builder.append("</tr>");
                break;
            }
        }
    }

    private void insertNextAndBeforeLinks(StringBuilder builder) throws JspException {
        YearMonthDay firstDay = this.getGanttDiagramObject().getFirstInstant().toYearMonthDay();
        if (firstDay != null) {
            String nextUrl = "";
            String beforeUrl = "";
            switch (this.getViewTypeEnum()) {
                case WEEKLY: {
                    if (StringUtils.isEmpty((String)this.getWeeklyViewUrl())) break;
                    nextUrl = this.getRequest().getContextPath() + this.getWeeklyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.plusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK).toString("ddMMyyyy");
                    beforeUrl = this.getRequest().getContextPath() + this.getWeeklyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.minusDays(Lesson.NUMBER_OF_DAYS_IN_WEEK).toString("ddMMyyyy");
                    builder.append("<tr><td class=\"tcalendarlinks\"></td><td colspan=\"7\" class=\"acenter tcalendarlinks\"> <span class=\"smalltxt\"><a href=\"").append(beforeUrl).append("\">").append("&lt;&lt; ").append(this.getMessage("label.previous.week")).append("</a>");
                    builder.append(" , ").append("<a href=\"").append(nextUrl).append("\">").append(this.getMessage("label.next.week")).append(" &gt;&gt;").append("</a>").append("</span></td><td class=\"tcalendarlinks\"></td><td class=\"tcalendarlinks\"></td></tr>");
                    break;
                }
                case DAILY: {
                    if (StringUtils.isEmpty((String)this.getDailyViewUrl())) break;
                    nextUrl = this.getRequest().getContextPath() + this.getDailyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.plusDays(1).toString("ddMMyyyy");
                    beforeUrl = this.getRequest().getContextPath() + this.getDailyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.minusDays(1).toString("ddMMyyyy");
                    builder.append("<tr><td class=\"tcalendarlinks\"></td><td class=\"acenter tcalendarlinks\"><span class=\"smalltxt\"><a href=\"").append(beforeUrl).append("\">").append("&lt;&lt; ").append(this.getMessage("label.previous.day")).append("</a>");
                    builder.append(" , ").append("<a href=\"").append(nextUrl).append("\">").append(this.getMessage("label.next.day")).append(" &gt;&gt;").append("</a>").append("</span></td><td class=\"tcalendarlinks\"></td><td class=\"tcalendarlinks\"></td></tr>");
                    break;
                }
                case MONTHLY: {
                    if (StringUtils.isEmpty((String)this.getMonthlyViewUrl())) break;
                    DateTime month = firstDay.toDateTimeAtMidnight();
                    DateTime firstDayOfMonth = month.getDayOfMonth() != 1 ? month.withDayOfMonth(1) : month;
                    DateTime lastDayOfMonth = firstDayOfMonth.plusMonths(1).minusDays(1);
                    int monthNumberOfDays = Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)lastDayOfMonth).getDays() + 1;
                    nextUrl = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.plusMonths(1).toString("ddMMyyyy");
                    beforeUrl = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.minusMonths(1).toString("ddMMyyyy");
                    builder.append("<tr><td class=\"tcalendarlinks\"></td><td colspan=\"").append(monthNumberOfDays).append("\" class=\"acenter tcalendarlinks\"><span class=\"smalltxt\"><a href=\"").append(beforeUrl).append("\">").append("&lt;&lt; ").append(this.getMessage("label.previous.month")).append("</a>");
                    builder.append(" , ").append("<a href=\"").append(nextUrl).append("\">").append(this.getMessage("label.next.month")).append(" &gt;&gt;").append("</a>").append("</span></td><td class=\"tcalendarlinks\"></td><td class=\"tcalendarlinks\"></td></tr>");
                    break;
                }
                case YEAR_DAILY: {
                    if (StringUtils.isEmpty((String)this.getMonthlyViewUrl())) break;
                    DateTime month = firstDay.toDateTimeAtMidnight();
                    DateTime firstDayOfMonth = month.getDayOfMonth() != 1 ? month.withDayOfMonth(1) : month;
                    DateTime lastDayOfMonth = firstDayOfMonth.plusMonths(1).minusDays(1);
                    int monthNumberOfDays = Days.daysBetween((ReadableInstant)firstDayOfMonth, (ReadableInstant)lastDayOfMonth).getDays() + 1;
                    nextUrl = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.plusMonths(1).toString("ddMMyyyy");
                    beforeUrl = this.getRequest().getContextPath() + this.getMonthlyViewUrl() + "&amp;" + this.getFirstDayParameter() + "=" + firstDay.minusMonths(1).toString("ddMMyyyy");
                    builder.append("<tr><td class=\"tcalendarlinks\"></td><td colspan=\"").append(monthNumberOfDays).append("\" class=\"acenter tcalendarlinks\"><span class=\"smalltxt\"><a href=\"").append(beforeUrl).append("\">").append("&lt;&lt; ").append(this.getMessage("label.previous.month")).append("</a>");
                    builder.append(" , ").append("<a href=\"").append(nextUrl).append("\">").append(this.getMessage("label.next.month")).append(" &gt;&gt;").append("</a>").append("</span></td><td class=\"tcalendarlinks\"></td><td class=\"tcalendarlinks\"></td></tr>");
                    break;
                }
            }
        }
    }

    private int getScale() {
        switch (this.getViewTypeEnum()) {
            case TOTAL: {
                return 1;
            }
            case MONTHLY_TOTAL: {
                return 10;
            }
        }
        return 0;
    }

    private int calculateTimeOfDay(DateTime time) {
        int hourOfDay = time.getHourOfDay();
        int minuteOfHour = time.getMinuteOfHour();
        switch (this.getViewTypeEnum()) {
            case WEEKLY: {
                int result = (hourOfDay + 1) * 2;
                if (minuteOfHour <= 30) {
                    return result - 1;
                }
                return result;
            }
            case DAILY: {
                int i = 1;
                int j = 0;
                while (j < 60) {
                    if (minuteOfHour < j + 5) {
                        return i + 12 * hourOfDay;
                    }
                    j += 5;
                    ++i;
                }
            }
            case MONTHLY: {
                return hourOfDay;
            }
            case YEAR_DAILY: {
                return hourOfDay;
            }
        }
        return 0;
    }

    private int getNumberOfUnits() {
        switch (this.getViewTypeEnum()) {
            case WEEKLY: {
                return NUMBER_OF_DAY_HALF_HOURS;
            }
            case DAILY: {
                return NUMBER_OF_DAY_5_MINUTES;
            }
            case MONTHLY: {
                return NUMBER_OF_DAY_HOURS;
            }
            case YEAR_DAILY: {
                return NUMBER_OF_DAY_HOURS;
            }
        }
        return 0;
    }

    private void addEmptyDiv(StringBuilder builder) {
        builder.append("<td class=\"");
        builder.append(EMPTY_TD_BAR);
        builder.append("\"></td>");
    }

    private void addSpecialDiv(StringBuilder builder, BigDecimal entryDays, BigDecimal startDay) {
        this.specialDiv = true;
        if (this.isEventToMarkWeekendsAndHolidays) {
            builder.append("<td");
            if (this.toMark) {
                builder.append(" class=\"");
                builder.append(TD_BAR);
                builder.append("\">");
            } else {
                builder.append(" class=\"tdnomark\">");
            }
            if (this.toWrite != null) {
                builder.append(this.toWrite);
            }
            builder.append("</td>");
        } else {
            builder.append("<div style=\"width: ").append(entryDays).append("em; position: absolute; left: ");
            builder.append(startDay);
            builder.append("em; top: -0.7em;\" class=\"tdbar\">&nbsp;</div>");
        }
    }

    private BigDecimal convertToEm(int value) {
        return BigDecimal.valueOf(value).divide(PX_TO_EM_CONVERSION_DIVISOR, 2, RoundingMode.HALF_UP);
    }

    private String getMessage(String key) throws JspException {
        String message = this.getMessageFromBundle(key);
        return message != null ? message : key;
    }

    private String getMessageFromBundle(String key) throws JspException {
        return this.getBundle() != null ? (TagUtils.getInstance().present(this.pageContext, this.getBundle(), this.getGanttDiagramObject().getLocale().toString(), key) ? TagUtils.getInstance().message(this.pageContext, this.getBundle(), this.getGanttDiagramObject().getLocale().toString(), key) : null) : null;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public List<? extends GanttDiagramEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<? extends GanttDiagramEvent> events) {
        this.events = events;
    }

    public GanttDiagram getGanttDiagramObject() {
        return this.ganttDiagramObject;
    }

    public void setGanttDiagramObject(GanttDiagram ganttDiagramObject) {
        this.ganttDiagramObject = ganttDiagramObject;
    }

    public String getEventUrl() {
        return this.eventUrl;
    }

    public void setEventUrl(String url) {
        this.eventUrl = url;
    }

    public String getEventParameter() {
        return this.eventParameter;
    }

    public void setEventParameter(String parameter) {
        this.eventParameter = parameter;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getGanttDiagram() {
        return this.ganttDiagram;
    }

    public void setGanttDiagram(String ganttDiagram) {
        this.ganttDiagram = ganttDiagram;
    }

    public GanttDiagram.ViewType getViewTypeEnum() {
        return this.viewTypeEnum;
    }

    public void setViewTypeEnum(GanttDiagram.ViewType viewTypeEnum) {
        this.viewTypeEnum = viewTypeEnum;
    }

    public String getFirstDayParameter() {
        return this.firstDayParameter;
    }

    public void setFirstDayParameter(String firstDayParameter) {
        this.firstDayParameter = firstDayParameter;
    }

    public String getDailyViewUrl() {
        return this.dailyViewUrl;
    }

    public void setDailyViewUrl(String dailyViewMode) {
        this.dailyViewUrl = dailyViewMode;
    }

    public String getMonthlyViewUrl() {
        return this.monthlyViewUrl;
    }

    public void setMonthlyViewUrl(String monthlyViewUrl) {
        this.monthlyViewUrl = monthlyViewUrl;
    }

    public String getWeeklyViewUrl() {
        return this.weeklyViewUrl;
    }

    public void setWeeklyViewUrl(String weeklyViewUrl) {
        this.weeklyViewUrl = weeklyViewUrl;
    }

    public boolean isShowPeriod() {
        return this.showPeriod;
    }

    public void setShowPeriod(boolean showPeriod) {
        this.showPeriod = showPeriod;
    }

    public boolean isShowObservations() {
        return this.showObservations;
    }

    public void setShowObservations(boolean showObservations) {
        this.showObservations = showObservations;
    }
}

