/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.scientificCouncil.thesis;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.filter.ScientificCouncilAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisDiscussion$callable$runApproveThesisDiscussion;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ThesisServiceWithMailNotification;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ApproveThesisDiscussion
extends ThesisServiceWithMailNotification {
    private static final String SUBJECT_KEY = "thesis.evaluation.approve.subject";
    private static final String BODY_KEY = "thesis.evaluation.approve.body";
    private static final String COUNCIL_MEMBER_ROLE = "thesis.proposal.jury.approve.body.role.council";
    private static final ApproveThesisDiscussion serviceInstance;
    public static final Advice advice$runApproveThesisDiscussion;

    @Override
    public void process(Thesis thesis) {
        thesis.approveEvaluation();
    }

    public static byte[] readStream(InputStream inputStream) {
        try {
            return ByteStreams.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    protected Collection<String> getReceiversEmails(Thesis thesis) {
        Set<String> persons = thesis.getAllParticipants(ThesisParticipationType.ORIENTATOR, ThesisParticipationType.COORIENTATOR, ThesisParticipationType.PRESIDENT, ThesisParticipationType.VOWEL).stream().map(p -> p.getEmail()).collect(Collectors.toSet());
        persons.add(thesis.getStudent().getPerson().getProfile().getEmail());
        ExecutionYear executionYear = thesis.getEnrolment().getExecutionYear();
        for (ScientificCommission member : thesis.getDegree().getScientificCommissionMembers(executionYear)) {
            if (!member.isContact().booleanValue()) continue;
            persons.add(member.getPerson().getProfile().getEmail());
        }
        return persons;
    }

    @Override
    protected String getMessage(Thesis thesis) {
        Locale locale = I18N.getLocale();
        Person currentPerson = AccessControl.getPerson();
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        String institutionName = Bennu.getInstance().getInstitutionUnit().getPartyName().getContent(locale);
        String title = thesis.getTitle().getContent();
        String year = executionYear.getYear();
        String degreeName = thesis.getDegree().getNameFor(executionYear).getContent();
        String studentName = thesis.getStudent().getPerson().getName();
        String studentNumber = thesis.getStudent().getNumber().toString();
        Calendar today = Calendar.getInstance(locale);
        String currentPersonName = currentPerson.getNickname();
        String role = thesis.isCoordinator() ? "" : this.getMessage(locale, COUNCIL_MEMBER_ROLE, new Object[0]);
        return this.getMessage(locale, BODY_KEY, year, degreeName, studentName, studentNumber, institutionName, "" + today.get(5), today.getDisplayName(2, 2, locale), "" + today.get(1), currentPersonName, role);
    }

    @Override
    protected String getSubject(Thesis thesis) {
        return this.getMessage(I18N.getLocale(), SUBJECT_KEY, thesis.getTitle().getContent());
    }

    public static void runApproveThesisDiscussion(Thesis thesis) throws NotAuthorizedException {
        Object object = advice$runApproveThesisDiscussion.perform((Callable)new ApproveThesisDiscussion$callable$runApproveThesisDiscussion(thesis));
    }

    static /* synthetic */ void advised$runApproveThesisDiscussion(Thesis thesis) throws NotAuthorizedException {
        ScientificCouncilAuthorizationFilter.instance.execute();
        serviceInstance.run(thesis);
    }

    static {
        advice$runApproveThesisDiscussion = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ApproveThesisDiscussion();
    }
}

