/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager.executionCourseManagement;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionDegreesByExecutionPeriodId$callable$run;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionDegreesByExecutionPeriodId$callable$runForAcademicAdmin;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionDegreesByExecutionPeriodId$callable$runForAcademicAdminAdv;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadExecutionDegreesByExecutionPeriodId {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$runForAcademicAdmin = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$runForAcademicAdminAdv = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List<InfoExecutionDegree> run(String string) throws FenixServiceException {
        return (List)advice$run.perform((Callable)new ReadExecutionDegreesByExecutionPeriodId$callable$run(string));
    }

    static /* synthetic */ List<InfoExecutionDegree> advised$run(String executionPeriodId) throws FenixServiceException {
        return ReadExecutionDegreesByExecutionPeriodId.getExecutionDegreesByExecutionPeriodId(executionPeriodId, null);
    }

    public static List<InfoExecutionDegree> runForAcademicAdmin(String string) throws FenixServiceException {
        return (List)advice$runForAcademicAdmin.perform((Callable)new ReadExecutionDegreesByExecutionPeriodId$callable$runForAcademicAdmin(string));
    }

    static /* synthetic */ List<InfoExecutionDegree> advised$runForAcademicAdmin(String executionPeriodId) throws FenixServiceException {
        return ReadExecutionDegreesByExecutionPeriodId.getExecutionDegreesByExecutionPeriodId(executionPeriodId, AcademicPredicates.MANAGE_EXECUTION_COURSES);
    }

    public static List<InfoExecutionDegree> runForAcademicAdminAdv(String string) throws FenixServiceException {
        return (List)advice$runForAcademicAdminAdv.perform((Callable)new ReadExecutionDegreesByExecutionPeriodId$callable$runForAcademicAdminAdv(string));
    }

    static /* synthetic */ List<InfoExecutionDegree> advised$runForAcademicAdminAdv(String executionPeriodId) throws FenixServiceException {
        return ReadExecutionDegreesByExecutionPeriodId.getExecutionDegreesByExecutionPeriodId(executionPeriodId, AcademicPredicates.MANAGE_EXECUTION_COURSES_ADV);
    }

    private static List<InfoExecutionDegree> getExecutionDegreesByExecutionPeriodId(String executionPeriodId, AccessControlPredicate<Object> permission) throws FenixServiceException {
        if (executionPeriodId == null) {
            throw new FenixServiceException("executionPeriodId.should.not.be.null");
        }
        ExecutionSemester executionSemester = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        List<ExecutionDegree> executionDegrees = ExecutionDegree.getAllByExecutionYear(executionSemester.getExecutionYear().getYear());
        ArrayList<InfoExecutionDegree> infoExecutionDegreeList = new ArrayList<InfoExecutionDegree>();
        for (ExecutionDegree executionDegree : executionDegrees) {
            if (permission != null && !permission.evaluate(executionDegree.getDegree())) continue;
            InfoExecutionDegree infoExecutionDegree = InfoExecutionDegree.newInfoFromDomain(executionDegree);
            infoExecutionDegreeList.add(infoExecutionDegree);
        }
        return infoExecutionDegreeList;
    }
}

