/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.enrollment.shift;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.enrollment.shift.ShiftEnrollmentErrorReport;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.filter.enrollment.ClassEnrollmentAuthorizationFilter;
import org.fenixedu.academic.service.services.enrollment.shift.EnrollStudentInShifts$callable$runEnrollStudentInShifts;
import org.fenixedu.academic.service.services.enrollment.shift.EnrollStudentInShifts$callable$runEnrollStudentInShifts$1;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EnrollStudentInShifts {
    private static final EnrollStudentInShifts serviceInstance;
    public static final Advice advice$runEnrollStudentInShifts;
    public static final Advice advice$runEnrollStudentInShifts$1;

    public ShiftEnrollmentErrorReport run(Registration registration, String shiftId) throws FenixServiceException {
        ServiceMonitoring.logService(this.getClass(), new Object[]{registration, shiftId});
        ShiftEnrollmentErrorReport errorReport = new ShiftEnrollmentErrorReport();
        Shift selectedShift = (Shift)FenixFramework.getDomainObject((String)shiftId);
        if (selectedShift == null) {
            errorReport.getUnExistingShifts().add(shiftId);
            return errorReport;
        }
        if (registration == null || !selectedShift.getExecutionCourse().hasAttendsFor(registration.getStudent())) {
            throw new StudentNotFoundServiceException();
        }
        if (TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(registration.getPerson(), new LocalDate())) {
            throw new FenixServiceException("error.exception.notAuthorized.student.warningTuition");
        }
        Shift shiftFromStudent = this.findShiftOfSameTypeForSameExecutionCourse(registration, selectedShift);
        if (selectedShift != shiftFromStudent) {
            if (selectedShift.getLotacao() <= selectedShift.getStudentsSet().size()) {
                throw new FenixServiceException("error.exception.shift.full");
            }
            if (selectedShift.reserveForStudent(registration)) {
                if (shiftFromStudent != null) {
                    shiftFromStudent.removeStudents(registration);
                }
            } else {
                errorReport.getUnAvailableShifts().add(selectedShift);
            }
        }
        return errorReport;
    }

    private Shift findShiftOfSameTypeForSameExecutionCourse(Registration registration, Shift shift) {
        for (Shift shiftFromStudent : registration.getShiftsSet()) {
            if (!shiftFromStudent.getTypes().containsAll(shift.getTypes()) || shiftFromStudent.getExecutionCourse() != shift.getExecutionCourse()) continue;
            return shiftFromStudent;
        }
        return null;
    }

    public static ShiftEnrollmentErrorReport runEnrollStudentInShifts(Registration registration, String string) throws FenixServiceException, NotAuthorizedException {
        return (ShiftEnrollmentErrorReport)advice$runEnrollStudentInShifts.perform((Callable)new EnrollStudentInShifts$callable$runEnrollStudentInShifts(registration, string));
    }

    static /* synthetic */ ShiftEnrollmentErrorReport advised$runEnrollStudentInShifts(Registration registration, String shiftId) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration);
        return serviceInstance.run(registration, shiftId);
    }

    public static ShiftEnrollmentErrorReport runEnrollStudentInShifts(Registration registration, String string, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        return (ShiftEnrollmentErrorReport)advice$runEnrollStudentInShifts$1.perform((Callable)new EnrollStudentInShifts$callable$runEnrollStudentInShifts$1(registration, string, executionSemester));
    }

    static /* synthetic */ ShiftEnrollmentErrorReport advised$runEnrollStudentInShifts(Registration registration, String shiftId, ExecutionSemester executionSemester) throws FenixServiceException, NotAuthorizedException {
        ClassEnrollmentAuthorizationFilter.instance.execute(registration, executionSemester);
        return serviceInstance.run(registration, shiftId);
    }

    static {
        advice$runEnrollStudentInShifts = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEnrollStudentInShifts$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new EnrollStudentInShifts();
    }

    public static class StudentNotFoundServiceException
    extends FenixServiceException {
    }
}

