/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.serviceRequests.Under23TransportsDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.LocalDate;

public class Under23TransportsDeclarationDocument
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected Under23TransportsDeclarationDocument(Under23TransportsDeclarationRequest documentRequest) {
        super((IDocumentRequest)((Object)documentRequest));
    }

    protected Under23TransportsDeclarationRequest getDocumentRequest() {
        return (Under23TransportsDeclarationRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected void fillReport() {
        Person person = this.getDocumentRequest().getPerson();
        this.addParameter("personName", person.getName());
        this.addParameter("documentIdNumber", person.getDocumentIdNumber());
        this.addParameter("emissionDate", person.getEmissionDateOfDocumentIdYearMonthDay() == null ? "" : person.getEmissionDateOfDocumentIdYearMonthDay().toString("dd/MM/yyyy"));
        this.addParameter("birthDate", person.getDateOfBirthYearMonthDay().toString("dd/MM/yyyy"));
        this.addParameter("executionYear", this.getExecutionYear().getQualifiedName());
        this.addParameter("institutionName", UnitUtils.readInstitutionUnit().getName());
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        this.addAddressInformation("person", (Party)((Object)this.getDocumentRequest().getPerson()));
        this.addAddressInformation("institution", (Party)((Object)institutionUnit));
        this.addParameter("institutionPhone", institutionUnit.getDefaultPhone().getNumber());
        this.addParameter("reportDate", new LocalDate().toString("dd 'de' MMMM 'de' yyyy", I18N.getLocale()));
    }

    private void addAddressInformation(String prefix, Party party) {
        PhysicalAddress address = party.getDefaultPhysicalAddress();
        this.addParameter(prefix + "Address", address.getAddress());
        this.addParameter(prefix + "Parish", address.getParishOfResidence());
        this.addParameter(prefix + "Municipality", address.getDistrictSubdivisionOfResidence());
        this.addParameter(prefix + "AreaCode", address.getAreaCode());
        this.addParameter(prefix + "AreaOfAreaCode", address.getAreaOfAreaCode());
    }
}

