/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry_Base;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicSemesterOfAcademicYearDateTimeFieldType;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.util.DayType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.renderer.GanttDiagramEvent;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.DomainObject;

public abstract class AcademicCalendarEntry
extends AcademicCalendarEntry_Base
implements GanttDiagramEvent {
    public static final Comparator<AcademicCalendarEntry> COMPARATOR_BY_BEGIN_DATE = new Comparator<AcademicCalendarEntry>(){

        @Override
        public int compare(AcademicCalendarEntry o1, AcademicCalendarEntry o2) {
            int c1 = o1.getBegin().compareTo((ReadableInstant)o2.getBegin());
            return c1 == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : c1;
        }
    };

    protected abstract AcademicCalendarEntry createVirtualEntry(AcademicCalendarEntry var1);

    protected abstract boolean isParentEntryInvalid(AcademicCalendarEntry var1);

    protected abstract boolean exceededNumberOfChildEntries(AcademicCalendarEntry var1);

    protected abstract boolean areIntersectionsPossible(AcademicCalendarEntry var1);

    protected abstract boolean isPossibleToChangeTimeInterval();

    protected abstract boolean associatedWithDomainEntities();

    protected void afterRedefineEntry() {
    }

    protected void beforeRedefineEntry() {
    }

    protected AcademicCalendarEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public void delete(AcademicCalendarRootEntry rootEntry) {
        if (!this.canBeDeleted(rootEntry)) {
            throw new DomainException("error.now.its.impossible.delete.entry.but.in.the.future.will.be.possible", new String[0]);
        }
        this.getBasedEntriesSet().clear();
        super.setParentEntry(null);
        super.setTemplateEntry(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public AcademicCalendarEntry edit(MultiLanguageString title, MultiLanguageString description, DateTime begin, DateTime end, AcademicCalendarRootEntry rootEntry, AcademicCalendarEntry templateEntry) {
        if (this.isRoot() || rootEntry == null) {
            throw new DomainException("error.unsupported.operation", new String[0]);
        }
        if (!rootEntry.equals((Object)this.getRootEntry())) {
            if (this.getBegin().isEqual((ReadableInstant)begin) && this.getEnd().isEqual((ReadableInstant)end)) {
                throw new DomainException("error.AcademicCalendarEntry.unchanged.dates", new String[0]);
            }
            AcademicCalendarEntry newParentEntry = this.createVirtualPathUntil(this.getParentEntry(), rootEntry);
            AcademicCalendarEntry newEntry = this.createVirtualEntry(newParentEntry);
            newEntry.edit(title, description, begin, end, rootEntry, templateEntry);
            return newEntry;
        }
        boolean isRedefinedEntry = this.isVirtual();
        if (isRedefinedEntry) {
            this.beforeRedefineEntry();
        }
        this.setTitle(title);
        this.setDescription(description);
        this.setTimeInterval(begin, end);
        if (isRedefinedEntry) {
            this.afterRedefineEntry();
        }
        return this;
    }

    protected void initEntry(AcademicCalendarEntry parentEntry, MultiLanguageString title, MultiLanguageString description, DateTime begin, DateTime end, AcademicCalendarRootEntry rootEntry) {
        if (rootEntry == null || parentEntry == null) {
            throw new DomainException("error.unsupported.operation", new String[0]);
        }
        parentEntry = !parentEntry.getRootEntry().equals((Object)rootEntry) ? this.createVirtualPathUntil(parentEntry, rootEntry) : parentEntry;
        this.setParentEntry(parentEntry, false);
        this.setTitle(title);
        this.setDescription(description);
        this.setTimeInterval(begin, end);
    }

    protected void initVirtualEntry(AcademicCalendarEntry parentEntry, AcademicCalendarEntry templateEntry) {
        this.setParentEntry(parentEntry, true);
        this.setTemplateEntry(templateEntry);
    }

    private AcademicCalendarEntry createVirtualPathUntil(AcademicCalendarEntry entry, AcademicCalendarRootEntry rootEntryDestination) {
        if (!entry.isRoot()) {
            List<AcademicCalendarEntry> entryPath = entry.getFullPath();
            entryPath.remove(0);
            Object parentEntry = rootEntryDestination;
            Object virtualOrRedefinedEntry = rootEntryDestination;
            for (AcademicCalendarEntry entryToMakeCopy : entryPath) {
                if (virtualOrRedefinedEntry != null) {
                    virtualOrRedefinedEntry = entryToMakeCopy.getVirtualOrRedefinedEntryIn(rootEntryDestination);
                }
                if (virtualOrRedefinedEntry == null) {
                    parentEntry = entryToMakeCopy.createVirtualEntry((AcademicCalendarEntry)parentEntry);
                    continue;
                }
                parentEntry = virtualOrRedefinedEntry;
            }
            return parentEntry;
        }
        return rootEntryDestination;
    }

    private AcademicCalendarEntry getVirtualOrRedefinedEntryIn(AcademicCalendarRootEntry rootEntry) {
        if (rootEntry != null) {
            Set basedEntries = this.getBasedEntriesSet();
            for (AcademicCalendarEntry entry : basedEntries) {
                if (!entry.getRootEntry().equals((Object)rootEntry)) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean canBeDeleted(AcademicCalendarRootEntry rootEntry) {
        if (!this.getRootEntry().equals((Object)rootEntry)) {
            throw new DomainException("error.AcademicCalendarEntry.different.rootEntry", new String[0]);
        }
        if (!this.getChildEntriesSet().isEmpty()) {
            throw new DomainException("error.AcademicCalendarEntry.has.childs", new String[0]);
        }
        return true;
    }

    public void setTemplateEntry(AcademicCalendarEntry templateEntry) {
        AcademicCalendarRootEntry rootEntry;
        if (templateEntry != null && (!templateEntry.getClass().equals(this.getClass()) || this.getBasedEntriesSet().contains(templateEntry))) {
            throw new DomainException("error.AcademicCalendarEntry.invalid.template.entry", new String[0]);
        }
        if (!(this.isRoot() || (rootEntry = this.getRootEntry()).getTemplateEntry() != null && rootEntry.getTemplateEntry().equals((Object)templateEntry.getRootEntry()))) {
            throw new DomainException("error.AcademicCalendarEntry.invalid.template.entry", new String[0]);
        }
        super.setTemplateEntry(templateEntry);
    }

    protected void setParentEntry(AcademicCalendarEntry parentEntry, boolean virtualEntry) {
        if (parentEntry == null) {
            throw new DomainException("error.AcademicCalendarEntry.empty.parentEntry", new String[0]);
        }
        if (this.isParentEntryInvalid(parentEntry)) {
            throw new DomainException("error.AcademicCalendarEntry.invalid.parent.entry", this.getClass().getSimpleName(), parentEntry.getClass().getSimpleName());
        }
        if (!virtualEntry && parentEntry.exceededNumberOfChildEntries(this)) {
            throw new DomainException("error.AcademicCalendarEntry.number.of.subEntries.exceeded", new String[0]);
        }
        super.setParentEntry(parentEntry);
    }

    public void setParentEntry(AcademicCalendarEntry parentEntry) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public void setBegin(DateTime begin) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public void setEnd(DateTime end) {
        throw new DomainException("error.unsupported.operation", new String[0]);
    }

    public void setTitle(MultiLanguageString title) {
        if (title == null || title.isEmpty()) {
            throw new DomainException("error.AcademicCalendarEntry.empty.title", new String[0]);
        }
        super.setTitle(title);
    }

    public DateTime getBegin() {
        return this.isVirtual() ? this.getTemplateEntry().getBegin() : super.getBegin();
    }

    public DateTime getEnd() {
        return this.isVirtual() ? this.getTemplateEntry().getEnd() : super.getEnd();
    }

    public MultiLanguageString getTitle() {
        return this.isVirtual() && !this.isRoot() ? this.getTemplateEntry().getTitle() : super.getTitle();
    }

    public MultiLanguageString getDescription() {
        return this.isVirtual() && !this.isRoot() ? this.getTemplateEntry().getDescription() : super.getDescription();
    }

    protected void setTimeInterval(DateTime begin, DateTime end) {
        if (begin == null) {
            throw new DomainException("error.AcademicCalendarEntry.empty.begin.dateTime", new String[0]);
        }
        if (end == null) {
            throw new DomainException("error.AcademicCalendarEntry.empty.end.dateTime", new String[0]);
        }
        if (!end.isAfter((ReadableInstant)begin)) {
            throw new DomainException("error.begin.after.end", new String[0]);
        }
        super.setBegin(begin);
        super.setEnd(end);
        GenericPair<DateTime, DateTime> maxAndMinDateTimes = this.getChildMaxAndMinDateTimes();
        if (maxAndMinDateTimes != null && (this.getBegin().isAfter((ReadableInstant)maxAndMinDateTimes.getLeft()) || this.getEnd().isBefore((ReadableInstant)maxAndMinDateTimes.getRight()))) {
            throw new DomainException("error.AcademicCalendarEntry.out.of.bounds", new String[0]);
        }
        if (!this.getParentEntry().areIntersectionsPossible(this)) {
            for (AcademicCalendarEntry childEntry : this.getParentEntry().getChildEntriesWithTemplateEntries(this.getClass())) {
                if (childEntry.equals(this) || !childEntry.entriesTimeIntervalIntersection(begin, end)) continue;
                throw new DomainException("error.AcademicCalendarEntry.dates.intersection", new String[0]);
            }
        }
        this.refreshParentTimeInterval();
    }

    private void refreshParentTimeInterval() {
        GenericPair<DateTime, DateTime> childMaxAndMinDateTimes;
        AcademicCalendarEntry parentEntry = this.getParentEntry();
        if (!parentEntry.isRoot() && (childMaxAndMinDateTimes = parentEntry.getChildMaxAndMinDateTimes()) != null) {
            boolean changeEndDate;
            DateTime begin = childMaxAndMinDateTimes.getLeft();
            DateTime end = childMaxAndMinDateTimes.getRight();
            boolean changeBeginDate = !parentEntry.getBegin().isBefore((ReadableInstant)begin);
            boolean bl = changeEndDate = !parentEntry.getEnd().isAfter((ReadableInstant)end);
            if (parentEntry.isPossibleToChangeTimeInterval()) {
                if (changeBeginDate || changeEndDate) {
                    DateTime beginDate = changeBeginDate ? begin : parentEntry.getBegin();
                    DateTime endDate = changeEndDate ? end : parentEntry.getEnd();
                    parentEntry.edit(parentEntry.getTitle(), parentEntry.getDescription(), beginDate, endDate, parentEntry.getRootEntry(), parentEntry.getTemplateEntry());
                }
            } else if (changeBeginDate || changeEndDate) {
                throw new DomainException("error.AcademicCalendarEntry.impossible.refresh.time.interval", this.getClass().getName());
            }
        }
    }

    public GenericPair<DateTime, DateTime> getChildMaxAndMinDateTimes() {
        List<AcademicCalendarEntry> childEntries = this.getChildEntriesWithTemplateEntries();
        if (!childEntries.isEmpty()) {
            DateTime begin = null;
            DateTime end = null;
            for (AcademicCalendarEntry entry : childEntries) {
                if (begin == null || entry.getBegin().isBefore((ReadableInstant)begin)) {
                    begin = entry.getBegin();
                }
                if (end != null && !entry.getEnd().isAfter((ReadableInstant)end)) continue;
                end = entry.getEnd();
            }
            return new GenericPair<Object, Object>(begin, end);
        }
        return null;
    }

    public AcademicCalendarEntry getNonVirtualTemplateEntry() {
        if (this.isVirtual()) {
            return this.getTemplateEntry().getNonVirtualTemplateEntry();
        }
        return this;
    }

    public AcademicCalendarEntry getOriginalTemplateEntry() {
        if (this.getTemplateEntry() != null) {
            return this.getTemplateEntry().getOriginalTemplateEntry();
        }
        return this;
    }

    public boolean isRedefined() {
        return this.isVirtual();
    }

    public boolean isVirtual() {
        return super.getBegin() == null && this.getTemplateEntry() != null;
    }

    public EntryState getEntryState() {
        return this.isVirtual() ? EntryState.VIRTUAL : EntryState.ORIGINAL;
    }

    public List<AcademicCalendarEntry> getFullPath() {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        result.add(this);
        for (AcademicCalendarEntry parentEntry = this.getParentEntry(); parentEntry != null; parentEntry = parentEntry.getParentEntry()) {
            result.add(0, parentEntry);
        }
        return result;
    }

    public List<AcademicInterval> getFullPathInDeep() {
        ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
        this.getChildFullPathInDeep(result, this.getRootEntry());
        return result;
    }

    private void getChildFullPathInDeep(List<AcademicInterval> result, AcademicCalendarRootEntry rootEntry) {
        if (this.associatedWithDomainEntities()) {
            result.add(new AcademicInterval(this, rootEntry));
        }
        Collection<AcademicCalendarEntry> childEntries = this.getTemplateEntry() != null ? this.getChildEntriesWithTemplateEntries() : this.getChildEntriesSet();
        for (AcademicCalendarEntry child : childEntries) {
            child.getChildFullPathInDeep(result, rootEntry);
        }
    }

    public String getPresentationTimeInterval() {
        if (!this.isRoot()) {
            return this.getBegin().toString("dd-MM-yyyy HH:mm") + " - " + this.getEnd().toString("dd-MM-yyyy HH:mm");
        }
        DateTime begin = this.getBegin();
        return begin != null ? begin.toString("dd-MM-yyyy HH:mm") + " - **-**-**** **:**" : "";
    }

    public MultiLanguageString getType() {
        MultiLanguageString type = new MultiLanguageString();
        String key = "label." + this.getClass().getSimpleName() + ".type";
        type = type.with(MultiLanguageString.pt, BundleUtil.getString((String)"resources.ManagerResources", (Locale)new Locale("pt", "PT"), (String)key, (String[])new String[0]));
        return type;
    }

    public String getPresentationName() {
        return this.getTitle().getContent() + " - [" + this.getType() + "]";
    }

    public AcademicCalendarRootEntry getAcademicCalendar() {
        return this.getRootEntry();
    }

    public AcademicCalendarRootEntry getRootEntry() {
        if (this.isRoot()) {
            return (AcademicCalendarRootEntry)((Object)this);
        }
        return this.getParentEntry().getRootEntry();
    }

    public AcademicChronology getAcademicChronology() {
        return this.getRootEntry().getAcademicChronology();
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries() {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(null, result, null, null, null);
        return result;
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Long instant) {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(instant, result, null, null, null);
        return result;
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Class<? extends AcademicCalendarEntry> subEntryClass) {
        if (subEntryClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AcademicCalendarEntry> allChildEntries = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(null, allChildEntries, null, null, subEntryClass);
        return allChildEntries;
    }

    public List<AcademicCalendarEntry> getAllChildEntriesWithTemplateEntries(Class<? extends AcademicCalendarEntry> subEntryClass) {
        if (subEntryClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AcademicCalendarEntry> allChildEntries = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(null, allChildEntries, null, null, subEntryClass);
        for (AcademicCalendarEntry child : this.getChildEntriesSet()) {
            allChildEntries.addAll(child.getAllChildEntriesWithTemplateEntries(subEntryClass));
        }
        return allChildEntries;
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntriesOrderByDate(DateTime begin, DateTime end) {
        List<AcademicCalendarEntry> result = this.getChildEntriesWithTemplateEntries(begin, end, null);
        Collections.sort(result, COMPARATOR_BY_BEGIN_DATE);
        return result;
    }

    public List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(DateTime begin, DateTime end, Class<? extends AcademicCalendarEntry> subEntryClass) {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(null, result, begin, end, subEntryClass);
        return result;
    }

    private List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Long instant, DateTime begin, DateTime end, Class<? extends AcademicCalendarEntry> subEntryClass) {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        this.getChildEntriesWithTemplateEntries(instant, result, begin, end, subEntryClass);
        return result;
    }

    protected List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(Long instant, List<AcademicCalendarEntry> result, DateTime begin, DateTime end, Class<? extends AcademicCalendarEntry> subEntryClass) {
        boolean hasTemplateEntry = this.getTemplateEntry() != null;
        ArrayList<AcademicCalendarEntry> templateEntries = hasTemplateEntry ? new ArrayList<AcademicCalendarEntry>() : null;
        for (AcademicCalendarEntry subEntry : this.getChildEntriesSet()) {
            if (!(subEntryClass != null && !subEntry.getClass().equals(subEntryClass) || instant != null && !subEntry.containsInstant(instant) || begin != null && !subEntry.belongsToPeriod(begin, end))) {
                result.add(subEntry);
            }
            if (!hasTemplateEntry || subEntry.getTemplateEntry() == null) continue;
            templateEntries.add(subEntry.getTemplateEntry());
        }
        if (hasTemplateEntry) {
            for (AcademicCalendarEntry entry : this.getTemplateEntry().getChildEntriesWithTemplateEntries(instant, begin, end, subEntryClass)) {
                if (templateEntries.contains(entry)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    protected void getFirstChildEntriesWithTemplateEntries(Long instant, Class<? extends AcademicCalendarEntry> subEntryClass, Class<? extends AcademicCalendarEntry> parentEntryClass, List<AcademicCalendarEntry> childrenEntriesList) {
        if (this.getClass().equals(parentEntryClass)) {
            this.getChildEntriesWithTemplateEntries(instant, childrenEntriesList, null, null, subEntryClass);
        } else if (this.getTemplateEntry() == null) {
            for (AcademicCalendarEntry subEntry : this.getChildEntriesSet()) {
                if (instant != null && !subEntry.containsInstant(instant)) continue;
                subEntry.getFirstChildEntriesWithTemplateEntries(instant, subEntryClass, parentEntryClass, childrenEntriesList);
            }
        } else {
            for (AcademicCalendarEntry subEntry : this.getChildEntriesWithTemplateEntries(instant)) {
                subEntry.getFirstChildEntriesWithTemplateEntries(instant, subEntryClass, parentEntryClass, childrenEntriesList);
            }
        }
    }

    private List<AcademicCalendarEntry> getChildEntriesWithTemplateEntries(AcademicPeriod period) {
        ArrayList<AcademicCalendarEntry> result = new ArrayList<AcademicCalendarEntry>();
        if (this.isOfType(period)) {
            result.add(this);
        }
        ArrayList children = new ArrayList();
        children.addAll(this.getChildEntriesSet());
        Collections.sort(children, COMPARATOR_BY_BEGIN_DATE);
        for (AcademicCalendarEntry child : children) {
            result.addAll(child.getChildEntriesWithTemplateEntries(period));
        }
        return result;
    }

    public AcademicCalendarEntry getChildAcademicCalendarEntry(AcademicPeriod period, int cardinal) {
        List<AcademicCalendarEntry> children = this.getChildEntriesWithTemplateEntries(period);
        if (children.size() >= cardinal) {
            return children.get(cardinal - 1);
        }
        return null;
    }

    public AcademicCalendarEntry getEntryForCalendar(AcademicCalendarRootEntry academicCalendar) {
        AcademicCalendarRootEntry rootEntry = this.getRootEntry();
        if (rootEntry.equals((Object)academicCalendar)) {
            return this;
        }
        for (AcademicCalendarEntry basedEntry : this.getBasedEntriesSet()) {
            AcademicCalendarEntry basedEntryFor = basedEntry.getEntryForCalendar(academicCalendar);
            if (basedEntryFor == null) continue;
            return basedEntryFor;
        }
        for (Object otherRoot = academicCalendar; otherRoot != null; otherRoot = otherRoot.getTemplateEntry()) {
            if (otherRoot != rootEntry) continue;
            return this;
        }
        return null;
    }

    public int getAcademicSemesterOfAcademicYear(AcademicChronology academicChronology) {
        return this.getBegin().withChronology((Chronology)academicChronology).get(AcademicSemesterOfAcademicYearDateTimeFieldType.academicSemesterOfAcademicYear());
    }

    public boolean belongsToPeriod(DateTime begin, DateTime end) {
        return !this.getBegin().isAfter((ReadableInstant)end) && !this.getEnd().isBefore((ReadableInstant)begin);
    }

    public boolean containsInstant(long instant) {
        return this.getBegin().getMillis() <= instant && this.getEnd().getMillis() >= instant;
    }

    private boolean entriesTimeIntervalIntersection(DateTime begin, DateTime end) {
        return !this.getBegin().isAfter((ReadableInstant)end) && !this.getEnd().isBefore((ReadableInstant)begin);
    }

    @Override
    public List<Interval> getGanttDiagramEventSortedIntervals() {
        ArrayList<Interval> result = new ArrayList<Interval>();
        result.add(new Interval((ReadableInstant)this.getBegin(), (ReadableInstant)this.getEnd()));
        return result;
    }

    @Override
    public MultiLanguageString getGanttDiagramEventName() {
        return this.getTitle();
    }

    @Override
    public int getGanttDiagramEventOffset() {
        if (this.getParentEntry() == null) {
            return 0;
        }
        return this.getParentEntry().getGanttDiagramEventOffset() + 1;
    }

    @Override
    public String getGanttDiagramEventObservations() {
        return "-";
    }

    @Override
    public String getGanttDiagramEventPeriod() {
        return this.getBegin().toString("dd/MM/yyyy HH:mm") + " - " + this.getEnd().toString("dd/MM/yyyy HH:mm");
    }

    @Override
    public String getGanttDiagramEventIdentifier() {
        return this.getExternalId().toString();
    }

    @Override
    public Integer getGanttDiagramEventMonth() {
        return null;
    }

    @Override
    public String getGanttDiagramEventUrlAddOns() {
        return null;
    }

    @Override
    public boolean isGanttDiagramEventIntervalsLongerThanOneDay() {
        return false;
    }

    @Override
    public boolean isGanttDiagramEventToMarkWeekendsAndHolidays() {
        return false;
    }

    @Override
    public DayType getGanttDiagramEventDayType(Interval interval) {
        return null;
    }

    public abstract boolean isOfType(AcademicPeriod var1);

    public boolean isAcademicYear() {
        return false;
    }

    public boolean isAcademicSemester() {
        return false;
    }

    public boolean isAcademicTrimester() {
        return false;
    }

    public boolean isLessonsPerid() {
        return false;
    }

    public boolean isExamsPeriod() {
        return false;
    }

    public boolean isEnrolmentsPeriod() {
        return false;
    }

    public boolean isGradeSubmissionPeriod() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isEqualOrEquivalent(AcademicCalendarEntry entry) {
        if (this.equals(entry)) {
            return true;
        }
        if (!this.getClass().equals(entry.getClass())) {
            return false;
        }
        return this.getOriginalTemplateEntry().equals(entry.getOriginalTemplateEntry());
    }

    public AcademicCalendarEntry getNextAcademicCalendarEntry() {
        AcademicCalendarEntry closest = null;
        for (AcademicCalendarEntry entry : this.getRootEntry().getAllChildEntriesWithTemplateEntries(this.getClass())) {
            if (!entry.getBegin().isAfter((ReadableInstant)this.getBegin()) || closest != null && !entry.getBegin().isBefore((ReadableInstant)closest.getBegin())) continue;
            closest = entry;
        }
        return closest;
    }

    public AcademicCalendarEntry getPreviousAcademicCalendarEntry() {
        AcademicCalendarEntry closest = null;
        for (AcademicCalendarEntry entry : this.getRootEntry().getAllChildEntriesWithTemplateEntries(this.getClass())) {
            if (!entry.getBegin().isBefore((ReadableInstant)this.getBegin()) || closest != null && !entry.getBegin().isAfter((ReadableInstant)closest.getBegin())) continue;
            closest = entry;
        }
        return closest;
    }

    public int getCardinalityOfCalendarEntry(AcademicCalendarEntry child) {
        int count = 1;
        for (AcademicCalendarEntry entry : this.getChildEntriesWithTemplateEntries(child.getClass())) {
            if (!entry.getBegin().isBefore((ReadableInstant)child.getBegin())) continue;
            ++count;
        }
        return count;
    }

    public static enum EntryState {
        VIRTUAL,
        REDEFINED,
        ORIGINAL;


        public String getName() {
            return this.name();
        }
    }
}

