/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.util.Set;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class StudentStatute
extends StudentStatute_Base {
    protected StudentStatute() {
        super.setRootDomainObject(Bennu.getInstance());
        this.setCreationDate(new DateTime());
    }

    @Deprecated
    public StudentStatute(Student student, StatuteType statuteType, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod) {
        this(student, statuteType, beginExecutionPeriod, endExecutionPeriod, beginExecutionPeriod.getBeginLocalDate(), endExecutionPeriod.getEndLocalDate(), null);
    }

    @Deprecated
    public StudentStatute(Student student, StatuteType statuteType, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod, LocalDate beginDate, LocalDate endDate) {
        this(student, statuteType, beginExecutionPeriod, endExecutionPeriod, beginDate, endDate, null);
    }

    public StudentStatute(Student student, StatuteType statuteType, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod, LocalDate beginDate, LocalDate endDate, Registration registration) {
        this();
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setBeginExecutionPeriod(beginExecutionPeriod);
        this.setEndExecutionPeriod(endExecutionPeriod);
        this.setType(statuteType);
        this.setStudent(student);
        this.setRegistration(registration);
        for (StudentStatute statute : student.getStudentStatutesSet()) {
            if (statute == this || !statute.overlapsWith(this)) continue;
            throw new DomainException("error.studentStatute.alreadyExistsOneOverlapingStatute", new String[0]);
        }
        this.checkRules();
    }

    protected void checkRules() {
        if (this.getBeginExecutionPeriod() != null && this.getEndExecutionPeriod() != null && this.getBeginExecutionPeriod().isAfter(this.getEndExecutionPeriod())) {
            throw new DomainException("error.studentStatute.beginPeriod.after.endPeriod", new String[0]);
        }
        if (this.getBeginDate() != null && this.getEndDate() != null && this.getBeginDate().isAfter((ReadablePartial)this.getEndDate())) {
            throw new DomainException("error.studentStatute.beginDate.after.endPeriod", new String[0]);
        }
        if (this.getType() == null) {
            throw new DomainException("error.studentStatute.missing.StatuteType", new String[0]);
        }
        if (this.getType().isAppliedOnRegistration() && this.getRegistration() == null) {
            throw new DomainException("error.studentStatute.registration.required", new String[0]);
        }
        if (!this.getType().isAppliedOnRegistration() && this.getRegistration() != null) {
            throw new DomainException("error.studentStatute.not.applied.for.registration", new String[0]);
        }
    }

    public boolean isValidInExecutionPeriod(ExecutionSemester executionSemester) {
        if (this.getBeginExecutionPeriod() != null && this.getBeginExecutionPeriod().isAfter(executionSemester)) {
            return false;
        }
        return this.getEndExecutionPeriod() == null || !this.getEndExecutionPeriod().isBefore(executionSemester);
    }

    public boolean isValidInExecutionInterval(ExecutionInterval interval) {
        if (interval instanceof ExecutionSemester) {
            return this.isValidInExecutionPeriod(ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, interval));
        }
        if (interval instanceof ExecutionYear) {
            return this.isValidOn(ExecutionInterval.assertExecutionIntervalType(ExecutionYear.class, interval));
        }
        throw new DomainException("error.StudentStatute.cannot.check.period", new String[0]);
    }

    public boolean isValidOn(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (this.isValidInExecutionPeriod(executionSemester)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidOnAnyExecutionPeriodFor(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isValidInExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInCurrentExecutionPeriod() {
        return this.isValidInExecutionPeriod(ExecutionSemester.readActualExecutionSemester());
    }

    public boolean isValidInExecutionInterval(Registration registration, ExecutionInterval interval) {
        return this.isValidInExecutionInterval(interval) && (!this.getType().isAppliedOnRegistration() || this.getRegistration() == registration);
    }

    public boolean isValidOn(Registration registration, ExecutionYear executionYear) {
        return this.isValidOn(executionYear) && (!this.getType().isAppliedOnRegistration() || this.getRegistration() == registration);
    }

    public boolean isValidOnAnyExecutionPeriodFor(Registration registration, ExecutionYear executionYear) {
        return this.isValidOnAnyExecutionPeriodFor(executionYear) && (!this.getType().isAppliedOnRegistration() || this.getRegistration() == registration);
    }

    public boolean isValidInCurrentExecutionPeriod(Registration registration) {
        return this.isValidInCurrentExecutionPeriod() && (!this.getType().isAppliedOnRegistration() || this.getRegistration() == registration);
    }

    public void delete() {
        this.checkRulesToDelete();
        this.setBeginExecutionPeriod(null);
        this.setEndExecutionPeriod(null);
        this.setStudent(null);
        this.setType(null);
        this.setRegistration(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean overlapsWith(StudentStatute statute) {
        ExecutionSemester statuteBegin = statute.getBeginExecutionPeriod() != null ? statute.getBeginExecutionPeriod() : ExecutionSemester.readFirstExecutionSemester();
        ExecutionSemester statuteEnd = statute.getEndExecutionPeriod() != null ? statute.getEndExecutionPeriod() : ExecutionSemester.readLastExecutionSemester();
        return this.overlapsWith(statute.getType(), statuteBegin, statuteEnd, statute.getRegistration());
    }

    public boolean overlapsWith(StatuteType statuteType, ExecutionSemester statuteBegin, ExecutionSemester statuteEnd, Registration registration) {
        if (statuteType != this.getType()) {
            return false;
        }
        if (this.getType().isAppliedOnRegistration() && this.getRegistration() != registration) {
            return false;
        }
        ExecutionSemester thisStatuteBegin = this.getBeginExecutionPeriod() != null ? this.getBeginExecutionPeriod() : ExecutionSemester.readFirstExecutionSemester();
        ExecutionSemester thisStatuteEnd = this.getEndExecutionPeriod() != null ? this.getEndExecutionPeriod() : ExecutionSemester.readLastExecutionSemester();
        return statuteBegin.isAfterOrEquals(thisStatuteBegin) && statuteBegin.isBeforeOrEquals(thisStatuteEnd) || statuteEnd.isAfterOrEquals(thisStatuteBegin) && statuteEnd.isBeforeOrEquals(thisStatuteEnd);
    }

    public void add(StudentStatute statute) {
        if (this.overlapsWith(statute)) {
            if (statute.getBeginExecutionPeriod() == null || this.getBeginExecutionPeriod() != null && statute.getBeginExecutionPeriod().isBefore(this.getBeginExecutionPeriod())) {
                this.setBeginExecutionPeriod(statute.getBeginExecutionPeriod());
            }
            if (statute.getEndExecutionPeriod() == null || this.getEndExecutionPeriod() != null && statute.getEndExecutionPeriod().isAfter(this.getEndExecutionPeriod())) {
                this.setEndExecutionPeriod(statute.getEndExecutionPeriod());
            }
        }
    }

    public boolean isGrantOwnerStatute() {
        return this.getType().isGrantOwnerStatute();
    }

    public String toDetailedString() {
        return (this.getBeginExecutionPeriod() != null ? this.getBeginExecutionPeriod().getQualifiedName() : " - ") + " ..... " + (this.getEndExecutionPeriod() != null ? this.getEndExecutionPeriod().getQualifiedName() : " - ");
    }

    public void checkRulesToDelete() {
    }

    public boolean hasSpecialSeasonEnrolments() {
        ExecutionSemester lastSemester = this.getEndExecutionPeriod();
        Set<Registration> registrations = this.getStudent().getRegistrationsSet();
        for (Registration registration : registrations) {
            Set plans = registration.getStudentCurricularPlansSet();
            for (StudentCurricularPlan scp : plans) {
                for (ExecutionSemester semesterIterator = this.getBeginExecutionPeriod(); semesterIterator != null && semesterIterator.isBeforeOrEquals(lastSemester); semesterIterator = semesterIterator.getNextExecutionPeriod()) {
                    if (!scp.isEnroledInSpecialSeason(semesterIterator)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasSeniorStatuteForRegistration(Registration registration) {
        return false;
    }
}

