/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.SchoolRegistrationCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class SchoolRegistrationCertificateRequest
extends SchoolRegistrationCertificateRequest_Base {
    protected SchoolRegistrationCertificateRequest() {
    }

    public SchoolRegistrationCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkRulesToCreate(bean);
    }

    private void checkRulesToCreate(DocumentRequestCreateBean bean) {
        if (bean.getExecutionYear() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.SchoolRegistrationCertificateRequest.executionYear.cannot.be.null", new String[0]);
        }
        if (!bean.getRegistration().isRegistered(bean.getExecutionYear())) {
            throw new DomainException("SchoolRegistrationCertificateRequest.registration.not.in.registered.state.in.given.executionYear", new String[0]);
        }
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.SCHOOL_REGISTRATION_CERTIFICATE;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final EventType getEventType() {
        return EventType.SCHOOL_REGISTRATION_CERTIFICATE_REQUEST;
    }

    public final Integer getNumberOfUnits() {
        return 0;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return true;
    }

    public boolean hasPersonalInfo() {
        return true;
    }
}

