/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRectorateSubmissionBatchDocumentEntry;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest_Base;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.joda.time.LocalDate;

public class RegistryDiplomaRequest
extends RegistryDiplomaRequest_Base
implements IRegistryDiplomaRequest,
IRectorateSubmissionBatchDocumentEntry {
    public RegistryDiplomaRequest() {
    }

    public RegistryDiplomaRequest(DocumentRequestCreateBean bean) {
        this();
        super.init((RegistrationAcademicServiceRequestCreateBean)bean);
        this.checkParameters(bean);
        this.setProgramConclusion(bean.getProgramConclusion());
        if (bean.getRegistration().isBolonha()) {
            this.setDiplomaSupplement(new DiplomaSupplementRequest(bean));
        }
    }

    public String getFamilyNames() {
        return this.getRegistration().getPerson().getFamilyNames();
    }

    public String getGivenNames() {
        return this.getRegistration().getPerson().getGivenNames();
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getProgramConclusion() == null) {
            throw new DomainException("error.program.conclusion.empty", new String[0]);
        }
        if (this.getRegistration().getDiplomaRequest(bean.getProgramConclusion()) != null) {
            throw new DomainException("error.registryDiploma.alreadyHasDiplomaRequest", new String[0]);
        }
        if (this.getRegistration().getRegistryDiplomaRequest(bean.getProgramConclusion()) != null) {
            throw new DomainException("error.registryDiploma.alreadyRequested", new String[0]);
        }
        if (this.hasPersonalInfo() && this.hasMissingPersonalInfo()) {
            throw new DomainException("AcademicServiceRequest.has.missing.personal.info", new String[0]);
        }
    }

    @Override
    public final String getDescription() {
        return Joiner.on((String)" : ").join((Object)super.getDescription(this.getAcademicServiceRequestType()), (Object)this.getProgramConclusion().getName().getContent(), new Object[0]);
    }

    @Override
    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.REGISTRY_DIPLOMA_REQUEST;
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.REGISTRY_DIPLOMA_REQUEST;
    }

    @Override
    public String getDocumentTemplateKey() {
        return this.getClass().getName();
    }

    public static Set<EventType> getPossibleEventTypes() {
        return ImmutableSet.of((Object)((Object)EventType.BOLONHA_DEGREE_REGISTRY_DIPLOMA_REQUEST), (Object)((Object)EventType.BOLONHA_MASTER_DEGREE_REGISTRY_DIPLOMA_REQUEST), (Object)((Object)EventType.BOLONHA_ADVANCED_FORMATION_REGISTRY_DIPLOMA_REQUEST));
    }

    @Override
    public EventType getEventType() {
        Sets.SetView eventTypesToUse = Sets.intersection(RegistryDiplomaRequest.getPossibleEventTypes(), this.getProgramConclusion().getEventTypes().getTypes());
        if (eventTypesToUse.size() != 1) {
            throw new DomainException("error.program.conclusion.many.event.types", new String[0]);
        }
        return (EventType)((Object)eventTypesToUse.iterator().next());
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            if (!this.getProgramConclusion().isConclusionProcessed(this.getRegistration())) {
                throw new DomainException("error.registryDiploma.registrationNotSubmitedToConclusionProcess", new String[0]);
            }
            if (this.getRegistryCode() == null) {
                this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
                this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
            if (this.getRegistration().isBolonha()) {
                this.getDiplomaSupplement().process();
            }
        } else if (academicServiceRequestBean.isToConclude()) {
            if (this.getRegistration().isBolonha() && this.getDiplomaSupplement().isConcludedSituationAccepted()) {
                this.getDiplomaSupplement().concludeServiceRequest();
            }
        } else if (academicServiceRequestBean.isToCancelOrReject()) {
            if (this.getRegistration().isBolonha() && academicServiceRequestBean.isToCancel()) {
                this.getDiplomaSupplement().cancel(academicServiceRequestBean.getJustification());
            }
            if (this.getRegistration().isBolonha() && academicServiceRequestBean.isToReject()) {
                this.getDiplomaSupplement().reject(academicServiceRequestBean.getJustification());
            }
        }
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPagedDocument() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return true;
    }

    public boolean isToPrint() {
        return false;
    }

    @Override
    public CycleType getRequestedCycle() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).filter(CurriculumModule::isCycleCurriculumGroup).map(cg -> ((CycleCurriculumGroup)((Object)((Object)cg))).getCycleType()).orElse(null);
    }

    @Override
    public LocalDate getConclusionDate() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(CurriculumGroup::getConclusionProcess).map(ConclusionProcess::getConclusionDate).orElse(null);
    }

    @Override
    public ExecutionYear getConclusionYear() {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(CurriculumGroup::getConclusionProcess).map(ConclusionProcess_Base::getConclusionYear).orElse(null);
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getProgramConclusion().groupFor(this.getRegistration()).map(cg -> cg.getDegreeModule().getGraduateTitle(this.getConclusionYear(), this.getLanguage())).orElse(null);
    }

    @Override
    public String getFinalAverage(Locale locale) {
        return this.getRegistration().getFinalGrade(this.getProgramConclusion()).getValue();
    }

    @Override
    public String getQualifiedAverageGrade(Locale locale) {
        Integer finalGrade = this.getRegistration().getFinalGrade(this.getProgramConclusion()).getIntegerValue();
        String qualifiedAverageGrade = finalGrade <= 13 ? "sufficient" : (finalGrade <= 15 ? "good" : (finalGrade <= 17 ? "verygood" : "excelent"));
        return "diploma.supplement.qualifiedgrade." + qualifiedAverageGrade;
    }

    @Override
    public String getProgrammeTypeDescription() {
        return this.getDegreeType().getName().getContent();
    }

    @Override
    public String getViewStudentProgrammeLink() {
        return "/student.do?method=visualizeRegistration&amp;registrationID=" + this.getRegistration().getExternalId();
    }

    @Override
    public String getReceivedActionLink() {
        return "/academicServiceRequestsManagement.do?method=prepareReceiveAcademicServiceRequest&amp;academicServiceRequestId=" + this.getExternalId();
    }

    @Override
    public boolean isProgrammeLinkVisible() {
        return this.getRegistration().isAllowedToManageRegistration();
    }

    @Override
    public String getDegreeName(ExecutionYear year) {
        return this.getDegree().getFilteredName(year);
    }
}

