/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.reports.RaidesCommonReportFieldsWrapper;
import org.fenixedu.academic.domain.reports.RaidesDfaReportFile_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaidesDfaReportFile
extends RaidesDfaReportFile_Base {
    private static final Logger logger = LoggerFactory.getLogger(RaidesDfaReportFile.class);

    public String getJobName() {
        return "Listagem RAIDES - DFA";
    }

    protected String getPrefix() {
        return "dfaRAIDES";
    }

    public DegreeType getDegreeType() {
        return DegreeType.matching(DegreeType::isAdvancedFormationDiploma).get();
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        ExecutionYear executionYear = this.getExecutionYear();
        this.createHeaders(spreadsheet);
        logger.info("BEGIN report for " + this.getDegreeType().getName().getContent());
        for (StudentCurricularPlan studentCurricularPlan : this.getStudentCurricularPlansToProcess(executionYear)) {
            Registration registration = studentCurricularPlan.getRegistration();
            if (registration == null || registration.isTransition()) continue;
            for (CycleType cycleType : registration.getDegreeType().getCycleTypes()) {
                CycleCurriculumGroup cycleCGroup = studentCurricularPlan.getRoot().getCycleCurriculumGroup(cycleType);
                if (cycleCGroup == null || cycleCGroup.isExternal()) continue;
                RegistrationConclusionBean registrationConclusionBean = new RegistrationConclusionBean(registration, (CurriculumGroup)((Object)cycleCGroup));
                ExecutionYear conclusionYear = null;
                if (cycleCGroup.isConcluded() && (conclusionYear = registrationConclusionBean.getConclusionYear()) != executionYear && conclusionYear != executionYear.getPreviousExecutionYear()) continue;
                boolean isToAddRegistration = false;
                boolean isActive = false;
                for (RegistrationState state : registration.getRegistrationStates(executionYear)) {
                    if (state.isActive() || state.getStateType() == RegistrationStateType.CONCLUDED) {
                        isToAddRegistration = true;
                    }
                    isActive |= state.isActive();
                }
                if (isToAddRegistration && conclusionYear != null) {
                    this.reportRaides(spreadsheet, registration, RaidesDfaReportFile.getFullRegistrationPath((Registration)registration), executionYear, cycleType, true, registrationConclusionBean.getConclusionDate());
                    continue;
                }
                if (!isActive) continue;
                this.reportRaides(spreadsheet, registration, RaidesDfaReportFile.getFullRegistrationPath((Registration)registration), executionYear, cycleType, false, null);
            }
        }
    }

    private Set<StudentCurricularPlan> getStudentCurricularPlansToProcess(ExecutionYear executionYear) {
        HashSet<StudentCurricularPlan> result = new HashSet<StudentCurricularPlan>();
        this.collectStudentCurricularPlansFor(executionYear, result);
        if (executionYear.getPreviousExecutionYear() != null) {
            this.collectStudentCurricularPlansFor(executionYear.getPreviousExecutionYear(), result);
        }
        return result;
    }

    private void collectStudentCurricularPlansFor(ExecutionYear executionYear, Set<StudentCurricularPlan> result) {
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesByType(this.getDegreeType())) {
            result.addAll(executionDegree.getDegreeCurricularPlan().getStudentCurricularPlansSet());
        }
    }

    private void createHeaders(Spreadsheet spreadsheet) {
        RaidesCommonReportFieldsWrapper.createHeaders(spreadsheet);
        spreadsheet.setHeader("Total ECTS necess\u00e1rios para a conclus\u00e3o");
    }

    private void reportRaides(Spreadsheet sheet, Registration registration, List<Registration> registrationPath, ExecutionYear executionYear, CycleType cycleType, boolean concluded, YearMonthDay conclusionDate) {
        Spreadsheet.Row row = RaidesCommonReportFieldsWrapper.reportRaidesFields(sheet, registration, registrationPath, executionYear, cycleType, concluded, conclusionDate, null, false);
        double totalEctsConcludedUntilPreviousYear = 0.0;
        for (CycleCurriculumGroup cycleCurriculumGroup : registration.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops()) {
            totalEctsConcludedUntilPreviousYear += cycleCurriculumGroup.getCreditsConcluded(executionYear.getPreviousExecutionYear()).doubleValue();
        }
        if (concluded) {
            row.setCell(Integer.valueOf(0));
        } else {
            row.setCell(Double.valueOf(registration.getLastStudentCurricularPlan().getRoot().getDefaultEcts(executionYear) - totalEctsConcludedUntilPreviousYear));
        }
    }
}

