/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.migration.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.activities.PhdThesisActivity;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.LocalDate;

public class SkipThesisJuryActivities
extends PhdThesisActivity {
    @Override
    protected void activityPreConditions(PhdThesisProcess process2, User userView) {
        if (process2.getActiveState() != PhdThesisProcessStateType.NEW) {
            throw new PreConditionNotValidException();
        }
        if (!process2.isAllowedToManageProcess(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdThesisProcess executeActivity(PhdThesisProcess process2, User userView, Object object) {
        PhdThesisProcessBean thesisBean = (PhdThesisProcessBean)object;
        process2.setWhenJuryDesignated(process2.getIndividualProgramProcess().getCandidacyDate());
        LocalDate candidacyDate = process2.getIndividualProgramProcess().getCandidacyDate();
        process2.setWhenJuryValidated(candidacyDate);
        process2.createState(PhdThesisProcessStateType.WAITING_FOR_JURY_REPORTER_FEEDBACK, userView.getPerson(), thesisBean.getRemarks());
        if (process2.getMeetingProcess() == null) {
            Process.createNewProcess(userView, PhdMeetingSchedulingProcess.class, (Object)thesisBean);
        }
        return process2;
    }
}

