/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.enrolments;

import java.util.Collection;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;

public class PhdValidCurricularCoursesExecutor
extends CurricularRuleExecutor {
    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CurricularCourse curricularCourse = this.getCurricularCourse(sourceDegreeModuleToEvaluate, curricularRule);
        if (!curricularCourse.hasAnyActiveContext(enrolmentContext.getExecutionPeriod())) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        Collection<CompetenceCourse> collection = this.getCompetenceCoursesAvailableToEnrol(enrolmentContext);
        if (!collection.contains((Object)curricularCourse.getCompetenceCourse())) {
            if (this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse))) {
                return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PhdValidCurricularCoursesExecutor.invalid.curricularCourse", curricularCourse.getName());
            }
            if (this.isApproved(enrolmentContext, curricularCourse) || this.isEnroled(enrolmentContext, (DegreeModule)((Object)curricularCourse))) {
                return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.PhdValidCurricularCoursesExecutor.invalid.curricularCourse", curricularCourse.getName());
            }
        }
        return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private CurricularCourse getCurricularCourse(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, ICurricularRule curricularRule) {
        if (sourceDegreeModuleToEvaluate.isOptional()) {
            return ((OptionalDegreeModuleToEnrol)sourceDegreeModuleToEvaluate).getCurricularCourse();
        }
        return (CurricularCourse)((Object)curricularRule.getDegreeModuleToApplyRule());
    }

    private Collection<CompetenceCourse> getCompetenceCoursesAvailableToEnrol(EnrolmentContext context) {
        return context.getRegistration().getPhdIndividualProgramProcess().getCompetenceCoursesAvailableToEnrol();
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }
}

