/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.email;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.joda.time.DateTime;

public abstract class PhdEmailBean
implements Serializable {
    private static int MAX_EMAILS_PER_LINE = 5;
    private static final long serialVersionUID = 1L;
    protected String bccs;
    protected String subject;
    protected String message;
    protected DateTime creationDate;
    protected Person creator;

    public String getBccs() {
        return this.bccs;
    }

    public void setBccs(String bccs) {
        this.bccs = bccs;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Person getCreator() {
        return this.creator;
    }

    public void setCreator(Person creator) {
        this.creator = creator;
    }

    public String getBccsView() {
        StringTokenizer tokenizer = new StringTokenizer(this.getBccs(), ",");
        StringBuilder result = new StringBuilder();
        int emailsCurrentLine = 0;
        while (tokenizer.hasMoreTokens()) {
            if (emailsCurrentLine == MAX_EMAILS_PER_LINE) {
                result.append('\n');
                emailsCurrentLine = 0;
            }
            result.append(tokenizer.nextToken());
            result.append(',');
            ++emailsCurrentLine;
        }
        if (!StringUtils.isEmpty((String)result.toString())) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

