/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.debts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFee$callable$create;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFeePenaltyExemption;
import org.fenixedu.academic.domain.phd.debts.PhdRegistrationFee_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdRegistrationFee
extends PhdRegistrationFee_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private PhdRegistrationFee() {
    }

    public PhdRegistrationFee(PhdIndividualProgramProcess process2) {
        this();
        this.init(process2.getAdministrativeOffice(), process2.getPerson(), process2);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, PhdIndividualProgramProcess process2) {
        super.init(administrativeOffice, EventType.PHD_REGISTRATION_FEE, person);
        this.checkProcess(process2);
        super.setProcess(process2);
    }

    private void checkProcess(PhdIndividualProgramProcess process2) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdRegistrationFee.process.cannot.be.null", args);
        }
        if (process2.getWhenFormalizedRegistration() == null) {
            throw new DomainException("error.PhdRegistrationFee.process.no.registration.formalization.date", new String[0]);
        }
        if (process2.getRegistrationFee() != null) {
            throw new DomainException("error.PhdRegistrationFee.process.already.has.registration.fee", new String[0]);
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    protected PhdProgram getPhdProgram() {
        return this.getProcess().getPhdProgram();
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public boolean hasPhdRegistrationFeePenaltyExemption() {
        return this.getPhdRegistrationFeePenaltyExemption() != null;
    }

    public PhdRegistrationFeePenaltyExemption getPhdRegistrationFeePenaltyExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof PhdRegistrationFeePenaltyExemption)) continue;
            return (PhdRegistrationFeePenaltyExemption)((Object)exemption);
        }
        return null;
    }

    public static PhdRegistrationFee create(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        return (PhdRegistrationFee)((Object)advice$create.perform((Callable)new PhdRegistrationFee$callable$create(phdIndividualProgramProcess)));
    }

    static /* synthetic */ PhdRegistrationFee advised$create(PhdIndividualProgramProcess process2) {
        return new PhdRegistrationFee(process2);
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.getProcess();
    }
}

