/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyEvent;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PhdProgramCandidacyPR
extends PhdProgramCandidacyPR_Base {
    private PhdProgramCandidacyPR() {
    }

    public PhdProgramCandidacyPR(ServiceAgreementTemplate serviceAgreementTemplate, DateTime startDate, DateTime endDate, Money amount) {
        this();
        this.init(EntryType.CANDIDACY_ENROLMENT_FEE, EventType.CANDIDACY_ENROLMENT, startDate, endDate, serviceAgreementTemplate, amount);
    }

    public PhdProgramCandidacyPR edit(Money amount) {
        this.deactivate();
        return new PhdProgramCandidacyPR(this.getServiceAgreementTemplate(), new DateTime().minus(1000L), null, amount);
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        PhdProgramCandidacyEvent candidacyEvent = (PhdProgramCandidacyEvent)((Object)event);
        if (candidacyEvent.hasPhdEventExemption()) {
            amountToPay = amountToPay.subtract(candidacyEvent.getPhdEventExemption().getValue());
        }
        return amountToPay.isPositive() ? amountToPay : Money.ZERO;
    }
}

