/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Locale;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCalendarUtil;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.alert.PhdAlertMessage;
import org.fenixedu.academic.domain.phd.alert.PhdRegistrationFormalizationAlert_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.User_Base;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PhdRegistrationFormalizationAlert
extends PhdRegistrationFormalizationAlert_Base {
    public PhdRegistrationFormalizationAlert(PhdIndividualProgramProcess process2, int maxDays) {
        this.init(process2);
        this.setMaxDays(maxDays);
    }

    private void init(PhdIndividualProgramProcess process2) {
        super.init(process2, this.buildSubject(process2), this.buildBody(process2));
    }

    private MultiLanguageString buildSubject(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.getSubjectPrefixed(process2, "message.phd.alert.registration.formalization.subject"));
    }

    private MultiLanguageString buildBody(PhdIndividualProgramProcess process2) {
        return new MultiLanguageString(Locale.getDefault(), AlertService.getBodyText(process2, "message.phd.alert.registration.formalization.body"));
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.alert.registration.formalization.description", (String[])new String[0]);
    }

    private LocalDate getWhenToFire() {
        return PhdProgramCalendarUtil.addWorkDaysTo(this.getProcess().getCandidacyProcess().getWhenRatified(), this.getMaxDays());
    }

    protected boolean isToDiscard() {
        return this.getFireDate() != null || this.getProcess().isRegistrationFormalized();
    }

    protected boolean isToFire() {
        return this.getProcess().getCandidacyProcess().getWhenRatified() != null && !new LocalDate().isBefore((ReadablePartial)this.getWhenToFire());
    }

    public boolean isSystemAlert() {
        return true;
    }

    protected void generateMessage() {
        AcademicAuthorizationGroup group = AcademicAuthorizationGroup.get(AcademicOperationType.MANAGE_PHD_PROCESSES, (AcademicProgram)((Object)this.getProcess().getPhdProgram()));
        ImmutableSet members = FluentIterable.from((Iterable)group.getMembers()).transform(User_Base::getPerson).toSet();
        new PhdAlertMessage(this.getProcess(), (Collection<Person>)members, this.getFormattedSubject(), this.getFormattedBody());
        new Message((Sender)((Object)this.getSender()), new Recipient((Group)group), this.buildMailSubject(), this.buildMailBody());
    }

    public boolean isToSendMail() {
        return true;
    }
}

