/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.log;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.CreditsDismissalLog_Base;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.util.EnrolmentAction;

public class CreditsDismissalLog
extends CreditsDismissalLog_Base {
    private CreditsDismissalLog() {
    }

    public CreditsDismissalLog(EnrolmentAction action, Registration registration, CurriculumGroup curriculumGroup, Credits credits, ExecutionSemester executionSemester, String who) {
        this();
        CourseGroup courseGroup = this.findCourseGroup(curriculumGroup);
        String[] args = new String[]{};
        if (courseGroup == null) {
            throw new DomainException("error.CreditsDismissalLog.invalid.courseGroup", args);
        }
        this.init(action, registration, (DegreeModule)((Object)courseGroup), executionSemester, who);
        this.setCredits(BigDecimal.valueOf(credits.getGivenCredits()));
        this.setSourceDescription(this.buildSourceDescription(credits));
    }

    private CourseGroup findCourseGroup(CurriculumGroup curriculumGroup) {
        return curriculumGroup.isNoCourseGroupCurriculumGroup() ? curriculumGroup.getCurriculumGroup().getDegreeModule() : curriculumGroup.getDegreeModule();
    }

    protected String getDegreeModuleName() {
        return this.getDegreeModule().getName();
    }
}

