/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup_Base;
import org.fenixedu.academic.domain.degreeStructure.CurricularCourseFunctor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.CourseGroupPredicates;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.I18N;

public class CourseGroup
extends CourseGroup_Base {
    public static List<CourseGroup> readCourseGroups() {
        ArrayList<CourseGroup> result = new ArrayList<CourseGroup>();
        for (DegreeModule degreeModule : Bennu.getInstance().getDegreeModulesSet()) {
            if (!(degreeModule instanceof CourseGroup)) continue;
            result.add((CourseGroup)((Object)degreeModule));
        }
        return result;
    }

    public CourseGroup() {
    }

    protected CourseGroup(String name, String nameEn) {
        this();
        this.init(name, nameEn);
    }

    protected void init(String name, String nameEn) {
        super.setName(name);
        super.setNameEn(nameEn);
    }

    public CourseGroup(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end) {
        this(parentCourseGroup, name, nameEn, begin, end, null);
    }

    public CourseGroup(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end, ProgramConclusion programConclusion) {
        this.init(parentCourseGroup, name, nameEn, begin, end, programConclusion);
    }

    protected void init(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end) {
        this.init(parentCourseGroup, name, nameEn, begin, end, null);
    }

    protected void init(CourseGroup parentCourseGroup, String name, String nameEn, ExecutionSemester begin, ExecutionSemester end, ProgramConclusion programConclusion) {
        this.init(name, nameEn);
        if (parentCourseGroup == null) {
            throw new DomainException("error.degreeStructure.CourseGroup.parentCourseGroup.cannot.be.null", new String[0]);
        }
        parentCourseGroup.checkDuplicateChildNames(name, nameEn);
        new Context(parentCourseGroup, (DegreeModule)((Object)this), null, begin, end);
        this.setProgramConclusion(programConclusion);
    }

    public boolean isLeaf() {
        return false;
    }

    public void edit(String name, String nameEn, Context context, ExecutionSemester beginExecutionPeriod, ExecutionSemester endExecutionPeriod, Boolean isOptional, ProgramConclusion programConclusion) {
        if (this.isRoot()) {
            this.setName(this.getParentDegreeCurricularPlan().getName());
            this.setNameEn(this.getParentDegreeCurricularPlan().getName());
        } else {
            this.setName(name);
            this.setNameEn(nameEn);
        }
        this.checkDuplicateBrotherNames(name, nameEn);
        if (!this.isRoot() && context != null) {
            context.edit(beginExecutionPeriod, endExecutionPeriod);
        }
        this.setIsOptional(isOptional);
        this.setProgramConclusion(programConclusion);
    }

    public Boolean getCanBeDeleted() {
        return super.getCanBeDeleted() != false && this.getChildContextsSet().isEmpty() && this.getOldCourseGroupChangeRequestsSet().isEmpty() && this.getNewCourseGroupChangeRequestsSet().isEmpty();
    }

    public void delete() {
        if (this.getCanBeDeleted().booleanValue()) {
            super.delete();
            while (!this.getParticipatingContextCurricularRulesSet().isEmpty()) {
                ((CurricularRule)this.getParticipatingContextCurricularRulesSet().iterator().next()).delete();
            }
        } else {
            throw new DomainException("courseGroup.notEmptyCourseGroupContexts", new String[0]);
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public void print(StringBuilder dcp, String tabs, Context previousContext) {
        String tab = tabs + "\t";
        dcp.append(tab);
        dcp.append("[CG ").append(this.getExternalId()).append("] ").append(this.getName()).append("\n");
        for (Context context : this.getSortedChildContextsWithCurricularCourses()) {
            context.getChildDegreeModule().print(dcp, tab, context);
        }
        for (Context context : this.getSortedChildContextsWithCourseGroups()) {
            context.getChildDegreeModule().print(dcp, tab, context);
        }
    }

    public boolean isRoot() {
        return false;
    }

    public DegreeCurricularPlan getParentDegreeCurricularPlan() {
        return !this.getParentContextsSet().isEmpty() ? ((Context)this.getParentContextsSet().iterator().next()).getParentCourseGroup().getParentDegreeCurricularPlan() : null;
    }

    public List<Context> getChildContexts(Class<? extends DegreeModule> clazz) {
        return this.getValidChildContexts(clazz, (ExecutionYear)null);
    }

    public List<Context> getValidChildContexts(ExecutionYear executionYear) {
        return this.getValidChildContexts(null, executionYear);
    }

    public List<Context> getValidChildContexts(ExecutionSemester executionSemester) {
        return this.getValidChildContexts(null, executionSemester);
    }

    public List<Context> getValidChildContexts(Class<? extends DegreeModule> clazz, ExecutionYear executionYear) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!this.hasClass(clazz, context.getChildDegreeModule()) || executionYear != null && !context.isValid(executionYear)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getValidChildContexts(Class<? extends DegreeModule> clazz, ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!this.hasClass(clazz, context.getChildDegreeModule()) || executionSemester != null && !context.isValid(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getSortedOpenChildContextsWithCurricularCourses(ExecutionYear executionYear) {
        List<Context> result = this.getOpenChildContexts(CurricularCourse.class, executionYear);
        Collections.sort(result);
        return result;
    }

    public List<Context> getSortedOpenChildContextsWithCourseGroups(ExecutionYear executionYear) {
        List<Context> result = this.getOpenChildContexts(CourseGroup.class, executionYear);
        Collections.sort(result);
        return result;
    }

    public List<Context> getSortedOpenChildContextsWithCourseGroups(ExecutionSemester executionSemester) {
        List<Context> result = this.getOpenChildContexts(CourseGroup.class, executionSemester);
        Collections.sort(result);
        return result;
    }

    public List<Context> getOpenChildContexts(Class<? extends DegreeModule> clazz, ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!this.hasClass(clazz, context.getChildDegreeModule()) || executionSemester != null && !context.isOpen(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getOpenChildContexts(Class<? extends DegreeModule> clazz, ExecutionYear executionYear) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!this.hasClass(clazz, context.getChildDegreeModule()) || executionYear != null && !context.isOpen(executionYear)) continue;
            result.add(context);
        }
        return result;
    }

    private boolean hasClass(Class<? extends DegreeModule> clazz, DegreeModule degreeModule) {
        return clazz == null || clazz.isAssignableFrom(((Object)((Object)degreeModule)).getClass());
    }

    public List<Context> getSortedChildContextsWithCurricularCourses() {
        List<Context> result = this.getChildContexts(CurricularCourse.class);
        Collections.sort(result);
        return result;
    }

    public List<Context> getSortedChildContextsWithCurricularCoursesByExecutionYear(ExecutionYear executionYear) {
        List<Context> result = this.getValidChildContexts(CurricularCourse.class, executionYear);
        Collections.sort(result);
        return result;
    }

    public List<Context> getSortedChildContextsWithCourseGroups() {
        ArrayList<Context> result = new ArrayList<Context>(this.getChildContexts(CourseGroup.class));
        Collections.sort(result);
        return result;
    }

    public List<Context> getSortedChildContextsWithCourseGroupsByExecutionYear(ExecutionYear executionYear) {
        List<Context> result = this.getValidChildContexts(CourseGroup.class, executionYear);
        Collections.sort(result);
        return result;
    }

    public List<CurricularRule> getParticipatingCurricularRules() {
        ArrayList<CurricularRule> result = new ArrayList<CurricularRule>();
        result.addAll(super.getParticipatingCurricularRules());
        result.addAll(this.getParticipatingContextCurricularRulesSet());
        return result;
    }

    public void setProgramConclusion(ProgramConclusion programConclusion) {
        this.checkDuplicateProgramConclusion(programConclusion);
        super.setProgramConclusion(programConclusion);
    }

    private void checkDuplicateProgramConclusion(ProgramConclusion programConclusion) {
        if (programConclusion == null) {
            return;
        }
        if (this.getParentDegreeCurricularPlan().getAllCoursesGroups().stream().filter(cg -> !cg.equals((Object)this)).map(CourseGroup_Base::getProgramConclusion).filter(Objects::nonNull).anyMatch(pc -> pc.equals((Object)programConclusion))) {
            throw new DomainException("error.program.conclusion.already.exists", programConclusion.getName().getContent());
        }
    }

    public void setName(String name) {
        AccessControl.check(this, CourseGroupPredicates.curricularPlanMemberWritePredicate);
        super.setName(name);
    }

    public void setNameEn(String nameEn) {
        AccessControl.check(this, CourseGroupPredicates.curricularPlanMemberWritePredicate);
        super.setNameEn(nameEn);
    }

    public void checkDuplicateChildNames(String name, String nameEn) {
        String normalizedNameEn;
        String normalizedName = StringFormatter.normalize(name);
        if (!this.verifyNames(normalizedName, normalizedNameEn = StringFormatter.normalize(nameEn))) {
            throw new DomainException("error.existingCourseGroupWithSameName", new String[0]);
        }
    }

    public void checkDuplicateBrotherNames(String name, String nameEn) {
        String normalizedName = StringFormatter.normalize(name);
        String normalizedNameEn = StringFormatter.normalize(nameEn);
        for (Context parentContext : this.getParentContextsSet()) {
            CourseGroup parentCourseGroup = parentContext.getParentCourseGroup();
            if (parentCourseGroup.verifyNames(normalizedName, normalizedNameEn, (DegreeModule)((Object)this))) continue;
            throw new DomainException("error.existingCourseGroupWithSameName", new String[0]);
        }
    }

    private boolean verifyNames(String normalizedName, String normalizedNameEn) {
        return this.verifyNames(normalizedName, normalizedNameEn, (DegreeModule)((Object)this));
    }

    private boolean verifyNames(String normalizedName, String normalizedNameEn, DegreeModule excludedModule) {
        for (Context context : this.getChildContextsSet()) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            if (degreeModule == excludedModule) continue;
            if (!Strings.isNullOrEmpty((String)degreeModule.getName()) && StringFormatter.normalize(degreeModule.getName()).equals(normalizedName)) {
                return false;
            }
            if (Strings.isNullOrEmpty((String)degreeModule.getNameEn()) || !StringFormatter.normalize(degreeModule.getNameEn()).equals(normalizedNameEn)) continue;
            return false;
        }
        return true;
    }

    public void orderChild(Context contextToOrder, int position) {
        List<Context> newSort = null;
        newSort = contextToOrder.getChildDegreeModule() instanceof CurricularCourse ? this.getSortedChildContextsWithCurricularCourses() : this.getSortedChildContextsWithCourseGroups();
        if (newSort.size() <= 1 || position < 0 || position > newSort.size()) {
            return;
        }
        newSort.remove(contextToOrder);
        newSort.add(position, contextToOrder);
        for (int newOrder = 0; newOrder < newSort.size(); ++newOrder) {
            Context context = newSort.get(newOrder);
            if (context == contextToOrder && newOrder != position) {
                throw new DomainException("wrong.order.algorithm", new String[0]);
            }
            context.setChildOrder(newOrder);
        }
    }

    public Set<DegreeModule> collectAllChildDegreeModules(Class<? extends DegreeModule> clazz, ExecutionYear executionYear) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getValidChildContexts(executionYear)) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            if (clazz.isAssignableFrom(((Object)((Object)degreeModule)).getClass())) {
                result.add(degreeModule);
            }
            if (degreeModule.isLeaf()) continue;
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            result.addAll(courseGroup.collectAllChildDegreeModules(clazz, executionYear));
        }
        return result;
    }

    public Set<DegreeModule> collectAllChildDegreeModules(Class<? extends DegreeModule> clazz, ExecutionSemester executionSemester) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getValidChildContexts(executionSemester)) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            if (clazz.isAssignableFrom(((Object)((Object)degreeModule)).getClass())) {
                result.add(degreeModule);
            }
            if (degreeModule.isLeaf()) continue;
            CourseGroup courseGroup = (CourseGroup)((Object)degreeModule);
            result.addAll(courseGroup.collectAllChildDegreeModules(clazz, executionSemester));
        }
        return result;
    }

    public void collectChildDegreeModulesIncludingFullPath(Class<? extends DegreeModule> clazz, List<List<DegreeModule>> result, List<DegreeModule> previousDegreeModulesPath, ExecutionYear executionYear) {
        List<DegreeModule> currentDegreeModulesPath = previousDegreeModulesPath;
        for (Context context : this.getValidChildContexts(executionYear)) {
            List<DegreeModule> newDegreeModulesPath = null;
            if (clazz.isAssignableFrom(((Object)((Object)context.getChildDegreeModule())).getClass())) {
                newDegreeModulesPath = this.initNewDegreeModulesPath(newDegreeModulesPath, currentDegreeModulesPath, context.getChildDegreeModule());
                result.add(newDegreeModulesPath);
            }
            if (context.getChildDegreeModule().isLeaf()) continue;
            newDegreeModulesPath = this.initNewDegreeModulesPath(newDegreeModulesPath, currentDegreeModulesPath, context.getChildDegreeModule());
            ((CourseGroup)((Object)context.getChildDegreeModule())).collectChildDegreeModulesIncludingFullPath(clazz, result, newDegreeModulesPath, executionYear);
        }
    }

    private List<DegreeModule> initNewDegreeModulesPath(List<DegreeModule> newDegreeModulesPath, List<DegreeModule> currentDegreeModulesPath, DegreeModule degreeModule) {
        if (newDegreeModulesPath == null) {
            newDegreeModulesPath = new ArrayList<DegreeModule>(currentDegreeModulesPath);
            newDegreeModulesPath.add(degreeModule);
        }
        return newDegreeModulesPath;
    }

    public Collection<CourseGroup> getNotOptionalChildCourseGroups(ExecutionSemester executionSemester) {
        Collection<DegreeModule> degreeModules = this.getDegreeModulesByExecutionPeriod(executionSemester);
        Collection<CurricularRule> curricularRules = this.getCurricularRulesByExecutionPeriod(executionSemester);
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = this.getDegreeModulesSelectionLimitRule(curricularRules);
        if (degreeModulesSelectionLimit != null) {
            if (degreeModulesSelectionLimit.getMinimumLimit().equals(degreeModulesSelectionLimit.getMaximumLimit()) && degreeModulesSelectionLimit.getMaximumLimit().equals(degreeModules.size())) {
                return this.filterCourseGroups(degreeModules);
            }
            return Collections.EMPTY_LIST;
        }
        return this.filterCourseGroups(degreeModules);
    }

    private Collection<CourseGroup> filterCourseGroups(Collection<DegreeModule> degreeModules) {
        HashSet<CourseGroup> result = new HashSet<CourseGroup>();
        for (DegreeModule degreeModule : degreeModules) {
            if (degreeModule.isLeaf()) continue;
            result.add((CourseGroup)((Object)degreeModule));
        }
        return result;
    }

    private DegreeModulesSelectionLimit getDegreeModulesSelectionLimitRule(Collection<CurricularRule> curricularRules) {
        for (CurricularRule curricularRule : curricularRules) {
            if (curricularRule.getCurricularRuleType() != CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT) continue;
            return (DegreeModulesSelectionLimit)((Object)curricularRule);
        }
        return null;
    }

    private Collection<CurricularRule> getCurricularRulesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<CurricularRule> result = new HashSet<CurricularRule>();
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (!curricularRule.isValid(executionSemester)) continue;
            result.add(curricularRule);
        }
        return result;
    }

    private Collection<DegreeModule> getDegreeModulesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getChildContextsSet()) {
            if (!context.isValid(executionSemester)) continue;
            result.add(context.getChildDegreeModule());
        }
        return result;
    }

    public boolean validate(CurricularCourse curricularCourse) {
        for (Context context : this.getChildContextsSet()) {
            CurricularCourse childCurricularCourse;
            if (!(context.getChildDegreeModule() instanceof CurricularCourse) || !(childCurricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule())).isEquivalent(curricularCourse)) continue;
            return true;
        }
        return false;
    }

    public Collection<Context> getContextsWithCurricularCourseByCurricularPeriod(CurricularPeriod curricularPeriod, ExecutionSemester executionSemester) {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!context.getChildDegreeModule().isLeaf() || context.getCurricularPeriod() == null || !context.getCurricularPeriod().equals(curricularPeriod) || !context.isValid(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public Set<DegreeModule> getOpenChildDegreeModulesByExecutionPeriod(ExecutionSemester executionSemester) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getChildContextsSet()) {
            if (!context.isOpen(executionSemester)) continue;
            result.add(context.getChildDegreeModule());
        }
        return result;
    }

    public Set<CourseGroup> getParentCourseGroups() {
        HashSet<CourseGroup> result = new HashSet<CourseGroup>();
        for (Context context : this.getParentContextsSet()) {
            result.add(context.getParentCourseGroup());
        }
        return result;
    }

    public Double getMaxEctsCredits(ExecutionSemester executionSemester) {
        List creditsLimitRules = this.getCurricularRules(CurricularRuleType.CREDITS_LIMIT, executionSemester);
        if (!creditsLimitRules.isEmpty()) {
            for (CreditsLimit creditsLimit : creditsLimitRules) {
                if (!this.getParentCourseGroups().contains((Object)creditsLimit.getContextCourseGroup())) continue;
                return creditsLimit.getMaximumCredits();
            }
            return ((CreditsLimit)((Object)creditsLimitRules.iterator().next())).getMaximumCredits();
        }
        Set<DegreeModule> modulesByExecutionPeriod = this.getOpenChildDegreeModulesByExecutionPeriod(executionSemester);
        DegreeModulesSelectionLimit modulesSelectionLimit = this.getDegreeModulesSelectionLimitRule(executionSemester);
        if (modulesSelectionLimit != null) {
            return this.countMaxEctsCredits(modulesByExecutionPeriod, executionSemester, modulesSelectionLimit.getMaximumLimit());
        }
        return this.countMaxEctsCredits(modulesByExecutionPeriod, executionSemester, modulesByExecutionPeriod.size());
    }

    private Double countMaxEctsCredits(Collection<DegreeModule> modulesByExecutionPeriod, ExecutionSemester executionSemester, Integer maximumLimit) {
        ArrayList<Double> ectsCredits = new ArrayList<Double>();
        for (DegreeModule degreeModule : modulesByExecutionPeriod) {
            ectsCredits.add(degreeModule.getMaxEctsCredits(executionSemester));
        }
        Collections.sort(ectsCredits, new ReverseComparator());
        return this.sumEctsCredits(ectsCredits, maximumLimit);
    }

    public Double getMinEctsCredits(ExecutionSemester executionSemester) {
        List creditsLimitRules = this.getCurricularRules(CurricularRuleType.CREDITS_LIMIT, executionSemester);
        if (!creditsLimitRules.isEmpty()) {
            for (CreditsLimit creditsLimit : creditsLimitRules) {
                if (!this.getParentCourseGroups().contains((Object)creditsLimit.getContextCourseGroup())) continue;
                return creditsLimit.getMinimumCredits();
            }
            return ((CreditsLimit)((Object)creditsLimitRules.iterator().next())).getMinimumCredits();
        }
        Set<DegreeModule> modulesByExecutionPeriod = this.getOpenChildDegreeModulesByExecutionPeriod(executionSemester);
        DegreeModulesSelectionLimit modulesSelectionLimit = this.getDegreeModulesSelectionLimitRule(executionSemester);
        if (modulesSelectionLimit != null) {
            return this.countMinEctsCredits(modulesByExecutionPeriod, executionSemester, modulesSelectionLimit.getMinimumLimit());
        }
        return this.countMinEctsCredits(modulesByExecutionPeriod, executionSemester, modulesByExecutionPeriod.size());
    }

    private Double countMinEctsCredits(Collection<DegreeModule> modulesByExecutionPeriod, ExecutionSemester executionSemester, Integer minimumLimit) {
        ArrayList<Double> ectsCredits = new ArrayList<Double>();
        for (DegreeModule degreeModule : modulesByExecutionPeriod) {
            ectsCredits.add(degreeModule.getMinEctsCredits(executionSemester));
        }
        Collections.sort(ectsCredits);
        return this.sumEctsCredits(ectsCredits, minimumLimit);
    }

    private Double sumEctsCredits(List<Double> ectsCredits, int limit) {
        double result = 0.0;
        Iterator<Double> ectsCreditsIter = ectsCredits.iterator();
        while (ectsCreditsIter.hasNext() && limit > 0) {
            result += ectsCreditsIter.next().doubleValue();
            --limit;
        }
        return result;
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        if (super.hasDegreeModule(degreeModule)) {
            return true;
        }
        for (Context context : this.getChildContextsSet()) {
            if (!context.getChildDegreeModule().hasDegreeModule(degreeModule)) continue;
            return true;
        }
        return false;
    }

    public Context addCurricularCourse(CurricularCourse curricularCourse, CurricularPeriod curricularPeriod, ExecutionSemester begin, ExecutionSemester end) {
        return this.addContext((DegreeModule)((Object)curricularCourse), curricularPeriod, begin, end);
    }

    public Context addContext(DegreeModule degreeModule, CurricularPeriod curricularPeriod, ExecutionSemester begin, ExecutionSemester end) {
        if (!this.allowChildWith(begin)) {
            throw new DomainException("degreeModule.cannot.add.context.with.begin.execution.period", this.getName(), begin.getName(), begin.getExecutionYear().getYear());
        }
        return new Context(this, degreeModule, curricularPeriod, begin, end);
    }

    public void getAllDegreeModules(Collection<DegreeModule> degreeModules) {
        degreeModules.add((DegreeModule)((Object)this));
        for (Context context : this.getChildContextsSet()) {
            context.getAllDegreeModules(degreeModules);
        }
    }

    public void getAllCoursesGroupse(Set<CourseGroup> courseGroups) {
        for (Context context : this.getChildContextsSet()) {
            context.addAllCourseGroups(courseGroups);
        }
    }

    public boolean allowChildWith(ExecutionSemester executionSemester) {
        return this.getMinimumExecutionPeriod().isBeforeOrEquals(executionSemester);
    }

    public Set<Context> getChildContextsSortedByDegreeModuleName() {
        TreeSet<Context> contexts = new TreeSet<Context>(Context.COMPARATOR_BY_DEGREE_MODULE_NAME);
        contexts.addAll(this.getChildContextsSet());
        return contexts;
    }

    public Set<DegreeModule> getChildDegreeModules() {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getChildContextsSet()) {
            result.add(context.getChildDegreeModule());
        }
        return result;
    }

    public Set<DegreeModule> getChildDegreeModulesValidOn(ExecutionSemester executionSemester) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getValidChildContexts(executionSemester)) {
            result.add(context.getChildDegreeModule());
        }
        return result;
    }

    public Set<DegreeModule> getChildDegreeModulesValidOn(ExecutionYear executionYear) {
        HashSet<DegreeModule> result = new HashSet<DegreeModule>();
        for (Context context : this.getValidChildContexts(executionYear)) {
            result.add(context.getChildDegreeModule());
        }
        return result;
    }

    public Set<Context> getActiveChildContexts() {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : this.getChildContextsSet()) {
            if (!context.isOpen()) continue;
            result.add(context);
        }
        return result;
    }

    public Set<Context> getActiveChildContextsWithMax(ExecutionSemester executionSemester) {
        HashMap<DegreeModule, Context> maxContextsByDegreeModule = new HashMap<DegreeModule, Context>();
        for (Context context : this.getActiveChildContexts()) {
            if (maxContextsByDegreeModule.containsKey((Object)context.getChildDegreeModule())) {
                Context existingContext = (Context)maxContextsByDegreeModule.get((Object)context.getChildDegreeModule());
                if (existingContext.getCurricularPeriod().getChildOrder().intValue() == executionSemester.getSemester().intValue() || context.getCurricularPeriod().getChildOrder().intValue() != executionSemester.getSemester().intValue()) continue;
                maxContextsByDegreeModule.put(context.getChildDegreeModule(), context);
                continue;
            }
            maxContextsByDegreeModule.put(context.getChildDegreeModule(), context);
        }
        return new HashSet<Context>(maxContextsByDegreeModule.values());
    }

    public Map<CurricularPeriod, Set<Context>> getActiveChildCurricularContextsWithMaxByCurricularPeriod(ExecutionSemester executionSemester) {
        HashMap<CurricularPeriod, Set<Context>> result = new HashMap<CurricularPeriod, Set<Context>>();
        for (Context context : this.getActiveChildContextsWithMax(executionSemester)) {
            if (!context.getChildDegreeModule().isCurricularCourse()) continue;
            if (!result.containsKey(context.getCurricularPeriod())) {
                result.put(context.getCurricularPeriod(), new HashSet());
            }
            ((Set)result.get(context.getCurricularPeriod())).add(context);
        }
        return result;
    }

    public Set<CurricularCourse> getChildCurricularCoursesValidOn(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (Context context : this.getValidChildContexts(executionSemester)) {
            if (!context.getChildDegreeModule().isCurricularCourse()) continue;
            result.add((CurricularCourse)((Object)context.getChildDegreeModule()));
        }
        return result;
    }

    public List<Context> getChildContextsForCurricularCourses(ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getChildContexts(CurricularCourse.class)) {
            if (!context.isValid(executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public Set<Context> getActiveChildContextsWithMaxCurricularPeriodForCurricularCourses(ExecutionSemester executionSemester) {
        HashSet<Context> result = new HashSet<Context>();
        for (Context context : this.getActiveChildContextsWithMax(executionSemester)) {
            if (!context.getChildDegreeModule().isCurricularCourse()) continue;
            result.add(context);
        }
        return result;
    }

    public boolean hasDegreeModuleOnChilds(DegreeModule degreeModuleToSearch) {
        for (Context context : this.getChildContextsSet()) {
            if (context.getChildDegreeModule() != degreeModuleToSearch) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyChildContextWithCurricularCourse() {
        for (Context context : this.getChildContextsSet()) {
            if (!context.getChildDegreeModule().isCurricularCourse()) continue;
            return true;
        }
        return false;
    }

    public boolean isCourseGroup() {
        return true;
    }

    public Set<CurricularCourse> getAllCurricularCourses(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (Context context : this.getChildContextsSet()) {
            if (executionSemester != null && !context.isOpen(executionSemester)) continue;
            result.addAll(context.getChildDegreeModule().getAllCurricularCourses(executionSemester));
        }
        return result;
    }

    public Set<CurricularCourse> getAllCurricularCourses() {
        return this.getAllCurricularCourses(null);
    }

    public Set<CurricularCourse> getAllOpenCurricularCourses() {
        return this.getAllCurricularCourses(ExecutionSemester.readActualExecutionSemester());
    }

    public Set<ExecutionYear> getBeginContextExecutionYears() {
        HashSet<ExecutionYear> result = new HashSet<ExecutionYear>();
        for (Context context : this.getChildContexts(CourseGroup.class)) {
            result.add(context.getBeginExecutionPeriod().getExecutionYear());
            result.addAll(((CourseGroup)((Object)context.getChildDegreeModule())).getBeginContextExecutionYears());
        }
        return result;
    }

    public void doForAllCurricularCourses(CurricularCourseFunctor curricularCourseFunctor) {
        for (Context context : this.getChildContextsSet()) {
            DegreeModule degreeModule = context.getChildDegreeModule();
            degreeModule.doForAllCurricularCourses(curricularCourseFunctor);
            if (curricularCourseFunctor.keepDoing()) continue;
            return;
        }
    }

    public boolean hasAnyParentBranchCourseGroup() {
        if (this.isBranchCourseGroup()) {
            return true;
        }
        for (Context context : this.getParentContextsSet()) {
            if (!context.getParentCourseGroup().hasAnyParentBranchCourseGroup()) continue;
            return true;
        }
        return false;
    }

    public void applyToCurricularCourses(ExecutionYear executionYear, Predicate predicate) {
        for (Context context : this.getChildContextsSet()) {
            if (executionYear != null && !context.isValid(executionYear)) continue;
            DegreeModule childDegreeModule = context.getChildDegreeModule();
            childDegreeModule.applyToCurricularCourses(executionYear, predicate);
        }
    }

    public Context createContext(ExecutionInterval begin, ExecutionInterval end, DegreeModule degreeModule, CurricularPeriod curricularPeriod) {
        Context context = new Context(this, degreeModule, curricularPeriod, ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, begin), ExecutionInterval.assertExecutionIntervalType(ExecutionSemester.class, end));
        if (degreeModule != null) {
            for (Context parentContext : degreeModule.getParentContextsSet()) {
                if (parentContext.getParentCourseGroup().getParentDegreeCurricularPlan() == this.getParentDegreeCurricularPlan()) continue;
                throw new DomainException("error.CourseGroup.mismatch.ParentDegreeCurricularPlan", new String[0]);
            }
        }
        return context;
    }

    public boolean isOptionalCourseGroup() {
        return super.getIsOptional();
    }

    public Double getDefaultEcts(ExecutionYear executionYear) {
        CreditsLimit creditsLimit = (CreditsLimit)((Object)this.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, null, executionYear));
        if (creditsLimit != null) {
            return creditsLimit.getMinimumCredits();
        }
        if (this.getDegreeType().hasExactlyOneCycleType()) {
            return this.getDegree().getEctsCredits();
        }
        throw new DomainException("error.CycleCourseGroup.cannot.calculate.default.ects.credits", new String[0]);
    }

    public String getDegreeNameWithTitleSuffix(ExecutionYear executionYear, Locale locale) {
        String degreeFilteredName = this.getDegree().getFilteredName(executionYear, locale);
        String suffix = this.getGraduateTitleSuffix(executionYear, locale);
        if (!StringUtils.isEmpty((String)suffix) && !degreeFilteredName.contains(suffix.trim())) {
            degreeFilteredName = suffix + " " + degreeFilteredName;
        }
        return degreeFilteredName;
    }

    public final String getGraduateTitle() {
        return this.getGraduateTitle(ExecutionYear.readCurrentExecutionYear(), I18N.getLocale());
    }

    public String getGraduateTitleSuffix(ExecutionYear executionYear, Locale locale) {
        return null;
    }

    public final String getGraduateTitle(ExecutionYear executionYear, Locale locale) {
        return this.getProgramConclusion() == null ? null : this.getProgramConclusion().getGraduationTitle(locale, this.getDegreeNameWithTitleSuffix(executionYear, locale));
    }
}

