/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;

public class CreditsLimitExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CreditsLimit rule = (CreditsLimit)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule degreeModule = rule.getDegreeModuleToApplyRule();
        if (degreeModule.isOptional()) {
            return this.evaluateIfCanEnrolToOptionalDegreeModule(enrolmentContext, rule, sourceDegreeModuleToEvaluate);
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, (ICurricularRule)((Object)rule));
        if (degreeModuleToEvaluate.isEnroled()) {
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            CurriculumModule curriculumModule = moduleEnroledWrapper.getCurriculumModule();
            Double ectsCredits = curriculumModule.getAprovedEctsCredits() + this.calculateEnroledEctsCredits(enrolmentContext, curriculumModule) + this.calculateEctsCreditsFromToEnrolCurricularCourses(enrolmentContext, curriculumModule);
            if (rule.creditsExceedMaximum(ectsCredits)) {
                if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                    return this.createImpossibleResult(rule, sourceDegreeModuleToEvaluate, ectsCredits);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate, ectsCredits);
            }
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private Double calculateEnroledEctsCredits(EnrolmentContext enrolmentContext, CurriculumModule curriculumModule) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionYear()) : curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod());
    }

    private Double calculatePreviousPeriodEnroledEctsCredits(EnrolmentContext enrolmentContext, CurriculumModule curriculumModule) {
        return enrolmentContext.isToEvaluateRulesByYear() ? curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionYear().getPreviousExecutionYear()) : curriculumModule.getEnroledEctsCredits(enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
    }

    private RuleResult evaluateIfCanEnrolToOptionalDegreeModule(EnrolmentContext enrolmentContext, CreditsLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        CurricularCourse curricularCourse = sourceDegreeModuleToEvaluate.isEnroled() ? (CurricularCourse)((Object)sourceDegreeModuleToEvaluate.getDegreeModule()) : ((OptionalDegreeModuleToEnrol)sourceDegreeModuleToEvaluate).getCurricularCourse();
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        Double ectsCredits = curricularCourse.getEctsCredits(executionSemester);
        return rule.allowCredits(ectsCredits) ? RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule()) : this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate, ectsCredits);
    }

    private Double calculateEctsCreditsFromToEnrolCurricularCourses(EnrolmentContext enrolmentContext, CurriculumModule parentCurriculumModule) {
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        BigDecimal result = BigDecimal.ZERO;
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling() || !parentCurriculumModule.hasCurriculumModule((CurriculumModule)((Object)degreeModuleToEvaluate.getCurriculumGroup()))) continue;
            result = result.add(BigDecimal.valueOf(degreeModuleToEvaluate.getEctsCredits(executionSemester)));
        }
        return result.doubleValue();
    }

    private RuleResult createFalseRuleResult(CreditsLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, Double ectsCredits) {
        if (rule.getMinimumCredits().equals(rule.getMaximumCredits())) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitExecutor.limit.not.fulfilled", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), ectsCredits.toString());
        }
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitExecutor.limits.not.fulfilled", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), rule.getMaximumCredits().toString(), ectsCredits.toString());
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CreditsLimit rule = (CreditsLimit)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        DegreeModule degreeModule = rule.getDegreeModuleToApplyRule();
        if (degreeModule.isOptional()) {
            return this.evaluateIfCanEnrolToOptionalDegreeModule(enrolmentContext, rule, sourceDegreeModuleToEvaluate);
        }
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, (ICurricularRule)((Object)rule));
        if (degreeModuleToEvaluate.isEnroled()) {
            EnroledCurriculumModuleWrapper moduleEnroledWrapper = (EnroledCurriculumModuleWrapper)degreeModuleToEvaluate;
            CurriculumModule curriculumModule = moduleEnroledWrapper.getCurriculumModule();
            Double ectsCredits = curriculumModule.getAprovedEctsCredits() + this.calculateEnroledEctsCredits(enrolmentContext, curriculumModule) + this.calculateEctsCreditsFromToEnrolCurricularCourses(enrolmentContext, curriculumModule);
            if (rule.creditsExceedMaximum(ectsCredits)) {
                if (sourceDegreeModuleToEvaluate.isEnroled() && sourceDegreeModuleToEvaluate.isLeaf()) {
                    return this.createImpossibleResult(rule, sourceDegreeModuleToEvaluate, ectsCredits);
                }
                return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate, ectsCredits);
            }
            if (rule.creditsExceedMaximum(ectsCredits = Double.valueOf(ectsCredits + this.calculatePreviousPeriodEnroledEctsCredits(enrolmentContext, curriculumModule)))) {
                return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitExecutor.exceeded.maximum.credits.limit", ectsCredits.toString(), rule.getMaximumCredits().toString(), curriculumModule.getName().getContent());
            }
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    private RuleResult createImpossibleResult(CreditsLimit rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, Double ectsCredits) {
        if (rule.getMinimumCredits().equals(rule.getMaximumCredits())) {
            return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitExecutor.limit.not.fulfilled", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), ectsCredits.toString());
        }
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.CreditsLimitExecutor.limits.not.fulfilled", rule.getDegreeModuleToApplyRule().getName(), rule.getMinimumCredits().toString(), rule.getMaximumCredits().toString(), ectsCredits.toString());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

