/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.RestrictionEnroledDegreeModule_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.RestrictionEnroledDegreeModuleVerifier;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.util.LogicOperator;
import org.fenixedu.academic.dto.CurricularPeriodInfoDTO;
import org.fenixedu.academic.dto.GenericPair;

public class RestrictionEnroledDegreeModule
extends RestrictionEnroledDegreeModule_Base {
    private RestrictionEnroledDegreeModule(CurricularCourse toBeEnroled) {
        if (toBeEnroled == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.setPrecedenceDegreeModule((DegreeModule)((Object)toBeEnroled));
        this.setCurricularRuleType(CurricularRuleType.PRECEDENCY_ENROLED_DEGREE_MODULE);
    }

    public RestrictionEnroledDegreeModule(CurricularCourse toApplyRule, CurricularCourse toBeEnroled, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO, ExecutionSemester begin, ExecutionSemester end) {
        this(toBeEnroled);
        this.init((DegreeModule)((Object)toApplyRule), contextCourseGroup, begin, end);
        if (curricularPeriodInfoDTO != null) {
            this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
            this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
        }
    }

    protected void edit(DegreeModule enroledDegreeModule, CourseGroup contextCourseGroup, CurricularPeriodInfoDTO curricularPeriodInfoDTO) {
        this.setPrecedenceDegreeModule(enroledDegreeModule);
        this.setContextCourseGroup(contextCourseGroup);
        this.setAcademicPeriod(curricularPeriodInfoDTO.getPeriodType());
        this.setCurricularPeriodOrder(curricularPeriodInfoDTO.getOrder());
    }

    public CurricularCourse getDegreeModuleToApplyRule() {
        return (CurricularCourse)((Object)super.getDegreeModuleToApplyRule());
    }

    public CurricularCourse getPrecedenceDegreeModule() {
        return (CurricularCourse)((Object)super.getPrecedenceDegreeModule());
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        if (this.belongsToCompositeRule() && this.getParentCompositeRule().getCompositeRuleType().equals((Object)LogicOperator.NOT)) {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceNotEnrolled", true));
        } else {
            labelList.add(new GenericPair<String, Boolean>("label.precedenceEnrolled", true));
        }
        labelList.add(new GenericPair<String, Boolean>(": ", false));
        String precedenceDegreeModule = this.getPrecedenceDegreeModule().isLeaf() ? this.getPrecedenceDegreeModule().getName() : this.getPrecedenceDegreeModule().getOneFullName();
        labelList.add(new GenericPair<String, Boolean>(precedenceDegreeModule, false));
        if (this.getContextCourseGroup() != null) {
            labelList.add(new GenericPair<String, Boolean>(", ", false));
            labelList.add(new GenericPair<String, Boolean>("label.inContext", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getContextCourseGroup().getOneFullName(), false));
        }
        if (!this.hasNoCurricularPeriodOrder()) {
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.and", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>("label.in", true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(this.getAcademicPeriod().getName(), true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<Integer, Boolean>(this.getCurricularPeriodOrder(), false));
        }
        return labelList;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return new RestrictionEnroledDegreeModuleVerifier();
    }
}

