/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.PercentageGratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.ValueGratuityExemption;
import org.fenixedu.academic.domain.phd.debts.PhdEventExemption;

public class ExemptionWrapper {
    Exemption exemption;

    public ExemptionWrapper(Exemption exemption) {
        this.exemption = exemption;
    }

    public String getExemptionTypeDescription() {
        return this.exemption.getExemptionJustification().getDescription().toString();
    }

    public String getExemptionValue() {
        if (this.exemption.isAcademicEventExemption()) {
            return "-";
        }
        if (this.exemption.isGratuityExemption()) {
            GratuityExemption gratuityExemption = (GratuityExemption)((Object)this.exemption);
            if (gratuityExemption.isPercentageExemption()) {
                return "-";
            }
            if (gratuityExemption.isValueExemption()) {
                return ((ValueGratuityExemption)((Object)gratuityExemption)).getValue().toPlainString();
            }
        } else {
            if (this.exemption.isAdministrativeOfficeFeeAndInsuranceExemption()) {
                return "-";
            }
            if (this.exemption.isInsuranceExemption()) {
                return "-";
            }
            if (this.exemption.isForAdministrativeOfficeFee()) {
                return "-";
            }
            if (this.exemption.isPenaltyExemption()) {
                return "-";
            }
            if (this.exemption.isPhdEventExemption()) {
                return ((PhdEventExemption)((Object)this.exemption)).getValue().toPlainString();
            }
            if (this.exemption.isSecondCycleIndividualCandidacyExemption()) {
                return "-";
            }
        }
        throw new RuntimeException("unknown exemption");
    }

    public String getPercentage() {
        if (this.exemption.isAcademicEventExemption()) {
            return "-";
        }
        if (this.exemption.isGratuityExemption()) {
            GratuityExemption gratuityExemption = (GratuityExemption)((Object)this.exemption);
            if (gratuityExemption.isPercentageExemption()) {
                return ((PercentageGratuityExemption)((Object)gratuityExemption)).getPercentage().toString();
            }
            if (gratuityExemption.isValueExemption()) {
                return "-";
            }
        } else {
            if (this.exemption.isAdministrativeOfficeFeeAndInsuranceExemption()) {
                return "-";
            }
            if (this.exemption.isInsuranceExemption()) {
                return "-";
            }
            if (this.exemption.isForAdministrativeOfficeFee()) {
                return "-";
            }
            if (this.exemption.isPenaltyExemption()) {
                return "-";
            }
            if (this.exemption.isPhdEventExemption()) {
                return "-";
            }
            if (this.exemption.isSecondCycleIndividualCandidacyExemption()) {
                return "-";
            }
        }
        throw new RuntimeException("unknown exemption");
    }

    public String getJustification() {
        return this.exemption.getExemptionJustification().getReason();
    }
}

