/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.ProgramCertificateRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class ProgramCertificateRequestPR
extends ProgramCertificateRequestPR_Base {
    protected ProgramCertificateRequestPR() {
    }

    public ProgramCertificateRequestPR(ServiceAgreementTemplate serviceAgreementTemplate, DateTime startDate, DateTime endDate, Money certificateAmount, Money amountFirstPage, Money amountPerPage) {
        this();
        super.init(EntryType.PROGRAM_CERTIFICATE_REQUEST_FEE, EventType.PROGRAM_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, certificateAmount, amountPerPage);
        this.checkParameters(amountFirstPage);
        super.setAmountFirstPage(amountFirstPage);
    }

    protected void checkParameters(Money amountFirstPage) {
        if (amountFirstPage == null) {
            throw new DomainException("error.accounting.postingRules.ProgramCertificateRequestPR.amountFirstPage.cannot.be.null", new String[0]);
        }
    }

    public ProgramCertificateRequestPR edit(Money certificateAmount, Money amountFirstPage, Money amountPerPage) {
        this.deactivate();
        return new ProgramCertificateRequestPR(this.getServiceAgreementTemplate(), new DateTime().minus(1000L), null, certificateAmount, amountFirstPage, amountPerPage);
    }

    protected Money getAmountForPages(Event event) {
        CertificateRequestEvent requestEvent = (CertificateRequestEvent)((Object)event);
        int extraPages = requestEvent.getNumberOfPages() - 1;
        return extraPages <= 0 ? Money.ZERO : this.getAmountFirstPage().add(this.getAmountPerPage().multiply(BigDecimal.valueOf(--extraPages)));
    }

    protected boolean isUrgent(Event event) {
        return ((CertificateRequestEvent)((Object)event)).isUrgentRequest();
    }
}

