/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.OccupationPeriod_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.date.IntervalTools;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class OccupationPeriod
extends OccupationPeriod_Base {
    private OccupationPeriod() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public OccupationPeriod(Interval interval) {
        this();
        if (interval == null) {
            throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
        }
        this.setPeriodInterval(interval);
    }

    public OccupationPeriod(Iterator<Interval> intervals) {
        this();
        if (intervals == null || !intervals.hasNext()) {
            throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
        }
        Interval interval = intervals.next();
        this.setPeriodInterval(interval);
        if (intervals.hasNext()) {
            this.setNextPeriod(new OccupationPeriod(intervals));
        }
    }

    @Deprecated
    public OccupationPeriod(YearMonthDay startDate, YearMonthDay endDate) {
        this();
        if (startDate == null || endDate == null || startDate.isAfter((ReadablePartial)endDate)) {
            throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
        }
        this.setPeriodInterval(IntervalTools.getInterval(startDate, endDate));
    }

    @Deprecated
    public OccupationPeriod(YearMonthDay ... yearMonthDays) {
        this((OccupationPeriod)null, yearMonthDays);
    }

    @Deprecated
    protected OccupationPeriod(OccupationPeriod previous, YearMonthDay ... yearMonthDays) {
        this();
        int l = yearMonthDays.length;
        if (yearMonthDays == null || l < 2) {
            throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
        }
        YearMonthDay start = yearMonthDays[0];
        YearMonthDay end = yearMonthDays[1];
        this.setPeriodInterval(IntervalTools.getInterval(start, end));
        if (l > 2) {
            YearMonthDay[] nextYearMonthDays = new YearMonthDay[l - 2];
            System.arraycopy(yearMonthDays, 2, nextYearMonthDays, 0, l - 2);
            new OccupationPeriod(this, nextYearMonthDays);
        }
        this.setPreviousPeriod(previous);
    }

    public void setNextPeriodWithoutChecks(OccupationPeriod nextPeriod) {
        if (nextPeriod != null && !nextPeriod.getPeriodInterval().isAfter((ReadableInterval)this.getPeriodInterval())) {
            throw new DomainException("error.occupationPeriod.invalid.nextPeriod", new String[0]);
        }
        super.setNextPeriod(nextPeriod);
    }

    public void setPreviousPeriodWithoutChecks(OccupationPeriod previousPeriod) {
        if (previousPeriod != null && !previousPeriod.getPeriodInterval().isBefore((ReadableInterval)this.getPeriodInterval())) {
            throw new DomainException("error.occupationPeriod.invalid.previousPeriod", new String[0]);
        }
        super.setPreviousPeriod(previousPeriod);
    }

    public void setNextPeriod(OccupationPeriod nextPeriod) {
        if (!this.allNestedPeriodsAreEmpty()) {
            throw new DomainException("error.occupationPeriod.previous.periods.not.empty", new String[0]);
        }
        this.setNextPeriodWithoutChecks(nextPeriod);
    }

    public void setPreviousPeriod(OccupationPeriod previousPeriod) {
        if (!this.allNestedPeriodsAreEmpty()) {
            throw new DomainException("error.occupationPeriod.next.periods.not.empty", new String[0]);
        }
        this.setPreviousPeriodWithoutChecks(previousPeriod);
    }

    public Calendar getStartDate() {
        if (this.getStart() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getStart());
            return result;
        }
        return null;
    }

    public Calendar getEndDate() {
        if (this.getEnd() != null) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getEnd());
            return result;
        }
        return null;
    }

    @Deprecated
    public Date getStart() {
        return this.getPeriodInterval().getStart().toDate();
    }

    @Deprecated
    public Date getEnd() {
        return this.getPeriodInterval().getEnd().toDate();
    }

    public Calendar getEndDateOfComposite() {
        Calendar end = this.getEndDate();
        for (OccupationPeriod period = this.getNextPeriod(); period != null; period = period.getNextPeriod()) {
            end = period.getEndDate();
        }
        return end;
    }

    private boolean intersectPeriods(YearMonthDay start, YearMonthDay end) {
        return !this.getStartYearMonthDay().isAfter((ReadablePartial)end) && !this.getEndYearMonthDay().isBefore((ReadablePartial)start);
    }

    private boolean containsDay(YearMonthDay day) {
        return this.getPeriodInterval().contains((ReadableInstant)day.toDateTimeAtMidnight());
    }

    public void delete() {
        if (this.allNestedPeriodsAreEmpty()) {
            OccupationPeriod first = this.getFirstOccupationPeriodOfNestedPeriods();
            first.deleteAllNestedPeriods();
        }
    }

    private void deleteAllNestedPeriods() {
        OccupationPeriod nextPeriod = this.getNextPeriod();
        super.setNextPeriod(null);
        super.setPreviousPeriod(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
        if (nextPeriod != null) {
            nextPeriod.delete();
        }
    }

    public boolean allNestedPeriodsAreEmpty() {
        OccupationPeriod firstOccupationPeriod = this.getFirstOccupationPeriodOfNestedPeriods();
        if (!firstOccupationPeriod.isEmpty()) {
            return false;
        }
        while (firstOccupationPeriod.getNextPeriod() != null) {
            if (!firstOccupationPeriod.getNextPeriod().isEmpty()) {
                return false;
            }
            firstOccupationPeriod = firstOccupationPeriod.getNextPeriod();
        }
        return true;
    }

    private boolean isEmpty() {
        return this.getLessonsSet().isEmpty() && this.getExecutionDegreesSet().isEmpty();
    }

    public OccupationPeriod getLastOccupationPeriodOfNestedPeriods() {
        OccupationPeriod occupationPeriod = this;
        while (occupationPeriod.getNextPeriod() != null) {
            occupationPeriod = occupationPeriod.getNextPeriod();
        }
        return occupationPeriod;
    }

    private OccupationPeriod getFirstOccupationPeriodOfNestedPeriods() {
        OccupationPeriod occupationPeriod = this;
        while (occupationPeriod.getPreviousPeriod() != null) {
            occupationPeriod = occupationPeriod.getPreviousPeriod();
        }
        return occupationPeriod;
    }

    public static OccupationPeriod createOccupationPeriodForLesson(ExecutionCourse executionCourse, YearMonthDay beginDate, YearMonthDay endDate) {
        OccupationPeriod result = null;
        boolean ok = true;
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = curricularCourse.getDegreeCurricularPlan();
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionCourse.getExecutionYear() != executionDegree.getExecutionYear()) continue;
                OccupationPeriod occupationPeriod = executionDegree.getPeriodLessons(executionCourse.getExecutionPeriod());
                if (result == null) {
                    result = occupationPeriod;
                    continue;
                }
                if (result.isEqualTo(occupationPeriod)) continue;
                ok = false;
            }
        }
        if (ok && result != null) {
            if (result.getStartYearMonthDay().equals((Object)beginDate) && result.getEndYearMonthDayWithNextPeriods().equals((Object)endDate)) {
                return result;
            }
            return OccupationPeriod.createNewPeriodWithExclusions(beginDate, endDate, result);
        }
        for (OccupationPeriod occupationPeriod : Bennu.getInstance().getOccupationPeriodsSet()) {
            if (occupationPeriod.getNextPeriod() != null || occupationPeriod.getPreviousPeriod() != null || !occupationPeriod.getStartYearMonthDay().equals((Object)beginDate) || !occupationPeriod.getEndYearMonthDay().equals((Object)endDate)) continue;
            return occupationPeriod;
        }
        return new OccupationPeriod(beginDate, endDate);
    }

    private static OccupationPeriod createNewPeriodWithExclusions(YearMonthDay beginDate, YearMonthDay endDate, OccupationPeriod result) {
        TreeSet<YearMonthDay> dates = new TreeSet<YearMonthDay>();
        dates.add(beginDate);
        dates.add(endDate);
        OccupationPeriod pop = result;
        for (OccupationPeriod nop = result.getNextPeriod(); nop != null; nop = nop.getNextPeriod()) {
            if (pop.getEndYearMonthDay().isAfter((ReadablePartial)beginDate) && pop.getEndYearMonthDay().isBefore((ReadablePartial)endDate)) {
                dates.add(pop.getEndYearMonthDay());
            }
            if (nop.getStartYearMonthDay().isAfter((ReadablePartial)beginDate) && nop.getStartYearMonthDay().isBefore((ReadablePartial)endDate)) {
                dates.add(nop.getStartYearMonthDay());
            }
            pop = nop;
        }
        return new OccupationPeriod(dates.toArray(new YearMonthDay[0]));
    }

    public boolean nestedOccupationPeriodsIntersectDates(YearMonthDay start, YearMonthDay end) {
        for (OccupationPeriod firstOccupationPeriod = this; firstOccupationPeriod != null; firstOccupationPeriod = firstOccupationPeriod.getNextPeriod()) {
            if (!firstOccupationPeriod.intersectPeriods(start, end)) continue;
            return true;
        }
        return false;
    }

    public boolean nestedOccupationPeriodsContainsDay(YearMonthDay day) {
        for (OccupationPeriod firstOccupationPeriod = this; firstOccupationPeriod != null; firstOccupationPeriod = firstOccupationPeriod.getNextPeriod()) {
            if (!firstOccupationPeriod.containsDay(day)) continue;
            return true;
        }
        return false;
    }

    public boolean isGreater(OccupationPeriod period) {
        return this.getPeriodInterval().toDuration().isLongerThan((ReadableDuration)period.getPeriodInterval().toDuration());
    }

    public boolean isEqualTo(OccupationPeriod period) {
        if (this.getNextPeriod() != null && period.getNextPeriod() != null) {
            return this.isEqualTo(period.getStartYearMonthDay(), period.getEndYearMonthDay(), period.getNextPeriod().getStartYearMonthDay(), period.getNextPeriod().getEndYearMonthDay());
        }
        return this.getPeriodInterval().equals((Object)period.getPeriodInterval());
    }

    public boolean isEqualTo(YearMonthDay start, YearMonthDay end, YearMonthDay startPart2, YearMonthDay endPart2) {
        boolean eqStart = this.getStartYearMonthDay().equals((Object)start);
        boolean eqEnd = this.getEndYearMonthDay().equals((Object)end);
        boolean eqNextPeriod = this.getNextPeriod() != null ? this.getNextPeriod().getStartYearMonthDay().equals((Object)startPart2) && this.getNextPeriod().getEndYearMonthDay().equals((Object)endPart2) : true;
        return eqStart && eqEnd && eqNextPeriod;
    }

    public YearMonthDay getEndYearMonthDayWithNextPeriods() {
        return this.getNextPeriod() != null ? this.getNextPeriod().getEndYearMonthDayWithNextPeriods() : this.getEndYearMonthDay();
    }

    public String asString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return String.format("[%s,%s]", sdf.format(this.getStartDate().getTime()), sdf.format(this.getEndDate().getTime()));
    }

    public Interval getIntervalWithNextPeriods() {
        return new Interval((ReadableInstant)this.getStartYearMonthDay().toLocalDate().toDateTimeAtStartOfDay(), (ReadableInstant)this.getEndYearMonthDayWithNextPeriods().toLocalDate().toDateTimeAtStartOfDay());
    }

    @Deprecated
    public YearMonthDay getStartYearMonthDay() {
        Interval interval = this.getPeriodInterval();
        return IntervalTools.getStartYMD(interval);
    }

    @Deprecated
    public YearMonthDay getEndYearMonthDay() {
        Interval interval = this.getPeriodInterval();
        return IntervalTools.getEndYMD(interval);
    }

    public List<Interval> getIntervals() {
        LinkedList<Interval> intervals = new LinkedList<Interval>();
        for (OccupationPeriod period = this; period != null; period = period.getNextPeriod()) {
            intervals.add(period.getPeriodInterval());
        }
        return intervals;
    }

    public void editDates(Iterator<Interval> intervals) {
        this.setPeriodInterval(intervals.next());
        if (!intervals.hasNext()) {
            this.setNextPeriodWithoutChecks(null);
        } else if (this.getNextPeriod() != null) {
            this.getNextPeriod().editDates(intervals);
        } else {
            this.setNextPeriodWithoutChecks(new OccupationPeriod(intervals));
        }
    }

    public void setPeriodInterval(Interval periodInterval) {
        if (periodInterval != null) {
            if (this.getPreviousPeriod() != null && !this.getPreviousPeriod().getPeriodInterval().isBefore((ReadableInterval)periodInterval)) {
                throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
            }
            if (this.getNextPeriod() != null && !this.getNextPeriod().getPeriodInterval().isAfter((ReadableInterval)periodInterval)) {
                throw new DomainException("error.occupationPeriod.invalid.dates", new String[0]);
            }
        }
        super.setPeriodInterval(periodInterval);
    }
}

