/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collections;
import java.util.Date;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GratuityValues_Base;
import org.fenixedu.academic.domain.PaymentPhase;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class GratuityValues
extends GratuityValues_Base {
    public GratuityValues() {
        this.setRootDomainObject(Bennu.getInstance());
        super.setPenaltyApplicable(Boolean.valueOf(true));
    }

    public void delete() {
        this.setExecutionDegree(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public Double calculateTotalValueForMasterDegree() {
        Double totalValue = 0.0;
        Double annualValue = this.getAnualValue();
        totalValue = annualValue != null && annualValue > 0.0 ? annualValue : Double.valueOf(this.getScholarShipValue() + (this.getFinalProofValue() == null ? 0.0 : this.getFinalProofValue()));
        return totalValue;
    }

    public Double calculateTotalValueForSpecialization(StudentCurricularPlan studentCurricularPlan) {
        ExecutionYear executionYear = this.getExecutionDegree().getExecutionYear();
        Double totalValue = 0.0;
        if (this.getCourseValue() != null && this.getCourseValue() > 0.0) {
            double valuePerCourse = this.getCourseValue();
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (!enrolment.getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
                totalValue = totalValue + valuePerCourse;
            }
        } else if (this.getCreditValue() != null && this.getCreditValue() > 0.0) {
            double valuePerCredit = this.getCreditValue();
            double totalCredits = 0.0;
            for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
                if (!enrolment.getExecutionPeriod().getExecutionYear().equals(executionYear)) continue;
                totalCredits += enrolment.getCurricularCourse().getCredits().doubleValue();
            }
            totalValue = totalCredits * valuePerCredit;
        }
        return totalValue;
    }

    public PaymentPhase getLastPaymentPhase() {
        return !this.getPaymentPhaseListSet().isEmpty() ? Collections.max(this.getPaymentPhaseListSet(), PaymentPhase.COMPARATOR_BY_END_DATE) : null;
    }

    public boolean isPenaltyApplicable() {
        return this.getPenaltyApplicable();
    }

    @Deprecated
    public Date getEndPayment() {
        YearMonthDay ymd = this.getEndPaymentYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEndPayment(Date date) {
        if (date == null) {
            this.setEndPaymentYearMonthDay(null);
        } else {
            this.setEndPaymentYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getStartPayment() {
        YearMonthDay ymd = this.getStartPaymentYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setStartPayment(Date date) {
        if (date == null) {
            this.setStartPaymentYearMonthDay(null);
        } else {
            this.setStartPaymentYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getWhen() {
        DateTime dt = this.getWhenDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setWhen(Date date) {
        if (date == null) {
            this.setWhenDateTime(null);
        } else {
            this.setWhenDateTime(new DateTime(date.getTime()));
        }
    }
}

