/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses_Base;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class EnrolmentPeriodInCurricularCourses
extends EnrolmentPeriodInCurricularCourses_Base {
    public static final Comparator<EnrolmentPeriodInCurricularCourses> COMPARATOR_BY_START = new Comparator<EnrolmentPeriodInCurricularCourses>(){

        @Override
        public int compare(EnrolmentPeriodInCurricularCourses o1, EnrolmentPeriodInCurricularCourses o2) {
            return o1.getStartDateDateTime().compareTo((ReadableInstant)o2.getStartDateDateTime());
        }
    };

    public EnrolmentPeriodInCurricularCourses(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, Date startDate, Date endDate) {
        this.init(degreeCurricularPlan, executionSemester, startDate, endDate);
    }

    public EnrolmentPeriodInCurricularCourses(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, DateTime startDate, DateTime endDate) {
        this.checkParameters(degreeCurricularPlan, executionSemester);
        this.init(degreeCurricularPlan, executionSemester, startDate, endDate);
    }

    public boolean isForCurricularCourses() {
        return true;
    }

    private void checkParameters(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
        String[] args = new String[]{};
        if (degreeCurricularPlan == null) {
            throw new DomainException("error.EnrolmentPeriodInCurricularCourses.invalid.degreeCurricularPlan", args);
        }
        String[] args1 = new String[]{};
        if (executionSemester == null) {
            throw new DomainException("error.EnrolmentPeriodInCurricularCourses.invalid.executionSemester", args1);
        }
        if (executionSemester.getEnrolmentPeriod(((Object)((Object)this)).getClass(), degreeCurricularPlan) != null) {
            throw new DomainException("error.EnrolmentPeriodInCurricularCourses.dcp.already.has.enrolment.period.for.semester", new String[0]);
        }
    }
}

