/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.residenceManagement;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.dto.residenceManagement.ResidenceRoleManagementBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.residenceManagement.ResidenceManagerApplication;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=ResidenceManagerApplication.class, path="role-management", titleKey="title.role.management")
@Mapping(path="/residenceRoleManagement", module="residenceManagement")
@Forwards(value={@Forward(name="residenceRoleManagement", path="/residenceManagement/residenceRoleManagement.jsp")})
public class ResidenceRoleManagementDA
extends FenixDispatchAction {
    public ActionForward addResidenceRoleManagemenToPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynamicGroup group = this.getResidenceRoleManagement();
        group.mutator().changeGroup(group.underlyingGroup().grant(this.getResidenceRoleManagementBean().getPerson().getUser()));
        return this.residencePersonsManagement(mapping, actionForm, request, response);
    }

    public ActionForward removeResidenceRoleManagemenToPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = User.findByUsername((String)request.getParameter("userToRemove"));
        DynamicGroup group = this.getResidenceRoleManagement();
        group.mutator().changeGroup(group.underlyingGroup().revoke(user));
        return this.residencePersonsManagement(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward residencePersonsManagement(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynamicGroup role = this.getResidenceRoleManagement();
        request.setAttribute("role", (Object)role);
        request.setAttribute("residenceRoleManagement", (Object)this.getResidenceRoleManagementBean());
        return mapping.findForward("residenceRoleManagement");
    }

    private DynamicGroup getResidenceRoleManagement() {
        return (DynamicGroup)RoleType.RESIDENCE_MANAGER.actualGroup();
    }

    private ResidenceRoleManagementBean getResidenceRoleManagementBean() {
        ResidenceRoleManagementBean residenceRoleManagementBean = (ResidenceRoleManagementBean)this.getRenderedObject();
        if (residenceRoleManagementBean == null) {
            return new ResidenceRoleManagementBean();
        }
        return residenceRoleManagementBean;
    }
}

