/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.candidacies.over23;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.ui.struts.action.publico.candidacies.RefactoredIndividualCandidacyProcessPublicDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StrutsFunctionality(app=PublicApplication.PublicCandidaciesApp.class, path="over-23", titleKey="title.application.name.over23")
@Mapping(path="/candidacies/caseHandlingOver23IndividualCandidacyProcess", module="publico")
@Forwards(value={@Forward(name="begin-candidacy-process-intro", path="/publico/candidacy/over23/main.jsp"), @Forward(name="open-candidacy-process-closed", path="/publico/candidacy/candidacyProcessClosed.jsp"), @Forward(name="show-pre-creation-candidacy-form", path="/publico/candidacy/preCreationCandidacyForm.jsp"), @Forward(name="show-email-message-sent", path="/publico/candidacy/showEmailSent.jsp"), @Forward(name="show-application-submission-conditions", path="/publico/candidacy/applicationSubmissionConditions.jsp"), @Forward(name="open-candidacy-processes-not-found", path="/publico/candidacy/individualCandidacyNotFound.jsp"), @Forward(name="show-candidacy-creation-page", path="/publico/candidacy/over23/createCandidacyPartOne.jsp"), @Forward(name="candidacy-continue-creation", path="/publico/candidacy/over23/createCandidacyPartTwo.jsp"), @Forward(name="inform-submited-candidacy", path="/publico/candidacy/candidacySubmited.jsp"), @Forward(name="show-candidacy-details", path="/publico/candidacy/over23/viewCandidacy.jsp"), @Forward(name="edit-candidacy", path="/publico/candidacy/over23/editCandidacy.jsp"), @Forward(name="edit-candidacy-habilitations", path="/publico/candidacy/over23/editCandidacyHabilitations.jsp"), @Forward(name="edit-candidacy-documents", path="/publico/candidacy/over23/editCandidacyDocuments.jsp")})
public class Over23IndividualCandidacyProcessRefactoredDA
extends RefactoredIndividualCandidacyProcessPublicDA {
    private static final Logger logger = LoggerFactory.getLogger(Over23IndividualCandidacyProcessRefactoredDA.class);

    @Override
    protected String getCandidacyInformationLinkDefaultLanguage() {
        String message = this.getStringFromDefaultBundle("link.candidacy.information.default.over23");
        return MessageFormat.format(message, Installation.getInstance().getInstituitionURL());
    }

    @Override
    protected String getCandidacyInformationLinkEnglish() {
        String message = this.getStringFromDefaultBundle("link.candidacy.information.english.over23");
        return MessageFormat.format(message, Installation.getInstance().getInstituitionURL());
    }

    @Override
    protected String getCandidacyNameKey() {
        return "title.application.name.over23";
    }

    @Override
    public ActionForward viewCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Over23IndividualCandidacyProcess individualCandidacyProcess = (Over23IndividualCandidacyProcess)((Object)request.getAttribute("individualCandidacyProcess"));
        Over23IndividualCandidacyProcessBean bean = new Over23IndividualCandidacyProcessBean(individualCandidacyProcess);
        bean.setPersonBean(new PersonBean(individualCandidacyProcess.getPersonalDetails()));
        request.setAttribute("individualCandidacyProcessBean", (Object)bean);
        return mapping.findForward("show-candidacy-details");
    }

    public ActionForward prepareCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
        if (actionForwardError != null) {
            return actionForwardError;
        }
        CandidacyProcess candidacyProcess = this.getCurrentOpenParentProcess();
        String hash = request.getParameter("hash");
        DegreeOfficePublicCandidacyHashCode candidacyHashCode = (DegreeOfficePublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(hash));
        if (candidacyHashCode == null) {
            return mapping.findForward("open-candidacy-processes-not-found");
        }
        if (candidacyHashCode.getIndividualCandidacyProcess() != null && candidacyHashCode.getIndividualCandidacyProcess().getCandidacyProcess() == candidacyProcess) {
            request.setAttribute("individualCandidacyProcess", (Object)candidacyHashCode.getIndividualCandidacyProcess());
            return this.viewCandidacy(mapping, form, request, response);
        }
        if (candidacyHashCode.getIndividualCandidacyProcess() != null && candidacyHashCode.getIndividualCandidacyProcess().getCandidacyProcess() != candidacyProcess) {
            return mapping.findForward("open-candidacy-processes-not-found");
        }
        Over23IndividualCandidacyProcessBean bean = new Over23IndividualCandidacyProcessBean();
        bean.setPersonBean(new PersonBean());
        bean.setCandidacyProcess(candidacyProcess);
        bean.setPublicCandidacyHashCode(candidacyHashCode);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        bean.getPersonBean().setEmail(candidacyHashCode.getEmail());
        return mapping.findForward("show-candidacy-creation-page");
    }

    @Override
    protected void setParentProcess(HttpServletRequest request) {
        super.setParentProcess(request);
        if (request.getAttribute("parentProcess") == null) {
            request.setAttribute("parentProcess", (Object)this.getCurrentOpenParentProcess());
        }
    }

    @Override
    public ActionForward addConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        bean.addConcludedFormationBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward addNonConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        bean.addNonConcludedFormationBean();
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    @Override
    public ActionForward removeConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        Integer index = this.getIntegerFromRequest(request, "removeIndex");
        bean.removeFormationConcludedBean(index);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward removeNonConcludedHabilitationsEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse reponse) {
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        Integer index = this.getIntegerFromRequest(request, "removeIndex");
        bean.removeFormationNonConcludedBean(index);
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward addSelectedDegreesEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Over23IndividualCandidacyProcessBean bean = (Over23IndividualCandidacyProcessBean)this.getIndividualCandidacyProcessBean();
        if (bean.hasDegreeToAdd() && !bean.containsDegree(bean.getDegreeToAdd())) {
            bean.addDegree(bean.getDegreeToAdd());
            bean.setDegreeToAdd(null);
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    public ActionForward removeSelectedDegreesEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Over23IndividualCandidacyProcessBean bean = (Over23IndividualCandidacyProcessBean)this.getIndividualCandidacyProcessBean();
        Integer index = this.getIntegerFromRequest(request, "removeIndex");
        bean.removeDegree(bean.getSelectedDegrees().get(index));
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        this.invalidateDocumentFileRelatedViewStates();
        return this.forwardTo(mapping, request);
    }

    private ActionForward forwardTo(ActionMapping mapping, HttpServletRequest request) {
        if (this.getFromRequest(request, "userAction").equals("createCandidacy")) {
            return mapping.findForward("candidacy-continue-creation");
        }
        if (this.getFromRequest(request, "userAction").equals("editCandidacyQualifications")) {
            return mapping.findForward("edit-candidacy-habilitations");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ActionForward continueCandidacyCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Person person;
        IndividualCandidacyProcessBean bean = this.getIndividualCandidacyProcessBean();
        PersonBean personBean = bean.getPersonBean();
        if (this.existsIndividualCandidacyProcessForDocumentId(request, personBean.getIdDocumentType(), personBean.getDocumentIdNumber())) {
            this.addActionMessage("individualCandidacyMessages", request, "error.candidacy.for.person.already.exists");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        HashSet<Person> persons = new HashSet<Person>(Person.readByDocumentIdNumber(personBean.getDocumentIdNumber()));
        if (persons.size() > 1) {
            this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.person.already.exist");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        Person person2 = person = persons.size() == 1 ? (Person)((Object)persons.iterator().next()) : null;
        if (person != null) {
            if (!this.isPersonStudentAndNumberIsCorrect(person, bean.getPersonNumber())) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.userId");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (!person.getDateOfBirthYearMonthDay().equals((Object)personBean.getDateOfBirth())) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.birth");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            if (!(StringUtils.isEmpty((String)personBean.getSocialSecurityNumber()) || StringUtils.isEmpty((String)person.getSocialSecurityNumber()) || person.getSocialSecurityNumber().equals(personBean.getSocialSecurityNumber()))) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
                return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
            }
            personBean.setPerson(person);
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("candidacy-continue-creation");
        }
        if (Person.readByContributorNumber((String)personBean.getSocialSecurityNumber()) != null) {
            this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        if (!StringUtils.isEmpty((String)bean.getPersonNumber())) {
            this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.userId.missing");
            return this.executeCreateCandidacyPersonalInformationInvalid(mapping, form, request, response);
        }
        request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)bean);
        return mapping.findForward("candidacy-continue-creation");
    }

    public ActionForward submitCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, FenixServiceException {
        try {
            boolean isValid;
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            Over23IndividualCandidacyProcessBean bean = (Over23IndividualCandidacyProcessBean)this.getIndividualCandidacyProcessBean();
            bean.setInternalPersonCandidacy(Boolean.TRUE);
            boolean bl = isValid = this.validateOver23IndividualCandidacy(request, bean) && this.hasInvalidViewState();
            if (!isValid) {
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            if (this.candidacyIndividualProcessExistsForThisEmail(bean.getPersonBean().getEmail(), bean.getSelectedDegrees())) {
                this.addActionMessage("error", request, "error.candidacy.hash.code.already.bounded");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            if (!bean.getHonorAgreement().booleanValue()) {
                this.addActionMessage("error", request, "error.must.agree.on.declaration.of.honor");
                this.invalidateDocumentFileRelatedViewStates();
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("candidacy-continue-creation");
            }
            Over23IndividualCandidacyProcess process2 = (Over23IndividualCandidacyProcess)((Object)this.createNewPublicProcess(bean));
            request.setAttribute("process", (Object)process2);
            request.setAttribute("mappingPath", (Object)mapping.getPath());
            request.setAttribute("individualCandidacyProcess", (Object)process2);
            request.setAttribute("endSubmissionDate", (Object)this.getFormattedApplicationSubmissionEndDate());
            return mapping.findForward("inform-submited-candidacy");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            logger.error(e.getMessage(), (Throwable)((Object)e));
            this.getIndividualCandidacyProcessBean().getPersonBean().setPerson(null);
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("candidacy-continue-creation");
        }
    }

    private boolean validateOver23IndividualCandidacy(HttpServletRequest request, Over23IndividualCandidacyProcessBean bean) {
        boolean isValid = true;
        if (bean.getSelectedDegrees().isEmpty()) {
            this.addActionMessage("error", request, "error.formation.selectedDegrees.required");
            isValid = false;
        }
        if (bean.getFormationConcludedBeanList().isEmpty() && bean.getFormationNonConcludedBeanList().isEmpty()) {
            this.addActionMessage("error", request, "error.formation.required");
            return false;
        }
        return isValid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward editCandidacyProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Over23IndividualCandidacyProcessBean bean = (Over23IndividualCandidacyProcessBean)this.getIndividualCandidacyProcessBean();
        PersonBean personBean = bean.getPersonBean();
        try {
            Person person;
            ActionForward actionForwardError = this.verifySubmissionPreconditions(mapping);
            if (actionForwardError != null) {
                return actionForwardError;
            }
            if (!this.isApplicationSubmissionPeriodValid()) {
                return this.beginCandidacyProcessIntro(mapping, form, request, response);
            }
            HashSet<Person> persons = new HashSet<Person>(Person.readByDocumentIdNumber(personBean.getDocumentIdNumber()));
            if (persons.size() > 1) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.person.already.exist");
                return this.prepareEditCandidacyProcess(mapping, form, request, response);
            }
            Person person2 = person = persons.size() == 1 ? (Person)((Object)persons.iterator().next()) : null;
            if (person != null) {
                if (!this.isPersonStudentAndNumberIsCorrect(person, bean.getPersonNumber())) {
                    this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.userId");
                    return this.prepareEditCandidacyProcess(mapping, form, request, response);
                }
                if (!person.getDateOfBirthYearMonthDay().equals((Object)personBean.getDateOfBirth())) {
                    this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.birth");
                    return this.prepareEditCandidacyProcess(mapping, form, request, response);
                }
                if (!(StringUtils.isEmpty((String)personBean.getSocialSecurityNumber()) || StringUtils.isEmpty((String)person.getSocialSecurityNumber()) || person.getSocialSecurityNumber().equals(personBean.getSocialSecurityNumber()))) {
                    this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
                    return this.prepareEditCandidacyProcess(mapping, form, request, response);
                }
                personBean.setPerson(person);
            } else if (Person.readByContributorNumber((String)personBean.getSocialSecurityNumber()) != null) {
                this.addActionMessage("individualCandidacyMessages", request, this.getProcessType().getSimpleName() + ".error.public.candidacies.fill.personal.information.and.institution.id.contributorNumber");
                return this.prepareEditCandidacyProcess(mapping, form, request, response);
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyPersonalInformation", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    public ActionForward editCandidacyHabilitations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Over23IndividualCandidacyProcessBean bean = (Over23IndividualCandidacyProcessBean)this.getIndividualCandidacyProcessBean();
        try {
            boolean isValid;
            boolean bl = isValid = this.validateOver23IndividualCandidacy(request, bean) && this.hasInvalidViewState();
            if (!isValid) {
                request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
                return mapping.findForward("edit-candidacy-habilitations");
            }
            if (!this.isApplicationSubmissionPeriodValid()) {
                return this.beginCandidacyProcessIntro(mapping, form, request, response);
            }
            this.executeActivity((Process)((Object)bean.getIndividualCandidacyProcess()), "EditPublicCandidacyHabilitations", this.getIndividualCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            request.setAttribute(this.getIndividualCandidacyProcessBeanName(), (Object)this.getIndividualCandidacyProcessBean());
            return mapping.findForward("edit-candidacy-habilitations");
        }
        request.setAttribute("individualCandidacyProcess", (Object)bean.getIndividualCandidacyProcess());
        return this.backToViewCandidacyInternal(mapping, form, request, response);
    }

    protected Class getParentProcessType() {
        return Over23CandidacyProcess.class;
    }

    @Override
    protected Class getProcessType() {
        return Over23IndividualCandidacyProcess.class;
    }
}

