/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.publicProgram;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.academicAdminOffice.PhdProgramCandidacyProcessDA;

public abstract class PublicPhdProgramCandidacyProcessDA
extends PhdProgramCandidacyProcessDA {
    private static final String SIBS_ENTITY_CODE = FenixEduAcademicConfiguration.getConfiguration().getSibsEntityCode();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        request.setAttribute("sibsEntityCode", (Object)SIBS_ENTITY_CODE);
        request.setAttribute("dont-cache-pages-in-search-engines", (Object)Boolean.TRUE);
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (bean != null && bean.hasCandidacyHashCode()) {
            this.canEditCandidacy(request, bean.getCandidacyHashCode());
        }
        if ((forward = this.filterDispatchMethod(bean, mapping, actionForm, request, response)) != null) {
            return forward;
        }
        return super.execute(mapping, actionForm, request, response);
    }

    protected abstract ActionForward filterDispatchMethod(PhdProgramCandidacyProcessBean var1, ActionMapping var2, ActionForm var3, HttpServletRequest var4, HttpServletResponse var5) throws Exception;

    protected PhdProgramCandidacyProcessBean getCandidacyBean() {
        return (PhdProgramCandidacyProcessBean)this.getRenderedObject("candidacyBean");
    }

    protected void canEditCandidacy(HttpServletRequest request, PhdProgramPublicCandidacyHashCode hashCode) {
        request.setAttribute("canEditCandidacy", (Object)(!this.isValidatedByCandidate(hashCode) ? 1 : 0));
    }

    protected boolean isValidatedByCandidate(PhdProgramPublicCandidacyHashCode hashCode) {
        return hashCode.getPhdProgramCandidacyProcess() != null && hashCode.getIndividualProgramProcess().isValidatedByCandidate();
    }

    protected void canEditPersonalInformation(HttpServletRequest request, Person person) {
        if (person.getUser() != null || person.getStudent() != null) {
            request.setAttribute("canEditPersonalInformation", (Object)false);
            this.addWarningMessage(request, "message.existing.person.data.must.be.updated.in.academic.office", new String[0]);
        } else {
            request.setAttribute("canEditPersonalInformation", (Object)true);
        }
    }

    protected void addValidationMessage(HttpServletRequest request, String key, String ... args) {
        this.addActionMessage("validation", request, key, args);
    }

    public abstract ActionForward fillPersonalDataInvalid(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4);

    /*
     * Enabled aggressive block sorting
     */
    protected ActionForward checkPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Person person;
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PersonBean personBean = bean.getPersonBean();
        Collection<Person> personsFoundByDocumentId = Person.readByDocumentIdNumber(personBean.getDocumentIdNumber());
        if (personsFoundByDocumentId.size() > 1) {
            this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.more.than.one", new String[0]);
            return this.fillPersonalDataInvalid(mapping, form, request, response);
        }
        Person person2 = person = !personsFoundByDocumentId.isEmpty() ? personsFoundByDocumentId.iterator().next() : null;
        if (!StringUtils.isEmpty((String)personBean.getFiscalCode())) {
            Party partyFoundBySocialSecurityNumber = PartySocialSecurityNumber.readPartyBySocialSecurityNumber(personBean.getFiscalCode());
            if ((person != null || partyFoundBySocialSecurityNumber != null) && person != partyFoundBySocialSecurityNumber) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.different.ssn", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
        }
        if (bean.hasInstitutionId()) {
            Person personByIstId = Person.readPersonByUsername(bean.getInstitutionId());
            if (personByIstId == null) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.noIstIdPerson", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
            if (person != null && person != personByIstId) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.different.istId", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
        }
        if (person != null) {
            if (!person.getDateOfBirthYearMonthDay().equals((Object)personBean.getDateOfBirth())) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.different.birthday", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
            if (person.getUsername() != null && person.getUsername().equals(bean.getInstitutionId())) {
                personBean.setPerson(person);
            } else if (person.getUsername() == null && !bean.hasInstitutionId()) {
                personBean.setPerson(person);
            } else {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id.different.istIds", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
            if (PhdProgramCandidacyProcess.hasOnlineApplicationForPeriod(person, bean.getPhdCandidacyPeriod())) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.alreadyHasApplication", new String[0]);
                return this.fillPersonalDataInvalid(mapping, form, request, response);
            }
        }
        return null;
    }
}

