/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalSupervision.consult;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.interfaces.HasDegreeType;
import org.fenixedu.academic.domain.interfaces.HasExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;

public class ExternalSupervisorViewsBean
implements Serializable,
HasExecutionYear,
HasDegreeType {
    private Person student;
    private ExecutionDegree executionDegree;
    private DegreeType degreeType;
    private ExecutionYear executionYear;
    private List<Person> students;
    private RegistrationProtocol protocol;
    private Boolean megavisor = false;

    public ExternalSupervisorViewsBean() {
    }

    public ExternalSupervisorViewsBean(RegistrationProtocol protocol) {
        this();
        this.protocol = protocol;
    }

    public ExternalSupervisorViewsBean(ExecutionYear executionYear) {
        this();
        this.executionYear = executionYear;
    }

    public ExternalSupervisorViewsBean(Person student) {
        this();
        this.student = student;
    }

    public ExternalSupervisorViewsBean(Person student, RegistrationProtocol protocol) {
        this();
        this.student = student;
        this.protocol = protocol;
    }

    public ExternalSupervisorViewsBean(ExecutionYear executionYear, RegistrationProtocol protocol) {
        this();
        this.executionYear = executionYear;
        this.protocol = protocol;
    }

    public Person getStudent() {
        return this.student;
    }

    public void setStudent(Person student) {
        this.student = student;
    }

    public ExecutionDegree getExecutionDegree() {
        return this.executionDegree;
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegree = executionDegree;
    }

    @Override
    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    @Override
    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public List<Person> getStudents() {
        return this.students;
    }

    public void setStudents(List<Person> students) {
        this.students = students;
    }

    public RegistrationProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(RegistrationProtocol protocol) {
        this.protocol = protocol;
    }

    public Boolean getMegavisor() {
        return this.megavisor;
    }

    public void setMegavisor(Boolean megavisor) {
        this.megavisor = megavisor;
    }

    public void generateStudentsFromYear() {
        Set theWholeSet = this.protocol.getRegistrationsSet();
        this.students = new ArrayList<Person>();
        for (Registration iterator : theWholeSet) {
            if (!iterator.hasAnyActiveState(this.executionYear)) continue;
            this.students.add(iterator.getPerson());
        }
        Collections.sort(this.students, DomainObjectUtil.COMPARATOR_BY_ID);
    }

    public void generateStudentsFromDegree() {
        Set theWholeSet = this.protocol.getRegistrationsSet();
        this.students = new ArrayList<Person>();
        for (Registration iterator : theWholeSet) {
            if (!iterator.hasAnyActiveState(this.executionYear) || iterator.getLastDegreeCurricularPlan() != this.executionDegree.getDegreeCurricularPlan()) continue;
            this.students.add(iterator.getPerson());
        }
        Collections.sort(this.students, DomainObjectUtil.COMPARATOR_BY_ID);
    }

    public boolean supervisorHasPermission() {
        Set<Registration> allRegistrations = this.student.getStudent().getRegistrationsSet();
        for (Registration iterator : allRegistrations) {
            if (iterator.getRegistrationProtocol() != this.protocol) continue;
            return true;
        }
        return false;
    }

    public boolean supervisorHasPermission(boolean isOmnipotent, Set<RegistrationProtocol> jurisdictions) {
        if (isOmnipotent) {
            Set<Registration> allRegistrations = this.student.getStudent().getRegistrationsSet();
            for (Registration regIter : allRegistrations) {
                for (RegistrationProtocol protIter : jurisdictions) {
                    if (regIter.getRegistrationProtocol() != protIter) continue;
                    return true;
                }
            }
            return false;
        }
        return this.supervisorHasPermission();
    }

    public boolean noCurriculum() {
        if (this.student.getStudent().getLastActiveRegistration() != null) {
            return false;
        }
        Set<Registration> registrations = this.student.getStudent().getRegistrationsSet();
        for (Registration iterator : registrations) {
            if (iterator.getNumberOfCurriculumEntries() <= 0) continue;
            return false;
        }
        return true;
    }

    public List<StudentCurricularPlan> generateAllStudentCurricularPlans() {
        ArrayList<StudentCurricularPlan> curricularPlans = new ArrayList<StudentCurricularPlan>();
        for (Person person : this.students) {
            for (Registration registration : person.getStudent().getRegistrationsSet()) {
                if (registration.getRegistrationProtocol() != this.protocol || !registration.hasAnyActiveState(this.executionYear) || this.executionDegree != null && registration.getDegree() != this.executionDegree.getDegree()) continue;
                for (StudentCurricularPlan curricularPlan : registration.getStudentCurricularPlansSet()) {
                    curricularPlans.add(curricularPlan);
                }
            }
        }
        Collections.sort(curricularPlans, StudentCurricularPlan.DATE_COMPARATOR);
        return curricularPlans;
    }
}

