/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.departmentMember;

import java.io.Serializable;
import java.util.List;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.department.CompetenceCourseStatisticsDTO;
import org.fenixedu.academic.dto.department.DegreeCourseStatisticsDTO;
import org.fenixedu.academic.dto.department.ExecutionCourseStatisticsDTO;
import org.fenixedu.academic.service.services.department.ComputeCompetenceCourseStatistics;
import org.fenixedu.academic.service.services.department.ComputeDegreeCourseStatistics;
import org.fenixedu.academic.service.services.department.ComputeExecutionCourseStatistics;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;

public class CourseStatisticsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Department department;
    private CompetenceCourse competenceCourse = null;
    private Degree degree = null;
    private ExecutionSemester executionSemester = null;
    private List<DegreeCourseStatisticsDTO> degreeCourses = null;
    private List<ExecutionCourseStatisticsDTO> executionCourses = null;
    private List<CompetenceCourseStatisticsDTO> competenceCourses = null;

    public CourseStatisticsBean(Department department, ExecutionSemester executionSemester) {
        this.department = department;
        this.executionSemester = executionSemester;
    }

    public CourseStatisticsBean(Department department, CompetenceCourse competenceCourse, ExecutionSemester executionSemester) {
        this.department = department;
        this.competenceCourse = competenceCourse;
        this.executionSemester = executionSemester;
    }

    public CourseStatisticsBean(Department department, CompetenceCourse competenceCourse, Degree degree, ExecutionSemester executionSemester) {
        this.department = department;
        this.degree = degree;
        this.competenceCourse = competenceCourse;
        this.executionSemester = executionSemester;
    }

    public ExecutionSemester getExecutionSemester() {
        if (this.executionSemester == null) {
            this.executionSemester = ExecutionSemester.readActualExecutionSemester();
        }
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) throws FenixServiceException {
        this.executionSemester = executionSemester;
    }

    private void loadCompetenceCourses() throws FenixServiceException {
        this.competenceCourses = ComputeCompetenceCourseStatistics.runComputeCompetenceCourseStatistics(this.department, this.getExecutionSemester());
    }

    public List<CompetenceCourseStatisticsDTO> getCompetenceCourses() throws FenixServiceException {
        if (this.competenceCourses == null) {
            this.loadCompetenceCourses();
        }
        return this.competenceCourses;
    }

    private void loadDegreeCourses() throws FenixServiceException {
        this.degreeCourses = ComputeDegreeCourseStatistics.runComputeDegreeCourseStatistics(this.competenceCourse, this.getExecutionSemester());
    }

    public List<DegreeCourseStatisticsDTO> getDegreeCourses() throws FenixServiceException {
        if (this.degreeCourses == null) {
            this.loadDegreeCourses();
        }
        return this.degreeCourses;
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    public Degree getDegree() {
        return this.degree;
    }

    private void loadExecutionCourses() throws FenixServiceException {
        this.executionCourses = ComputeExecutionCourseStatistics.runComputeExecutionCourseStatistics(this.getCompetenceCourse(), this.getDegree(), this.getExecutionSemester());
    }

    public List<ExecutionCourseStatisticsDTO> getExecutionCourses() throws FenixServiceException {
        if (this.executionCourses == null) {
            this.loadExecutionCourses();
        }
        return this.executionCourses;
    }

    public Department getDepartment() {
        return this.department;
    }

    public String getCompetenceCourseName() {
        return this.competenceCourse.getNameI18N(this.getExecutionSemester()).getContent();
    }
}

