/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.student.StudentsSearchBean;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.EditCandidacyInformationDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminStudentsApp.class, path="search-for-students", titleKey="link.studentOperations.viewStudents", accessGroup="academic(scope=OFFICE)")
@Mapping(path="/students", module="academicAdministration")
@Forwards(value={@Forward(name="viewStudentDetails", path="/academicAdminOffice/student/viewStudentDetails.jsp"), @Forward(name="search", path="/academicAdminOffice/searchStudents.jsp")})
public class SearchForStudentsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareSearch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentsSearchBean studentsSearchBean = (StudentsSearchBean)this.getRenderedObject();
        if (studentsSearchBean == null) {
            studentsSearchBean = new StudentsSearchBean();
        } else {
            Set<Student> students = studentsSearchBean.search();
            if (students.size() == 1) {
                Student student = students.iterator().next();
                request.setAttribute("student", (Object)student);
                request.setAttribute("choosePhdOrRegistration", (Object)new EditCandidacyInformationDA.ChooseRegistrationOrPhd(student));
                return mapping.findForward("viewStudentDetails");
            }
            request.setAttribute("students", students);
        }
        request.setAttribute("studentsSearchBean", (Object)studentsSearchBean);
        return mapping.findForward("search");
    }
}

