/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.dto.VariantBean;
import org.fenixedu.academic.dto.student.RegistrationStateBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageRegistrationState", module="academicAdministration", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="showRegistrationStates", path="/academicAdminOffice/student/registration/manageRegistrationState.jsp"), @Forward(name="deleteActualInfoConfirm", path="/academicAdminOffice/student/registration/deleteRegistrationActualInfo.jsp"), @Forward(name="viewRegistrationStateLogChanges", path="/academicAdminOffice/student/registration/viewRegistrationLogChanges.jsp")})
public class ManageRegistrationStateDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = this.getAndTransportRegistration(request);
        request.setAttribute("registrationStateBean", (Object)new RegistrationStateCreator(registration));
        return mapping.findForward("showRegistrationStates");
    }

    public ActionForward createNewState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            RegistrationStateCreator creator = (RegistrationStateCreator)this.getFactoryObject();
            creator.setResponsible(AccessControl.getPerson());
            this.executeFactoryMethod(creator);
            this.addActionMessage(request, "message.success.state.edit");
        }
        catch (DomainExceptionWithLabelFormatter e) {
            this.addActionMessage(request, e.getKey(), this.solveLabelFormatterArgs(request, e.getLabelFormatterArgs()));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        Registration registration = ((RegistrationStateBean)this.getRenderedObject()).getRegistration();
        request.setAttribute("registration", (Object)registration);
        request.setAttribute("registrationStateBean", (Object)new RegistrationStateCreator(registration));
        return mapping.findForward("showRegistrationStates");
    }

    public ActionForward deleteState(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod(new RegistrationStateDeleter(request.getParameter("registrationStateId")));
            this.addActionMessage(request, "message.success.state.delete");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
        }
        return this.prepare(mapping, actionForm, request, response);
    }

    private Registration getAndTransportRegistration(HttpServletRequest request) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        request.setAttribute("registration", (Object)registration);
        return registration;
    }

    public ActionForward viewRegistrationStateLog(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        Set logsList = registration.getRegistrationStateLogSet();
        request.setAttribute("registration", (Object)registration);
        request.setAttribute("logsList", (Object)logsList);
        return mapping.findForward("viewRegistrationStateLogChanges");
    }

    public static class RegistrationStateCreator
    extends RegistrationStateBean
    implements FactoryExecutor {
        public RegistrationStateCreator(Registration registration) {
            super(registration);
        }

        private RegistrationStateCreator(Registration reg, Person responsible, DateTime creation, RegistrationStateType stateType) {
            this(reg);
            this.setResponsible(responsible);
            this.setStateDateTime(creation);
            this.setStateType(stateType);
        }

        @Override
        public Object execute() {
            return RegistrationState.createRegistrationState(this);
        }
    }

    public static class RegistrationStateDeleter
    extends VariantBean
    implements FactoryExecutor {
        public RegistrationStateDeleter(String externalId) {
            this.setString(externalId);
        }

        @Override
        public Object execute() {
            ((RegistrationState)FenixFramework.getDomainObject((String)this.getString())).delete();
            return null;
        }
    }
}

