/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.MergeExecutionCourses;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.ReadableInterval;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminExecutionsApp.class, path="merge-execution-courses", titleKey="label.manager.executionCourseManagement.join.executionCourse", accessGroup="academic(MANAGE_EXECUTION_COURSES_ADV)")
@Mapping(module="academicAdministration", path="/chooseDegreesForExecutionCourseMerge", input="/chooseDegreesForExecutionCourseMerge.do?method=prepareChooseDegreesAndExecutionPeriod", formBean="mergeExecutionCoursesForm")
@Forwards(value={@Forward(name="chooseDegreesAndExecutionPeriod", path="/academicAdministration/executionCourseManagement/chooseDegreesForExecutionCourseMerge.jsp"), @Forward(name="chooseExecutionCourses", path="/academicAdministration/executionCourseManagement/chooseExecutionCoursesForExecutionCourseMerge.jsp"), @Forward(name="sucess", path="/academicAdministration/chooseDegreesForExecutionCourseMerge.do?method=prepareChooseDegreesAndExecutionPeriod")})
@Exceptions(value={@ExceptionHandling(type=MergeExecutionCourses.SourceAndDestinationAreTheSameException.class, key="error.cannot.merge.execution.course.with.itself", handler=FenixErrorExceptionHandler.class, scope="request"), @ExceptionHandling(type=MergeExecutionCourses.DuplicateShiftNameException.class, key="error.duplicate.shift.names", handler=FenixErrorExceptionHandler.class, scope="request")})
public class MergeExecutionCourseDA
extends FenixDispatchAction {
    public ActionForward chooseDegreesAndExecutionPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        Boolean previousOrEqualSemester = false;
        DegreesMergeBean degreeBean = (DegreesMergeBean)this.getRenderedObject("degreeBean");
        request.setAttribute("degreeBean", (Object)degreeBean);
        RenderUtils.invalidateViewState();
        AcademicInterval choosedSemester = degreeBean.getAcademicInterval();
        AcademicInterval actualSemester = ExecutionSemester.readActualExecutionSemester().getAcademicInterval();
        previousOrEqualSemester = choosedSemester.isBefore((ReadableInterval)actualSemester) || choosedSemester.isEqualOrEquivalent(actualSemester);
        request.setAttribute("previousOrEqualSemester", (Object)previousOrEqualSemester);
        if (degreeBean.getDestinationDegree().getExecutionCourses(degreeBean.getAcademicInterval()).isEmpty() && degreeBean.getSourceDegree().getExecutionCourses(degreeBean.getAcademicInterval()).isEmpty()) {
            this.addActionMessage("error", request, "message.merge.execution.courses.degreesHasNoCourses");
            return mapping.findForward("chooseDegreesAndExecutionPeriod");
        }
        if (degreeBean.getDestinationDegree().getExecutionCourses(degreeBean.getAcademicInterval()).isEmpty()) {
            this.addActionMessage("error", request, "message.merge.execution.courses.destinationDegreeHasNoCourses");
            return mapping.findForward("chooseDegreesAndExecutionPeriod");
        }
        if (degreeBean.getSourceDegree().getExecutionCourses(degreeBean.getAcademicInterval()).isEmpty()) {
            this.addActionMessage("error", request, "message.merge.execution.courses.sourceDegreeHasNoCourses");
            return mapping.findForward("chooseDegreesAndExecutionPeriod");
        }
        return mapping.findForward("chooseExecutionCourses");
    }

    @EntryPoint
    public ActionForward prepareChooseDegreesAndExecutionPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreesMergeBean degreeBean = new DegreesMergeBean();
        request.setAttribute("degreeBean", (Object)degreeBean);
        return mapping.findForward("chooseDegreesAndExecutionPeriod");
    }

    public ActionForward mergeExecutionCourses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreesMergeBean degreeBean = (DegreesMergeBean)this.getRenderedObject("degreeBean");
        RenderUtils.invalidateViewState();
        ExecutionCourse sourceExecutionCourse = degreeBean.getSourceExecutionCourse();
        ExecutionCourse destinationExecutionCourse = degreeBean.getDestinationExecutionCourse();
        Boolean error = false;
        String sourceName = sourceExecutionCourse.getName() + " [" + sourceExecutionCourse.getDegreePresentationString() + "]";
        String destinationName = destinationExecutionCourse.getName() + " [" + destinationExecutionCourse.getDegreePresentationString() + "]";
        String periodName = destinationExecutionCourse.getExecutionPeriod().getName() + " " + destinationExecutionCourse.getExecutionPeriod().getYear();
        try {
            MergeExecutionCourses.merge(destinationExecutionCourse, sourceExecutionCourse);
        }
        catch (DomainException ex) {
            error = true;
            this.addActionMessage("error", request, ex.getLocalizedMessage());
        }
        catch (FenixServiceException ex) {
            error = true;
            this.addActionMessage("error", request, ex.getLocalizedMessage());
        }
        if (!error.booleanValue()) {
            this.addActionMessage("success", request, "message.merge.execution.courses.success", sourceName, destinationName, periodName);
        }
        return mapping.findForward("sucess");
    }

    public static class DegreesMergeBean
    implements Serializable {
        private static final long serialVersionUID = -5030417665530169855L;
        private Degree sourceDegree;
        private Degree destinationDegree;
        private ExecutionCourse sourceExecutionCourse;
        private ExecutionCourse destinationExecutionCourse;
        private AcademicInterval academicInterval;

        public ExecutionCourse getSourceExecutionCourse() {
            return this.sourceExecutionCourse;
        }

        public void setSourceExecutionCourse(ExecutionCourse sourceExecutionCourse) {
            this.sourceExecutionCourse = sourceExecutionCourse;
        }

        public ExecutionCourse getDestinationExecutionCourse() {
            return this.destinationExecutionCourse;
        }

        public void setDestinationExecutionCourse(ExecutionCourse destinationExecutionCourse) {
            this.destinationExecutionCourse = destinationExecutionCourse;
        }

        public AcademicInterval getAcademicInterval() {
            return this.academicInterval;
        }

        public void setAcademicInterval(AcademicInterval academicInterval) {
            this.academicInterval = academicInterval;
        }

        public Degree getSourceDegree() {
            return this.sourceDegree;
        }

        public void setSourceDegree(Degree sourceDegree) {
            this.sourceDegree = sourceDegree;
        }

        public Degree getDestinationDegree() {
            return this.destinationDegree;
        }

        public void setDestinationDegree(Degree destinationDegree) {
            this.destinationDegree = destinationDegree;
        }
    }
}

