/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.validators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class TextLengthValidator
extends HtmlValidator {
    private static final Logger logger = LoggerFactory.getLogger(TextLengthValidator.class);
    private static final long serialVersionUID = 1L;
    private static final String LENGTH_MESSAGE = "fenix.renderers.length.exceeded";
    private TextType type;
    private Integer length;

    public TextLengthValidator() {
        this.setType("character");
    }

    public TextLengthValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setType("character");
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getType() {
        return this.type.name();
    }

    public void setType(String type) {
        try {
            this.type = TextType.valueOf(type);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void performValidation() {
        String value;
        if (this.isValid() && this.getLength() != null && (value = this.getComponent().getValue()) != null) {
            this.validateLength(value);
        }
    }

    private void validateLength(String value) {
        if (this.getLength() == null) {
            return;
        }
        if (this.getCount(value) > this.getLength()) {
            this.invalidate();
        }
    }

    private int getCount(String value) {
        switch (this.type) {
            case character: {
                return value.length();
            }
            case word: {
                return value.split("\\p{Space}+").length;
            }
        }
        return 0;
    }

    private void invalidate() {
        this.setValid(false);
        this.setMessage("fenix.renderers.length.exceeded." + this.getType());
    }

    protected String getResourceMessage(String message) {
        return RenderUtils.getFormatedResourceString((String)message, (Object[])new Object[]{this.getLength()});
    }

    public static enum TextType {
        character,
        word,
        paragraph;

    }
}

