/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.validators;

import org.apache.commons.lang.StringUtils;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class NumberRangeValidator
extends HtmlValidator {
    private boolean isNumber;
    private Integer upperBound = null;
    private Integer lowerBound = null;

    public NumberRangeValidator() {
    }

    public NumberRangeValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void performValidation() {
        String numberText = this.getComponent().getValue();
        if (!StringUtils.isEmpty((String)numberText)) {
            try {
                int number = Integer.parseInt(numberText.trim());
                boolean inRange = true;
                this.isNumber = true;
                if (this.lowerBound != null) {
                    inRange &= this.lowerBound <= number;
                }
                if (this.upperBound != null) {
                    inRange &= this.upperBound >= number;
                }
                this.setValid(inRange);
            }
            catch (NumberFormatException e) {
                this.isNumber = false;
                this.setValid(false);
            }
        }
    }

    public String getErrorMessage() {
        if (!this.isNumber) {
            return RenderUtils.getResourceString((String)"renderers.validator.number.integer");
        }
        if (this.lowerBound != null && this.upperBound != null) {
            return RenderUtils.getFormatedResourceString((String)"renderers.validator.number.range.both", (Object[])new Object[]{this.lowerBound, this.upperBound});
        }
        if (this.lowerBound != null) {
            return RenderUtils.getFormatedResourceString((String)"renderers.validator.number.range.lower", (Object[])new Object[]{this.lowerBound});
        }
        return RenderUtils.getFormatedResourceString((String)"renderers.validator.number.range.upper", (Object[])new Object[]{this.upperBound});
    }
}

