/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.student.enrollment.bolonha;

import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentOptionalEnrollmentBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlActionLinkController;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class BolonhaStudentOptionalEnrollmentInputRenderer
extends InputRenderer {
    private Integer initialWidth = 70;
    private Integer widthDecreasePerLevel = 3;
    private String tablesClasses = "showinfo3 mvert0";
    private String groupRowClasses = "bgcolor2";
    private String curricularCoursesToEnrol = "smalltxt, smalltxt aright, smalltxt aright, aright";

    public Integer getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialWidth(Integer initialWidth) {
        this.initialWidth = initialWidth;
    }

    public Integer getWidthDecreasePerLevel() {
        return this.widthDecreasePerLevel;
    }

    public void setWidthDecreasePerLevel(Integer widthDecreasePerLevel) {
        this.widthDecreasePerLevel = widthDecreasePerLevel;
    }

    public String getTablesClasses() {
        return this.tablesClasses;
    }

    public void setTablesClasses(String tablesClasses) {
        this.tablesClasses = tablesClasses;
    }

    public String getGroupRowClasses() {
        return this.groupRowClasses;
    }

    public void setGroupRowClasses(String groupRowClasses) {
        this.groupRowClasses = groupRowClasses;
    }

    private String[] getCurricularCourseClasses() {
        return this.curricularCoursesToEnrol.split(",");
    }

    public void setCurricularCourseClasses(String curricularCoursesToEnrol) {
        this.curricularCoursesToEnrol = curricularCoursesToEnrol;
    }

    private String getCurricularCourseNameClasses() {
        return this.getCurricularCourseClasses()[0];
    }

    private String getCurricularCourseYearClasses() {
        return this.getCurricularCourseClasses()[1];
    }

    private String getCurricularCourseEctsClasses() {
        return this.getCurricularCourseClasses()[2];
    }

    private String getCurricularCourseLinkClasses() {
        return this.getCurricularCourseClasses()[3];
    }

    protected Layout getLayout(Object object, Class type) {
        return new BolonhaStudentOptionalEnrolmentLayout();
    }

    private static class UpdateSelectedOptionalCurricularCourseController
    extends HtmlActionLinkController {
        private final CurricularCourse curricularCourse;

        public UpdateSelectedOptionalCurricularCourseController(CurricularCourse curricularCourse) {
            this.curricularCourse = curricularCourse;
        }

        protected boolean isToSkipUpdate() {
            return false;
        }

        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            ((BolonhaStudentOptionalEnrollmentBean)viewState.getMetaObject().getObject()).setSelectedOptionalCurricularCourse(this.curricularCourse);
        }
    }

    private class BolonhaStudentOptionalEnrolmentLayout
    extends Layout {
        private BolonhaStudentOptionalEnrollmentBean bolonhaStudentOptionalEnrollmentBean = null;

        private BolonhaStudentOptionalEnrolmentLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            this.bolonhaStudentOptionalEnrollmentBean = (BolonhaStudentOptionalEnrollmentBean)object;
            if (this.bolonhaStudentOptionalEnrollmentBean == null) {
                return new HtmlText();
            }
            HtmlBlockContainer container = new HtmlBlockContainer();
            this.generateCourseGroup(container, (CourseGroup)((Object)this.bolonhaStudentOptionalEnrollmentBean.getDegreeCurricularPlan().getRoot()), 0);
            return container;
        }

        private void generateCourseGroup(HtmlBlockContainer blockContainer, CourseGroup courseGroup, int depth) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (BolonhaStudentOptionalEnrollmentInputRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getGroupRowClasses());
            htmlTableRow.createCell().setBody((HtmlComponent)new HtmlText(courseGroup.getName()));
            List<Context> childCourseGroupContexts = courseGroup.getValidChildContexts(CourseGroup.class, this.bolonhaStudentOptionalEnrollmentBean.getExecutionPeriod());
            List<Context> childCurricularCourseContexts = courseGroup.getValidChildContexts(CurricularCourse.class, this.bolonhaStudentOptionalEnrollmentBean.getExecutionPeriod());
            Collections.sort(childCourseGroupContexts, new BeanComparator("childOrder"));
            Collections.sort(childCurricularCourseContexts, new BeanComparator("childOrder"));
            this.generateCurricularCourses(blockContainer, childCurricularCourseContexts, depth + BolonhaStudentOptionalEnrollmentInputRenderer.this.getWidthDecreasePerLevel());
            for (Context context : childCourseGroupContexts) {
                this.generateCourseGroup(blockContainer, (CourseGroup)((Object)context.getChildDegreeModule()), depth + BolonhaStudentOptionalEnrollmentInputRenderer.this.getWidthDecreasePerLevel());
            }
        }

        private void generateCurricularCourses(HtmlBlockContainer blockContainer, List<Context> contexts, int depth) {
            HtmlTable table = new HtmlTable();
            blockContainer.addChild((HtmlComponent)table);
            table.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getTablesClasses());
            table.setStyle("width: " + (BolonhaStudentOptionalEnrollmentInputRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            for (Context context : contexts) {
                CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
                if (curricularCourse.isOptionalCurricularCourse()) continue;
                HtmlTableRow htmlTableRow = table.createRow();
                HtmlTableCell cellName = htmlTableRow.createCell();
                cellName.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getCurricularCourseNameClasses());
                cellName.setBody((HtmlComponent)this.generateCurricularCourseNameComponent(curricularCourse));
                HtmlTableCell yearCell = htmlTableRow.createCell();
                yearCell.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getCurricularCourseYearClasses());
                yearCell.setBody((HtmlComponent)new HtmlText(context.getCurricularPeriod().getFullLabel()));
                HtmlTableCell ectsCell = htmlTableRow.createCell();
                ectsCell.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getCurricularCourseEctsClasses());
                StringBuilder ects = new StringBuilder();
                ects.append(curricularCourse.getEctsCredits()).append(" ").append(BundleUtil.getString((String)"resources.StudentResources", (String)"label.credits.abbreviation", (String[])new String[0]));
                ectsCell.setBody((HtmlComponent)new HtmlText(ects.toString()));
                HtmlTableCell linkTableCell = htmlTableRow.createCell();
                linkTableCell.setClasses(BolonhaStudentOptionalEnrollmentInputRenderer.this.getCurricularCourseLinkClasses());
                HtmlActionLink actionLink = new HtmlActionLink();
                actionLink.setText(BundleUtil.getString((String)"resources.StudentResources", (String)"label.enroll", (String[])new String[0]));
                actionLink.setName("optionalCurricularCourseEnrolLink" + curricularCourse.getExternalId() + "_" + context.getExternalId());
                actionLink.setOnClick("$(this).closest('form').find('input[name=\\'method\\']').attr('value', 'enrolInOptionalCurricularCourse');");
                actionLink.setController((HtmlController)new UpdateSelectedOptionalCurricularCourseController(curricularCourse));
                linkTableCell.setBody((HtmlComponent)actionLink);
            }
        }

        private HtmlBlockContainer generateCurricularCourseNameComponent(CurricularCourse curricularCourse) {
            ExecutionSemester executionSemester = this.bolonhaStudentOptionalEnrollmentBean.getExecutionPeriod();
            HtmlBlockContainer container = new HtmlBlockContainer();
            container.addChild((HtmlComponent)new HtmlText(curricularCourse.getCode() + " - " + curricularCourse.getNameI18N(executionSemester).getContent()));
            if (curricularCourse.getCompetenceCourse() != null) {
                DepartmentUnit unit;
                String description = "";
                if (curricularCourse.getCompetenceCourse() != null && (unit = curricularCourse.getCompetenceCourse().getDepartmentUnit()) != null) {
                    description = unit.getName();
                }
                if (StringUtils.isNotBlank((String)description)) {
                    HtmlText descriptionText = new HtmlText("\n" + description, false, true);
                    descriptionText.setStyle("font-style: italic;");
                    container.addChild((HtmlComponent)descriptionText);
                }
            }
            return container;
        }
    }
}

