/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.PlanetUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.joda.time.YearMonthDay;
import pt.ist.standards.geographic.Planet;

public class LoadCountries
extends CustomTask {
    public void runTask() throws Exception {
        Locale PT = new Locale("pt");
        Locale EN = new Locale("en");
        Country defaultCountry = null;
        for (pt.ist.standards.geographic.Country metaData : Planet.getEarth().getPlaces()) {
            String localizedNamePT = null;
            try {
                localizedNamePT = metaData.getLocalizedName(PT);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String localizedNameEN = null;
            try {
                localizedNameEN = metaData.getLocalizedName(EN);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (localizedNameEN == null && localizedNamePT == null) continue;
            if (localizedNamePT == null) {
                localizedNamePT = localizedNameEN;
            }
            if (localizedNameEN == null) {
                localizedNameEN = localizedNamePT;
            }
            String nationalityPT = null;
            try {
                nationalityPT = metaData.getNationality(PT);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            String nationalityEN = null;
            try {
                nationalityEN = metaData.getNationality(EN);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (nationalityPT == null) {
                nationalityPT = nationalityEN == null ? localizedNamePT : nationalityEN;
            }
            if (nationalityEN == null) {
                nationalityEN = nationalityPT == null ? localizedNameEN : nationalityPT;
            }
            MultiLanguageString countryName = new MultiLanguageString(MultiLanguageString.pt, localizedNamePT);
            countryName.append(new MultiLanguageString(MultiLanguageString.en, localizedNameEN));
            String code = metaData.alpha2;
            String threeLetterCode = metaData.alpha3;
            Country country = new Country(countryName, new MultiLanguageString(MultiLanguageString.pt, nationalityPT).append(new MultiLanguageString(MultiLanguageString.en, nationalityEN)), code, threeLetterCode);
            if (!StringUtils.equals((String)threeLetterCode, (String)"PRT")) continue;
            defaultCountry = country;
        }
        defaultCountry.setDefaultCountry(Boolean.TRUE);
        Bennu rootDomainObject = Bennu.getInstance();
        PlanetUnit planetUnit = PlanetUnit.createNewPlanetUnit(new MultiLanguageString(Locale.getDefault(), "Earth"), null, null, "E", new YearMonthDay(), null, null, null, null, false, null);
        rootDomainObject.setEarthUnit((Unit)((Object)planetUnit));
        for (Country country : Country.readDistinctCountries()) {
            CountryUnit.createNewCountryUnit(new MultiLanguageString(Locale.getDefault(), country.getName()), null, null, country.getCode(), new YearMonthDay(), null, (Unit)((Object)planetUnit), null, null, false, null);
        }
    }
}

