/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.TagUtils;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionPagerTag
extends TagSupport {
    private static final Logger logger = LoggerFactory.getLogger(CollectionPagerTag.class);
    private String url;
    private String bundle;
    private String numberOfPagesAttributeName;
    private String pageNumberAttributeName;
    private String numberOfVisualizedPages;
    private String module;

    public int doStartTag() throws JspException {
        String pages = this.createCollectionPages();
        try {
            this.pageContext.getOut().print(pages);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private String createCollectionPages() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        StringBuilder stringBuilder = new StringBuilder();
        int lastPage = (Integer)this.pageContext.findAttribute(this.getNumberOfPagesAttributeName());
        int pageNumber = (Integer)this.pageContext.findAttribute(this.getPageNumberAttributeName());
        this.addFirstSymbols(stringBuilder, request, pageNumber);
        this.generatePageNumbers(stringBuilder, request, lastPage, pageNumber);
        this.addLastSymbols(stringBuilder, request, lastPage, pageNumber);
        return stringBuilder.toString();
    }

    private void generatePageNumbers(StringBuilder stringBuilder, HttpServletRequest request, int lastPage, int pageNumber) {
        Integer numberOfVisualizedPages;
        int firstVisualizedPage = 1;
        int lastVisualizedPage = lastPage;
        Integer n = numberOfVisualizedPages = this.getNumberOfVisualizedPages() != null ? Integer.valueOf(this.getNumberOfVisualizedPages()) : null;
        if (lastPage > 0 && numberOfVisualizedPages != null && numberOfVisualizedPages > 0 && lastPage > numberOfVisualizedPages) {
            if (pageNumber == 1) {
                lastVisualizedPage = numberOfVisualizedPages;
            } else if (pageNumber == lastPage) {
                firstVisualizedPage = lastPage - (numberOfVisualizedPages - 1);
            } else {
                int numberOfLeftAndRightPages = (int)Math.floor((numberOfVisualizedPages - 1) / 2);
                int leftPage = pageNumber - numberOfLeftAndRightPages <= 0 ? 1 : pageNumber - numberOfLeftAndRightPages;
                int rightPage = numberOfLeftAndRightPages + pageNumber;
                int n2 = pageNumber != 1 ? (leftPage >= 1 ? leftPage : 1) : (firstVisualizedPage = 1);
                lastVisualizedPage = pageNumber != lastPage ? (rightPage <= lastPage ? rightPage : lastPage) : lastPage;
                int numberOfResultPages = Math.abs(firstVisualizedPage - lastVisualizedPage) + 1;
                if (firstVisualizedPage == 1) {
                    lastVisualizedPage += numberOfVisualizedPages - numberOfResultPages;
                } else if (lastVisualizedPage == lastPage) {
                    firstVisualizedPage -= numberOfVisualizedPages - numberOfResultPages;
                }
            }
        }
        for (int i = firstVisualizedPage; i <= lastVisualizedPage; ++i) {
            if (i != pageNumber) {
                stringBuilder.append("&nbsp;<a href=\"").append(request.getContextPath()).append(this.getUrl()).append("&amp;").append(this.getPageNumberAttributeName()).append("=").append(Integer.toString(i)).append("\">");
                stringBuilder.append(Integer.toString(i)).append("</a>&nbsp;");
                continue;
            }
            stringBuilder.append("&nbsp;<b>").append(Integer.toString(i)).append("</b>&nbsp;");
        }
    }

    private void addLastSymbols(StringBuilder stringBuilder, HttpServletRequest request, int lastPage, int pageNumber) throws JspException {
        if (lastPage > 1 && pageNumber != lastPage) {
            Integer numberOfVisualizedPages;
            stringBuilder.append("&nbsp;<a href=\"").append(request.getContextPath()).append(this.getUrl()).append("&amp;").append(this.getPageNumberAttributeName()).append("=").append(Integer.toString(pageNumber + 1)).append("\">");
            stringBuilder.append(this.getMessage("label.collectionPager.next", "&gt;")).append("</a>");
            stringBuilder.append("&nbsp;<a href=\"").append(request.getContextPath()).append(this.getUrl()).append("&amp;").append(this.getPageNumberAttributeName()).append("=").append(Integer.toString(lastPage)).append("\">");
            stringBuilder.append(this.getMessage("label.collectionPager.last", "&gt;&gt;")).append("</a>");
            Integer n = numberOfVisualizedPages = this.getNumberOfVisualizedPages() != null ? Integer.valueOf(this.getNumberOfVisualizedPages()) : null;
            if (numberOfVisualizedPages != null && numberOfVisualizedPages > 0 && lastPage > numberOfVisualizedPages) {
                stringBuilder.append(" <span style=\"color: #777;\">(Total: ").append(lastPage).append(")</span>");
            }
        }
    }

    private void addFirstSymbols(StringBuilder stringBuilder, HttpServletRequest request, int pageNumber) throws JspException {
        if (pageNumber > 0 && pageNumber != 1) {
            stringBuilder.append("<a href=\"").append(request.getContextPath()).append(this.getUrl()).append("&amp;").append(this.getPageNumberAttributeName()).append("=").append("1").append("\">");
            stringBuilder.append(this.getMessage("label.collectionPager.first", "&lt;&lt;")).append("</a>&nbsp;");
            stringBuilder.append("<a href=\"").append(request.getContextPath()).append(this.getUrl()).append("&amp;").append(this.getPageNumberAttributeName()).append("=").append(Integer.toString(pageNumber - 1)).append("\">");
            stringBuilder.append(this.getMessage("label.collectionPager.previous", "&lt;")).append("</a>&nbsp;");
        }
    }

    private String getMessage(String key, String alternative) throws JspException {
        String message = this.getMessageFromBundle(key);
        return message != null ? message : alternative;
    }

    private String getMessageFromBundle(String key) throws JspException {
        return this.getBundle() != null ? (TagUtils.getInstance().present(this.pageContext, this.getBundle(), I18N.getLocale().toString(), key) ? TagUtils.getInstance().message(this.pageContext, this.getBundle(), I18N.getLocale().toString(), key) : null) : null;
    }

    private Boolean hasModule() {
        return this.module != null;
    }

    public String getNumberOfPagesAttributeName() {
        return this.numberOfPagesAttributeName;
    }

    public void setNumberOfPagesAttributeName(String numberOfPagesAttributeName) {
        this.numberOfPagesAttributeName = numberOfPagesAttributeName;
    }

    public String getPageNumberAttributeName() {
        return this.pageNumberAttributeName;
    }

    public void setPageNumberAttributeName(String pageNumberAttributeName) {
        this.pageNumberAttributeName = pageNumberAttributeName;
    }

    public String getUrl() {
        if (this.hasModule().booleanValue()) {
            return "/" + this.module + (this.url.startsWith("/") ? "" : "/") + this.url;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getNumberOfVisualizedPages() {
        return this.numberOfVisualizedPages;
    }

    public void setNumberOfVisualizedPages(String numberOfVisualizedPages) {
        this.numberOfVisualizedPages = numberOfVisualizedPages;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

