/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.dto.InfoRoomOccupation;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.util.DiaSemana;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class InfoLesson
extends InfoShowOccupation
implements Comparable<InfoLesson> {
    private static final Comparator<InfoLesson> INFO_LESSON_COMPARATOR_CHAIN = new Comparator<InfoLesson>(){

        @Override
        public int compare(InfoLesson o1, InfoLesson o2) {
            int c1 = o1.getDiaSemana().getDiaSemana().compareTo(o2.getDiaSemana().getDiaSemana());
            if (c1 != 0) {
                return c1;
            }
            int c2 = o1.getInicio().compareTo(o2.getInicio());
            if (c2 != 0) {
                return c2;
            }
            int c3 = o1.getFim().compareTo(o2.getFim());
            return c3 != 0 ? o1.getInfoSala().getNome().compareTo(o2.getInfoShift().getNome()) : c3;
        }
    };
    private InfoRoom infoSala;
    private InfoShift infoShift;
    private InfoRoomOccupation infoRoomOccupation;

    public InfoLesson(Lesson lesson) {
        super.copyFromDomain((DomainObject)lesson);
    }

    @Override
    public ShiftType getTipo() {
        return null;
    }

    @Override
    public DiaSemana getDiaSemana() {
        return this.getLesson().getDiaSemana();
    }

    @Override
    public Calendar getFim() {
        return this.getLesson().getFim();
    }

    @Override
    public Calendar getInicio() {
        return this.getLesson().getInicio();
    }

    public FrequencyType getFrequency() {
        return this.getLesson().getFrequency();
    }

    public YearMonthDay getLessonBegin() {
        return this.getLesson() != null && this.getLesson().getPeriod() != null ? this.getLesson().getPeriod().getStartYearMonthDay() : null;
    }

    public YearMonthDay getLessonEnd() {
        return this.getLesson() != null && this.getLesson().getPeriod() != null ? this.getLesson().getPeriod().getLastOccupationPeriodOfNestedPeriods().getEndYearMonthDay() : null;
    }

    public String getWeekDay() {
        String result = this.getDiaSemana().getDiaSemana().toString();
        if (result != null && result.equals("7")) {
            return "S";
        }
        if (result != null && result.equals("1")) {
            return "D";
        }
        return result;
    }

    public String getLessonDuration() {
        return this.getLesson().getUnitHours().toString();
    }

    public InfoRoom getInfoSala() {
        return this.infoSala == null ? (this.infoSala = InfoRoom.newInfoFromDomain(this.getLesson().getSala())) : this.infoSala;
    }

    @Override
    public InfoShift getInfoShift() {
        return this.infoShift == null ? (this.infoShift = InfoShift.newInfoFromDomain(this.getLesson().getShift())) : this.infoShift;
    }

    @Override
    public InfoRoomOccupation getInfoRoomOccupation() {
        if (this.infoRoomOccupation == null) {
            this.infoRoomOccupation = InfoRoomOccupation.newInfoFromDomain((EventSpaceOccupation)((Object)this.getLesson().getLessonSpaceOccupation()));
        }
        return this.infoRoomOccupation;
    }

    public static InfoLesson newInfoFromDomain(Lesson lesson) {
        return lesson != null ? new InfoLesson(lesson) : null;
    }

    @Deprecated
    public static List<InfoLesson> newInfosForSchoolClass(SchoolClass schoolClass) {
        ArrayList<InfoLesson> lessons = new ArrayList<InfoLesson>();
        for (Shift shift : schoolClass.getAssociatedShiftsSet()) {
            for (Lesson lesson : shift.getAssociatedLessonsSet()) {
                lessons.add(new InfoLesson(lesson));
            }
        }
        return lessons;
    }

    @Override
    public int compareTo(InfoLesson arg0) {
        return INFO_LESSON_COMPARATOR_CHAIN.compare(this, arg0);
    }

    public String getNextPossibleLessonInstanceDate() {
        YearMonthDay day = this.getLesson().getNextPossibleLessonInstanceDate();
        return day != null ? day.toString("dd/MM/yyyy") : "-";
    }

    @Override
    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof InfoLesson) {
            InfoLesson infoAula = (InfoLesson)obj;
            resultado = this.getDiaSemana().equals(infoAula.getDiaSemana()) && this.getInicio().get(11) == infoAula.getInicio().get(11) && this.getInicio().get(12) == infoAula.getInicio().get(12) && this.getFim().get(11) == infoAula.getFim().get(11) && this.getFim().get(12) == infoAula.getFim().get(12) && (this.getInfoSala() == null && infoAula.getInfoSala() == null || this.getInfoSala() != null && this.getInfoSala().equals(infoAula.getInfoSala())) && (this.getInfoRoomOccupation() == null && infoAula.getInfoRoomOccupation() == null || this.getInfoRoomOccupation() != null && this.getInfoRoomOccupation().equals(infoAula.getInfoRoomOccupation()));
        }
        return resultado;
    }

    public Lesson getLesson() {
        Lesson lesson;
        if (!Strings.isNullOrEmpty((String)this.getExternalId()) && FenixFramework.isDomainObjectValid((DomainObject)(lesson = (Lesson)FenixFramework.getDomainObject((String)this.getExternalId())))) {
            return lesson;
        }
        return null;
    }

    public String getOccurrenceWeeksAsString() {
        return this.getLesson().getOccurrenceWeeksAsString();
    }
}

