/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.space;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.UnavailableException;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.space.EventSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.dto.spaceManager.FindSpacesBean;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.SpaceClassification;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.SharedOccupation;
import org.joda.time.Interval;
import org.joda.time.YearMonthDay;

public class SpaceUtils {
    public static final String SCHOOL_SPACES = "School Spaces";
    public static final String CAMPUS = "Campus";
    public static final String BUILDING = "Building";
    public static final String FLOOR = "Floor";
    public static final String ROOM_SUBDIVISION = "Room Subdivision";
    public static final String ROOM = "Room";
    public static final String LABORATORY_FOR_EDUCATION_CODE = "2.1";
    public static final String LABORATORY_FOR_RESEARCHER_CODE = "2.2";
    public static final Comparator<Space> ROOM_COMPARATOR_BY_NAME = new ComparatorChain();
    public static final Comparator<SpaceClassification> COMPARATORY_BY_PARENT_ROOM_CLASSIFICATION_AND_CODE;
    public static final Comparator<Space> COMPARATOR_BY_PRESENTATION_NAME;
    public static final Comparator<Space> COMPARATOR_BY_NAME_FLOOR_BUILDING_AND_CAMPUS;

    public static Space findAllocatableSpaceForEducationByName(String name) {
        return SpaceUtils.allocatableSpacesForEducation().filter(space -> space.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    public static Stream<Space> allocatableSpaces() {
        return Space.getSpaces().filter(space -> SpaceUtils.isRoom(space) || SpaceUtils.isRoomSubdivision(space)).sorted();
    }

    public static Stream<Space> allocatableSpacesForEducation() {
        return SpaceUtils.allocatableSpaces().filter(space -> SpaceUtils.isForEducation(space));
    }

    public static List<InfoRoom> allocatableSpace(YearMonthDay startDate, YearMonthDay endDate, HourMinuteSecond startTimeHMS, HourMinuteSecond endTimeHMS, DiaSemana dayOfWeek, Integer normalCapacity, FrequencyType frequency, boolean withLabs) {
        return SpaceUtils.allocatableSpace(normalCapacity, withLabs).filter(space -> SpaceUtils.isFree(space, startDate, endDate, startTimeHMS, endTimeHMS, dayOfWeek, frequency, true, true)).map(space -> InfoRoom.newInfoFromDomain(space)).collect(Collectors.toList());
    }

    public static List<InfoRoom> allocatableSpace(Integer normalCapacity, boolean withLabs, List<Interval> intervals) {
        return SpaceUtils.allocatableSpace(normalCapacity, withLabs).filter(space -> SpaceUtils.isFree(space, intervals)).map(space -> InfoRoom.newInfoFromDomain(space)).collect(Collectors.toList());
    }

    public static List<Space> allocatableSpace(Integer normalCapacity, boolean withLabs, Interval ... intervals) {
        return SpaceUtils.allocatableSpace(normalCapacity, withLabs).filter(space -> space.isFree(intervals)).collect(Collectors.toList());
    }

    public static Stream<Space> allocatableSpace(Integer normalCapacity, boolean withLabs) {
        Stream<Space> stream = SpaceUtils.allocatableSpacesForEducation();
        if (normalCapacity != null) {
            stream = stream.filter(space -> space.getAllocatableCapacity() >= normalCapacity);
        }
        if (!withLabs) {
            stream = stream.filter(space -> !SpaceUtils.isLaboratory(space));
        }
        return stream;
    }

    public static List<Space> buildings() {
        return Space.getSpaces().filter(space -> SpaceUtils.isBuilding(space)).sorted().collect(Collectors.toList());
    }

    public static boolean isCampus(Space space) {
        return SpaceClassification.getByName((String)CAMPUS).equals((Object)space.getClassification());
    }

    public static boolean isBuilding(Space space) {
        return SpaceClassification.getByName((String)BUILDING).equals((Object)space.getClassification());
    }

    public static boolean isFloor(Space space) {
        return SpaceClassification.getByName((String)FLOOR).equals((Object)space.getClassification());
    }

    public static boolean isRoomSubdivision(Space space) {
        return SpaceClassification.getByName((String)ROOM_SUBDIVISION).equals((Object)space.getClassification());
    }

    public static boolean isRoom(Space space) {
        return !SpaceUtils.isCampus(space) && !SpaceUtils.isBuilding(space) && !SpaceUtils.isFloor(space) && !SpaceUtils.isRoomSubdivision(space);
    }

    public static boolean isLaboratory(Space space) {
        SpaceClassification classification = space.getClassification();
        return classification.equals((Object)SpaceClassification.get((String)LABORATORY_FOR_EDUCATION_CODE)) || classification.equals((Object)SpaceClassification.get((String)LABORATORY_FOR_RESEARCHER_CODE));
    }

    public static boolean isForEducation(Space space) {
        return SpaceUtils.isForEducation(space, Authenticate.getUser());
    }

    private static boolean isForEducation(Space space, User user) {
        if (!space.isActive() || !SpaceUtils.isRoom(space) && !SpaceUtils.isRoomSubdivision(space)) {
            return false;
        }
        Group lessonGroup = space.getOccupationsGroupWithChainOfResponsability();
        return lessonGroup != null && lessonGroup.getMembers().size() > 0 && (user == null || lessonGroup.isMember(user));
    }

    public static boolean isFree(Space space, YearMonthDay startDate, YearMonthDay endDate, HourMinuteSecond startTime, HourMinuteSecond endTime, DiaSemana dayOfWeek, FrequencyType frequency, Boolean dailyFrequencyMarkSaturday, Boolean dailyFrequencyMarkSunday) {
        return SpaceUtils.isFree(space, startDate, endDate, startTime, endTime, dayOfWeek, frequency, dailyFrequencyMarkSaturday, dailyFrequencyMarkSunday, null);
    }

    public static boolean isFree(Space space, YearMonthDay startDate, YearMonthDay endDate, HourMinuteSecond startTime, HourMinuteSecond endTime, DiaSemana dayOfWeek, FrequencyType frequency, Boolean dailyFrequencyMarkSaturday, Boolean dailyFrequencyMarkSunday, Set<Class<? extends EventSpaceOccupation>> eventSpaceOccupationClassesToSkip) {
        List<Interval> intervals = null;
        if (eventSpaceOccupationClassesToSkip == null) {
            eventSpaceOccupationClassesToSkip = Collections.emptySet();
        }
        for (Occupation spaceOccupation : SpaceUtils.getResourceAllocationsForCheck(space)) {
            if (spaceOccupation instanceof EventSpaceOccupation) {
                if (eventSpaceOccupationClassesToSkip.contains(spaceOccupation.getClass())) continue;
                EventSpaceOccupation occupation = (EventSpaceOccupation)spaceOccupation;
                if (occupation.alreadyWasOccupiedIn(startDate, endDate, startTime, endTime, dayOfWeek, frequency, dailyFrequencyMarkSaturday, dailyFrequencyMarkSunday)) {
                    return false;
                }
            }
            if (!spaceOccupation.getClass().equals(Occupation.class)) continue;
            if (intervals == null) {
                intervals = EventSpaceOccupation.generateEventSpaceOccupationIntervals(startDate, endDate, startTime, endTime, frequency, dayOfWeek, dailyFrequencyMarkSaturday, dailyFrequencyMarkSunday, null, null);
            }
            if (!spaceOccupation.overlaps(intervals).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isFree(Space space, List<Interval> intervals) {
        for (Occupation spaceOccupation : SpaceUtils.getResourceAllocationsForCheck(space)) {
            if (!spaceOccupation.overlaps(intervals).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Space getSpaceByName(String name) {
        return Space.getSpaces().filter(space -> name.equals(space.getName())).findAny().get();
    }

    public static Occupation getFirstOccurrenceOfResourceAllocationByClass(Space space, WrittenEvaluation evaluation) {
        for (Occupation resourceAllocation : space.getOccupationSet()) {
            WrittenEvaluationSpaceOccupation evaluationSpaceOccupation;
            Set evaluations;
            if (!(resourceAllocation instanceof WrittenEvaluationSpaceOccupation) || (evaluations = (evaluationSpaceOccupation = (WrittenEvaluationSpaceOccupation)resourceAllocation).getWrittenEvaluationsSet()).isEmpty() || evaluations.iterator().next() != evaluation) continue;
            return resourceAllocation;
        }
        return null;
    }

    public static Occupation getFirstOccurrenceOfResourceAllocationByClass(Space space, Lesson lesson) {
        for (Occupation resourceAllocation : space.getOccupationSet()) {
            LessonInstanceSpaceOccupation lessonInstanceSpaceOccupation;
            Set instancesSet;
            if (!(resourceAllocation instanceof LessonInstanceSpaceOccupation) || (instancesSet = (lessonInstanceSpaceOccupation = (LessonInstanceSpaceOccupation)resourceAllocation).getLessonInstancesSet()).isEmpty() || ((LessonInstance)((Object)instancesSet.iterator().next())).getLesson() != lesson) continue;
            return resourceAllocation;
        }
        return null;
    }

    public static Space getDefaultCampus() {
        if (Bennu.getInstance().getDefaultCampus() == null) {
            return (Space)Ordering.from(COMPARATOR_BY_PRESENTATION_NAME).min((Iterable)Space.getAllCampus());
        }
        return Bennu.getInstance().getDefaultCampus();
    }

    public static SortedSet<SpaceClassification> sortByRoomClassificationAndCode(Collection<SpaceClassification> roomClassifications) {
        return ImmutableSortedSet.orderedBy(COMPARATORY_BY_PARENT_ROOM_CLASSIFICATION_AND_CODE).addAll(roomClassifications).build();
    }

    public static List<Space> getAllActiveSubRoomsForEducation(Space space) {
        ArrayList<Space> result = new ArrayList<Space>();
        Set containedSpaces = space.getChildren();
        for (Space subSpace : containedSpaces) {
            if (!SpaceUtils.isRoom(subSpace) && !SpaceUtils.isRoomSubdivision(subSpace) || !subSpace.isActive() || !SpaceUtils.isForEducation(subSpace)) continue;
            result.add(subSpace);
        }
        Iterator iterator = containedSpaces.iterator();
        while (iterator.hasNext()) {
            Space subSpace;
            Space subSpaceSpace = subSpace = (Space)iterator.next();
            result.addAll(SpaceUtils.getAllActiveSubRoomsForEducation(subSpaceSpace));
        }
        return result;
    }

    public static Integer countAllAvailableSeatsForExams() {
        return SpaceUtils.allocatableSpaces().mapToInt(space -> space.getMetadata("examCapacity").orElse(0)).sum();
    }

    public static boolean personIsSpacesAdministrator(Person person) {
        return (RoleType.MANAGER.isMember(person.getUser()) || RoleType.SPACE_MANAGER_SUPER_USER.isMember(person.getUser())) && RoleType.SPACE_MANAGER.isMember(person.getUser());
    }

    public static Space getSpaceBuilding(Space space) {
        if (SpaceUtils.isBuilding(space)) {
            return space;
        }
        if (space.getParent() == null || !space.getParent().isActive()) {
            return null;
        }
        return SpaceUtils.getSpaceBuilding(space.getParent());
    }

    public static Space getSpaceFloor(Space space) {
        if (SpaceUtils.isFloor(space)) {
            if (space.getParent() == null) {
                return space;
            }
            if (SpaceUtils.isFloor(space.getParent())) {
                return SpaceUtils.getSpaceFloor(space.getParent());
            }
            return space;
        }
        if (space.getParent() == null) {
            return null;
        }
        return SpaceUtils.getSpaceFloor(space.getParent());
    }

    public static Space getSpaceFloorWithIntermediary(Space space) throws UnavailableException {
        if (SpaceUtils.isFloor(space)) {
            return space;
        }
        if (space.getParent() == null) {
            return null;
        }
        return SpaceUtils.getSpaceFloorWithIntermediary(space.getParent());
    }

    public static Space getSpaceCampus(Space space) {
        if (SpaceUtils.isCampus(space)) {
            return space;
        }
        if (space.getParent() == null) {
            return null;
        }
        return SpaceUtils.getSpaceCampus(space.getParent());
    }

    public static Collection<Occupation> getResourceAllocationsForCheck(Space space) {
        List<Space> roomSubdivisions = SpaceUtils.getRoomSubdivisions(space);
        if (roomSubdivisions.isEmpty()) {
            return space.getOccupationSet();
        }
        ArrayList<Occupation> result = new ArrayList<Occupation>();
        result.addAll(space.getOccupationSet());
        for (Space roomSubdivision : SpaceUtils.getRoomSubdivisions(space)) {
            result.addAll(roomSubdivision.getOccupationSet());
        }
        return result;
    }

    public static List<Space> getRoomSubdivisions(Space space) {
        ArrayList<Space> result = new ArrayList<Space>();
        for (Space subSpaceSpace : space.getChildren()) {
            Space subSpace = subSpaceSpace;
            if (!SpaceUtils.isRoomSubdivision(subSpace)) continue;
            result.add(subSpace);
        }
        return result;
    }

    public static List<Lesson> getAssociatedLessons(Space space, AcademicInterval academicInterval) {
        ArrayList<Lesson> lessons = new ArrayList<Lesson>();
        for (Occupation spaceOccupation : space.getOccupationSet()) {
            LessonSpaceOccupation roomOccupation;
            Lesson lesson;
            if (!(spaceOccupation instanceof LessonSpaceOccupation) || !(lesson = (roomOccupation = (LessonSpaceOccupation)spaceOccupation).getLesson()).getAcademicInterval().equals(academicInterval)) continue;
            lessons.add(lesson);
        }
        return lessons;
    }

    public static String[] getIdentificationWords(String name) {
        String[] identificationWords = null;
        if (name != null && !Strings.isNullOrEmpty((String)name.trim())) {
            identificationWords = StringNormalizer.normalize((String)name).trim().split(" ");
        }
        return identificationWords;
    }

    private static Set<ExecutionCourse> searchExecutionCoursesByName(FindSpacesBean.SpacesSearchCriteriaType searchType, String[] labelWords) {
        HashSet<ExecutionCourse> executionCoursesToTest = null;
        if (labelWords != null && (searchType.equals((Object)FindSpacesBean.SpacesSearchCriteriaType.EXECUTION_COURSE) || searchType.equals((Object)FindSpacesBean.SpacesSearchCriteriaType.WRITTEN_EVALUATION))) {
            executionCoursesToTest = new HashSet<ExecutionCourse>();
            for (ExecutionCourse executionCourse : ExecutionSemester.readActualExecutionSemester().getAssociatedExecutionCoursesSet()) {
                if (!executionCourse.verifyNameEquality(labelWords)) continue;
                executionCoursesToTest.add(executionCourse);
            }
        }
        return executionCoursesToTest;
    }

    private static Collection<Person> searchPersonsByName(FindSpacesBean.SpacesSearchCriteriaType searchType, String labelToSearch) {
        if (labelToSearch != null && !Strings.isNullOrEmpty((String)labelToSearch) && searchType.equals((Object)FindSpacesBean.SpacesSearchCriteriaType.PERSON)) {
            return Person.findPerson(labelToSearch);
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean verifyNameEquality(Space space, String[] nameWords) {
        String spacePresentationName;
        if (nameWords != null && (spacePresentationName = space.getPresentationName()) != null) {
            int i;
            String[] spaceIdentificationWords = StringNormalizer.normalize((String)spacePresentationName).trim().split(" ");
            for (i = 0; i < nameWords.length; ++i) {
                int j;
                if (nameWords[i].equals("")) continue;
                for (j = 0; j < spaceIdentificationWords.length && !spaceIdentificationWords[j].equals(nameWords[i]); ++j) {
                }
                if (j != spaceIdentificationWords.length) continue;
                return false;
            }
            if (i == nameWords.length) {
                return true;
            }
        }
        return false;
    }

    public static List<Space> getSpaceFullPath(Space space) {
        ArrayList<Space> result = new ArrayList<Space>();
        result.add(space);
        for (Space suroundingSpace = space.getParent(); suroundingSpace != null; suroundingSpace = suroundingSpace.getParent()) {
            result.add(0, suroundingSpace);
        }
        return result;
    }

    public static Set<Space> findSpaces(String labelToSearch, Space campus, Space building, FindSpacesBean.SpacesSearchCriteriaType searchType) {
        TreeSet<Space> result = new TreeSet<Space>(COMPARATOR_BY_NAME_FLOOR_BUILDING_AND_CAMPUS);
        if (searchType != null && (campus != null || building != null || labelToSearch != null && !Strings.isNullOrEmpty((String)labelToSearch.trim()))) {
            String[] labelWords = SpaceUtils.getIdentificationWords(labelToSearch);
            Set<ExecutionCourse> executionCoursesToTest = SpaceUtils.searchExecutionCoursesByName(searchType, labelWords);
            Collection<Person> personsToTest = SpaceUtils.searchPersonsByName(searchType, labelToSearch);
            for (Space space : Space.getSpaces().collect(Collectors.toList())) {
                Space spaceCampus;
                Space spaceBuilding;
                if (space.equals((Object)campus) || space.equals((Object)building)) continue;
                if (labelWords != null) {
                    boolean toAdd = false;
                    block0 : switch (searchType) {
                        case SPACE: {
                            toAdd = SpaceUtils.verifyNameEquality(space, labelWords);
                            break;
                        }
                        case PERSON: {
                            for (Person person : personsToTest) {
                                Optional<SharedOccupation> personSpace = person.getUser().getSharedOccupationSet().stream().filter(so -> so.isActive() != false && so.getSpaces().contains(space)).findAny();
                                if (!personSpace.isPresent()) continue;
                                toAdd = true;
                                break block0;
                            }
                            break;
                        }
                        case EXECUTION_COURSE: {
                            for (ExecutionCourse executionCourse : executionCoursesToTest) {
                                if (!executionCourse.getAllRooms().contains(space)) continue;
                                toAdd = true;
                                break block0;
                            }
                            break;
                        }
                        case WRITTEN_EVALUATION: {
                            for (ExecutionCourse executionCourse : executionCoursesToTest) {
                                SortedSet<WrittenEvaluation> writtenEvaluations = executionCourse.getWrittenEvaluations();
                                for (WrittenEvaluation writtenEvaluation : writtenEvaluations) {
                                    if (!writtenEvaluation.getAssociatedRooms().contains(space)) continue;
                                    toAdd = true;
                                    break;
                                }
                                if (!toAdd) continue;
                                break block0;
                            }
                            break;
                        }
                    }
                    if (!toAdd) continue;
                }
                if (building != null ? (spaceBuilding = SpaceUtils.getSpaceBuilding(space)) == null || !spaceBuilding.equals((Object)building) : campus != null && ((spaceCampus = SpaceUtils.getSpaceCampus(space)) == null || !spaceCampus.equals((Object)campus))) continue;
                result.add(space);
            }
        }
        return result;
    }

    static {
        ((ComparatorChain)ROOM_COMPARATOR_BY_NAME).addComparator((Comparator)new BeanComparator("name", (Comparator)Collator.getInstance()));
        ((ComparatorChain)ROOM_COMPARATOR_BY_NAME).addComparator((Comparator)new BeanComparator("externalId"));
        COMPARATORY_BY_PARENT_ROOM_CLASSIFICATION_AND_CODE = new BeanComparator("absoluteCode");
        COMPARATOR_BY_PRESENTATION_NAME = new Comparator<Space>(){

            @Override
            public int compare(Space o1, Space o2) {
                if (SpaceUtils.isFloor(o1) && SpaceUtils.isFloor(o2)) {
                    Integer otherLevel;
                    Integer level = o1.getMetadata("level").orElse(-1);
                    int compareTo1 = level.compareTo(otherLevel = o2.getMetadata("level").orElse(-1));
                    if (compareTo1 == 0) {
                        return o1.getExternalId().compareTo(o2.getExternalId());
                    }
                    return compareTo1;
                }
                int compareTo = o1.getName().compareTo(o2.getName());
                if (compareTo == 0) {
                    return o1.getExternalId().compareTo(o2.getExternalId());
                }
                return compareTo;
            }
        };
        COMPARATOR_BY_NAME_FLOOR_BUILDING_AND_CAMPUS = new Comparator<Space>(){

            @Override
            public int compare(Space o1, Space o2) {
                try {
                    Integer buildingCheck = this.checkObjects(SpaceUtils.getSpaceBuilding(o1), SpaceUtils.getSpaceBuilding(o2));
                    if (buildingCheck != null) {
                        return buildingCheck;
                    }
                    Integer campusCheck = this.checkObjects(SpaceUtils.getSpaceCampus(o1), SpaceUtils.getSpaceCampus(o2));
                    if (campusCheck != null) {
                        return campusCheck;
                    }
                    Integer floorCheck = this.checkObjects(SpaceUtils.getSpaceFloorWithIntermediary(o1), SpaceUtils.getSpaceFloorWithIntermediary(o2));
                    if (floorCheck != null) {
                        return floorCheck;
                    }
                    int compareTo = o1.getName().compareTo(o2.getName());
                    if (compareTo == 0) {
                        return o1.getExternalId().compareTo(o2.getExternalId());
                    }
                    return compareTo;
                }
                catch (UnavailableException e1) {
                    return -1;
                }
            }

            private Integer checkObjects(Space space1, Space space2) throws UnavailableException {
                if (space1 != null && space2 == null) {
                    return 1;
                }
                if (space1 == null && space2 != null) {
                    return -1;
                }
                if (space1 == null && space2 == null) {
                    return null;
                }
                if (!space1.equals((Object)space2)) {
                    if (SpaceUtils.isFloor(space1) && SpaceUtils.isFloor(space2)) {
                        Integer otherLevel;
                        Integer level = space1.getMetadata("level").orElse(-1);
                        int compareTo1 = level.compareTo(otherLevel = space2.getMetadata("level").orElse(-1));
                        if (compareTo1 == 0) {
                            return space1.getExternalId().compareTo(space2.getExternalId());
                        }
                        return compareTo1;
                    }
                    int compareTo = space1.getName().compareTo(space2.getName());
                    if (compareTo == 0) {
                        return space1.getExternalId().compareTo(space2.getExternalId());
                    }
                    return compareTo;
                }
                return null;
            }
        };
    }
}

