/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionBatch_Base;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionState;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class RectorateSubmissionBatch
extends RectorateSubmissionBatch_Base {
    public RectorateSubmissionBatch(AdministrativeOffice administrativeOffice) {
        this.setCreation(new DateTime());
        this.setCreator(AccessControl.getPerson());
        this.setState(RectorateSubmissionState.UNSENT);
        this.setAdministrativeOffice(administrativeOffice);
        this.setRootDomainObject(Bennu.getInstance());
    }

    public boolean isUnsent() {
        return this.getState().equals((Object)RectorateSubmissionState.UNSENT);
    }

    public boolean isClosed() {
        return this.getState().equals((Object)RectorateSubmissionState.CLOSED);
    }

    public boolean isSent() {
        return this.getState().equals((Object)RectorateSubmissionState.SENT);
    }

    public boolean isReceived() {
        return this.getState().equals((Object)RectorateSubmissionState.RECEIVED);
    }

    public RectorateSubmissionBatch getNextRectorateSubmissionBatch() {
        RectorateSubmissionBatch next = null;
        for (RectorateSubmissionBatch batch : this.getAdministrativeOffice().getRectorateSubmissionBatchSet()) {
            if (!batch.getCreation().isAfter((ReadableInstant)this.getCreation()) || next != null && !batch.getCreation().isBefore((ReadableInstant)next.getCreation())) continue;
            next = batch;
        }
        return next;
    }

    public RectorateSubmissionBatch getPreviousRectorateSubmissionBatch() {
        RectorateSubmissionBatch previous = null;
        for (RectorateSubmissionBatch batch : this.getAdministrativeOffice().getRectorateSubmissionBatchSet()) {
            if (!batch.getCreation().isBefore((ReadableInstant)this.getCreation()) || previous != null && !batch.getCreation().isAfter((ReadableInstant)previous.getCreation())) continue;
            previous = batch;
        }
        return previous;
    }

    public String getRange() {
        String first = null;
        String last = null;
        for (AcademicServiceRequest request : this.getDocumentRequestSet()) {
            DiplomaRequest diploma;
            RegistryCode code = null;
            if (request.isRegistryDiploma()) {
                code = request.getRegistryCode();
            } else if (request.isDiploma() && request.isRequestForRegistration() && !(diploma = (DiplomaRequest)((Object)request)).hasRegistryDiplomaRequest()) {
                code = diploma.getRegistryCode();
            }
            if (code == null) continue;
            if (first == null || code.getCode().compareTo(first) < 0) {
                first = code.getCode();
            }
            if (last != null && code.getCode().compareTo(last) <= 0) continue;
            last = code.getCode();
        }
        if (first != null && last != null) {
            return first + "-" + last;
        }
        return "-";
    }

    public int getDiplomaDocumentRequestCount() {
        int acc = 0;
        for (AcademicServiceRequest docRequest : this.getDocumentRequestSet()) {
            if (!docRequest.isRegistryDiploma() && !docRequest.isDiplomaSupplement()) continue;
            ++acc;
        }
        return acc;
    }

    public RectorateSubmissionBatch closeBatch() {
        if (!this.getState().equals((Object)RectorateSubmissionState.UNSENT)) {
            throw new DomainException("error.rectorateSubmission.attemptingToCloseABatchNotInUnsentState", new String[0]);
        }
        this.setState(RectorateSubmissionState.CLOSED);
        return new RectorateSubmissionBatch(this.getAdministrativeOffice());
    }

    public void markAsSent() {
        if (!this.getState().equals((Object)RectorateSubmissionState.CLOSED)) {
            throw new DomainException("error.rectorateSubmission.attemptingToSendABatchNotInClosedState", new String[0]);
        }
        this.setState(RectorateSubmissionState.SENT);
        this.setSubmission(new DateTime());
        this.setSubmitter(AccessControl.getPerson());
        for (AcademicServiceRequest document : this.getDocumentRequestSet()) {
            if (document.isCancelled() || document.isRejected()) continue;
            document.edit(new AcademicServiceRequestBean(AcademicServiceRequestSituationType.SENT_TO_EXTERNAL_ENTITY, AccessControl.getPerson(), "Insert Template Text Here"));
        }
    }

    public boolean allDocumentsReceived() {
        for (AcademicServiceRequest document : this.getDocumentRequestSet()) {
            AcademicServiceRequestSituationType type = document.getAcademicServiceRequestSituationType();
            if (type.equals((Object)AcademicServiceRequestSituationType.RECEIVED_FROM_EXTERNAL_ENTITY) || type.equals((Object)AcademicServiceRequestSituationType.DELIVERED)) continue;
            return false;
        }
        return true;
    }

    public void markAsReceived() {
        if (!this.getState().equals((Object)RectorateSubmissionState.SENT)) {
            throw new DomainException("error.rectorateSubmission.attemptingToReceiveABatchNotInSentState", new String[0]);
        }
        if (this.allDocumentsReceived()) {
            this.setState(RectorateSubmissionState.RECEIVED);
            this.setReception(new DateTime());
            this.setReceptor(AccessControl.getPerson());
        }
    }

    public void delete() {
        if (!this.getDocumentRequestSet().isEmpty()) {
            throw new DomainException("error.rectorateSubmission.cannotDeleteBatchWithDocuments", new String[0]);
        }
        this.setCreator(null);
        this.setReceptor(null);
        this.setSubmitter(null);
        this.setAdministrativeOffice(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public int getDocumentRequestCount() {
        int result = 0;
        Set documentRequestSet = this.getDocumentRequestSet();
        for (AcademicServiceRequest academicServiceRequest : documentRequestSet) {
            if (academicServiceRequest.isRejected() || academicServiceRequest.isCancelled()) continue;
            ++result;
        }
        return result;
    }

    public static Set<RectorateSubmissionBatch> getRectorateSubmissionBatchesByState(Collection<AdministrativeOffice> offices, RectorateSubmissionState state) {
        HashSet<RectorateSubmissionBatch> result = new HashSet<RectorateSubmissionBatch>();
        for (AdministrativeOffice office : offices) {
            for (RectorateSubmissionBatch batch : office.getRectorateSubmissionBatchSet()) {
                if (!batch.getState().equals((Object)state)) continue;
                result.add(batch);
            }
        }
        return result;
    }
}

