/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis;

import java.util.List;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessState_Base;
import org.joda.time.DateTime;

public class PhdThesisProcessState
extends PhdThesisProcessState_Base {
    private PhdThesisProcessState() {
    }

    protected PhdThesisProcessState(PhdThesisProcess process2, PhdThesisProcessStateType type, Person person, String remarks, DateTime stateDate) {
        this();
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdThesisProcessState.invalid.process", args);
        }
        String[] args1 = new String[]{};
        if (type == null) {
            throw new DomainException("error.PhdThesisProcessState.invalid.type", args1);
        }
        this.checkType(process2, type);
        this.setProcess(process2);
        super.init(person, remarks, stateDate, (PhdProcessStateType)type);
        this.setType(type);
    }

    protected void init(Person person, String remarks, DateTime stateDate) {
        throw new RuntimeException("invoke other init");
    }

    private void checkType(PhdThesisProcess process2, PhdThesisProcessStateType type) {
        PhdThesisProcessStateType currentType = process2.getActiveState();
        if (currentType != null && currentType.equals(type)) {
            throw new PhdDomainOperationException("error.PhdThesisProcessState.equals.previous.state", type.getLocalizedName());
        }
    }

    protected void disconnect() {
        this.setProcess(null);
        super.disconnect();
    }

    public boolean isLast() {
        return this.getProcess().getMostRecentState() == this;
    }

    public static PhdThesisProcessState createWithInferredStateDate(PhdThesisProcess process2, PhdThesisProcessStateType type, Person person, String remarks) {
        DateTime stateDate = null;
        PhdThesisProcessState mostRecentState = process2.getMostRecentState();
        switch (type) {
            case NEW: {
                if (process2.getWhenThesisDiscussionRequired() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.whenThesisDiscussionRequired.required", new String[0]);
                }
                stateDate = process2.getWhenThesisDiscussionRequired().toDateTimeAtStartOfDay();
                break;
            }
            case WAITING_FOR_JURY_CONSTITUTION: {
                if (process2.getWhenRequestJury() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.whenRequestJury.required", new String[0]);
                }
                stateDate = process2.getWhenRequestJury().plusMinutes(1);
                break;
            }
            case JURY_WAITING_FOR_VALIDATION: {
                if (process2.getWhenJuryDesignated() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.whenJuryDesignated.required", new String[0]);
                }
                stateDate = process2.getWhenJuryDesignated().toDateTimeAtStartOfDay();
                break;
            }
            case JURY_VALIDATED: {
                if (process2.getWhenJuryValidated() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.whenJuryValidated.required", new String[0]);
                }
                stateDate = process2.getWhenJuryValidated().toDateTimeAtStartOfDay();
                break;
            }
            case WAITING_FOR_JURY_REPORTER_FEEDBACK: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case WAITING_FOR_THESIS_MEETING_SCHEDULING: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING: {
                if (process2.getMeetingDate() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.meetingDate.required", new String[0]);
                }
                stateDate = process2.getMeetingDate();
                break;
            }
            case THESIS_DISCUSSION_DATE_SCHECULED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
                break;
            }
            case WAITING_FOR_THESIS_RATIFICATION: {
                if (process2.getDiscussionDate() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.discussionDate.required", new String[0]);
                }
                stateDate = process2.getDiscussionDate();
                break;
            }
            case WAITING_FOR_FINAL_GRADE: {
                if (process2.getWhenFinalThesisRatified() == null) {
                    throw new PhdDomainOperationException("error.phd.thesis.PhdThesisProcessState.whenFinalThesisRatified.required", new String[0]);
                }
                stateDate = process2.getWhenFinalThesisRatified().toDateTimeAtStartOfDay();
                break;
            }
            case CONCLUDED: {
                stateDate = mostRecentState.getStateDate().plusMinutes(1);
            }
        }
        return PhdThesisProcessState.createWithGivenStateDate(process2, type, person, remarks, stateDate);
    }

    public static PhdThesisProcessState createWithGivenStateDate(PhdThesisProcess process2, PhdThesisProcessStateType type, Person person, String remarks, DateTime stateDate) {
        List<PhdThesisProcessStateType> possibleNextStates = PhdThesisProcessStateType.getPossibleNextStates(process2);
        if (!possibleNextStates.contains(type)) {
            String expectedStatesDescription = PhdThesisProcessState.buildExpectedStatesDescription(possibleNextStates);
            throw new PhdDomainOperationException("phd.thesis.PhdThesisProcess.invalid.next.state", type.getLocalizedName(), expectedStatesDescription);
        }
        return new PhdThesisProcessState(process2, type, person, remarks, stateDate);
    }
}

